/*
 * Decompiled with CFR 0.152.
 */
package com.kb.gui.oms;

import com.kb.gui.TableSorter;
import com.kb.gui.Util;
import com.kb.gui.oms.AboutAction;
import com.kb.gui.oms.AppWindow;
import com.kb.gui.oms.ArchiveAction;
import com.kb.gui.oms.AskWinAction;
import com.kb.gui.oms.CloseAppWinAction;
import com.kb.gui.oms.ExitOMSAction;
import com.kb.gui.oms.LoadWinAction;
import com.kb.gui.oms.Popup;
import com.kb.gui.oms.RespModel;
import com.kb.gui.oms.RestoreAction;
import com.kb.gui.oms.Sage;
import com.kb.gui.oms.ViewNewWinAction;
import com.kb.kbddutil.KBProperties;
import com.kb.kbddutil.PrologReader;
import com.kb.oms.OMSAPI;
import com.kb.oms.OMSAnswers;
import com.kb.oms.OMSCon;
import com.kb.oms.OMSDebug;
import com.kb.owl.OWL;
import com.kb.owl.OWLParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class AskWindow
extends AppWindow
implements ActionListener {
    public static final String PFX = "omsgui.ask.";
    public static final String queryProp = "omsgui.ask.query";
    public static final String queryDef = "";
    public static final String widthProp = "omsgui.ask.queryWidth";
    public static final int widthDef = 80;
    public static final String heightProp = "omsgui.ask.respHeight";
    public static final int heightDef = 12;
    private static final String tableStr = "Table";
    private static final String textStr = "Text";
    JTextField queryField;
    JTextArea respArea;
    JTable respTable;
    JCheckBox traceBox;
    RespModel respModel;
    JTabbedPane tabPane;
    JMenuItem closeMI;
    JMenuItem cutMI;
    JMenuItem copyMI;
    JMenuItem pasteMI;
    PrologReader preader;
    Sage sage;

    public String getWindowName() {
        return "ask";
    }

    public int getWinXDef() {
        return 0;
    }

    public int getWinYDef() {
        return 0;
    }

    public int getWinWidthDef() {
        return 500;
    }

    public int getWinHeightDef() {
        return 500;
    }

    public static void main(String[] stringArray) {
        AppWindow.init();
        OMSAPI oMSAPI = null;
        try {
            oMSAPI = new OMSAPI();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            System.exit(1);
        }
        AskWindow askWindow = new AskWindow(oMSAPI, true);
        askWindow.show();
    }

    public AskWindow(AppWindow appWindow) {
        this(appWindow.getOMSAPI(), appWindow.getExitOnLastClosed());
    }

    public AskWindow(OMSAPI oMSAPI, boolean bl) {
        super("AskWindow", oMSAPI, bl);
        this.sage = Sage.getSage(oMSAPI);
        this.initGUI();
        this.positionFrame();
    }

    private void initGUI() {
        this.initMenuBar();
        this.initPane();
        this.setDisposeOnClose(true);
    }

    private void initMenuBar() {
        JMenu jMenu = Util.createJMenu('G', "General");
        Util.createMI(jMenu, "aS", new AskWinAction(this, "Open new AskWindow"));
        Util.createMI(jMenu, "cN", new ViewNewWinAction((Component)this, this.sage, "Open browser..."));
        Util.createMI(jMenu, "aL", new LoadWinAction(this));
        Util.createMI(jMenu, "aX", 'c', new CloseAppWinAction(this));
        Util.createMI(jMenu, "caX", new ExitOMSAction());
        JMenu jMenu2 = Util.createJMenu('E', "Edit");
        this.cutMI = this.createMI(jMenu2, "cX", 't', "Cut");
        this.copyMI = this.createMI(jMenu2, "cC", 'c', "Copy");
        this.pasteMI = this.createMI(jMenu2, "cV", 'p', "Paste");
        JMenu jMenu3 = Util.createJMenu('A', "Admin");
        Util.createMI(jMenu3, "caA", new ArchiveAction(this, this.omsapi));
        Util.createMI(jMenu3, "caR", new RestoreAction(this, this.omsapi));
        Util.createMI(jMenu3, "caB", new AboutAction(this));
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        this.setJMenuBar(jMenuBar);
    }

    private JMenuItem createMI(JMenu jMenu, String string, char c, String string2) {
        return Util.createMI(jMenu, this, string, c, string2);
    }

    private JMenuItem createMI(JMenu jMenu, String string, String string2) {
        return Util.createMI(jMenu, this, string, string2);
    }

    private void initPane() {
        JLabel jLabel = new JLabel("Query:");
        this.queryField = new JTextField();
        this.queryField.addActionListener(this);
        this.queryField.setText(KBProperties.get(queryProp, queryDef));
        this.traceBox = new JCheckBox("trace");
        this.traceBox.addActionListener(this);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("West", jLabel);
        jPanel.add("Center", this.queryField);
        jPanel.add("East", this.traceBox);
        this.respModel = new RespModel();
        TableSorter tableSorter = new TableSorter(this.respModel);
        this.respTable = new JTable(tableSorter);
        this.respTable.setCellSelectionEnabled(true);
        this.respTable.setSelectionMode(0);
        tableSorter.addMouseListenerToHeaderInTable(this.respTable);
        this.addPopupTo(this.respTable);
        this.respArea = new JTextArea();
        this.respArea.setEditable(false);
        this.respArea.setRows(KBProperties.get_int(heightProp, 12));
        this.addPopupTo(this.respArea);
        this.tabPane = new JTabbedPane();
        this.tabPane.add(tableStr, new JScrollPane(this.respTable));
        this.tabPane.add(textStr, new JScrollPane(this.respArea));
        this.setTableEnabled(false);
        JLabel jLabel2 = new JLabel("Response:");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add("North", jLabel2);
        jPanel2.add("Center", this.tabPane);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add("North", jPanel);
        container.add("Center", jPanel2);
        this.pack();
    }

    private void addPopupTo(Component component) {
        Popup popup = new Popup(component, this.sage);
        popup.add(1);
    }

    private void processQuery() {
        this.processKBLQuery();
    }

    private void processKBLQuery() {
        try {
            OWLParser oWLParser = new OWLParser(new StringReader(this.queryField.getText()));
            OMSAnswers oMSAnswers = this.omsapi.ask(oWLParser.readExpr());
            this.respArea.setText(this.toStringTable(oMSAnswers));
            this.respModel.setData(oMSAnswers);
            this.setTableEnabled(oMSAnswers != null && oMSAnswers.numAnswers() > 0);
        }
        catch (Error error) {
            this.respArea.setText("\"" + this.queryField.getText() + "\" caused this error:\n" + error.toString());
            error.printStackTrace();
            this.setTableEnabled(false);
        }
        catch (Exception exception) {
            try {
                StringWriter stringWriter = new StringWriter();
                exception.printStackTrace(new PrintWriter(stringWriter));
                stringWriter.close();
                this.respArea.setText(stringWriter.toString());
                this.setTableEnabled(false);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    private void cut() {
        if (this.queryField.getSelectedText() != null) {
            this.queryField.cut();
        } else {
            this.respArea.cut();
        }
    }

    private void copy() {
        if (this.queryField.getSelectedText() != null) {
            this.queryField.copy();
        } else {
            this.respArea.copy();
        }
    }

    private void paste() {
        this.queryField.paste();
    }

    private void toggleTrace() {
        if (this.traceBox.isSelected()) {
            OMSDebug.trace((OMSCon)this.omsapi);
        } else {
            OMSDebug.notrace((OMSCon)this.omsapi);
        }
    }

    private String toStringTable(OMSAnswers oMSAnswers) {
        if (oMSAnswers == null) {
            return "No answers found for query \"" + this.queryField.getText() + "\".";
        }
        if (oMSAnswers.numAnswers() == 0) {
            return "The statement \"" + this.queryField.getText() + "\" is true.";
        }
        StringBuffer stringBuffer = new StringBuffer();
        OWL[][] oWLArray = oMSAnswers.answersAsArray();
        int n = 0;
        while (n < oWLArray.length) {
            int n2 = 0;
            while (n2 < oWLArray[n].length) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(oWLArray[n][n2].toString());
                ++n2;
            }
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    private void setTableEnabled(boolean bl) {
        int n = this.tabPane.indexOfTab(tableStr);
        int n2 = this.tabPane.indexOfTab(textStr);
        this.tabPane.setEnabledAt(n, bl);
        int n3 = bl ? n : n2;
        this.tabPane.setSelectedIndex(n3);
        this.tabPane.revalidate();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.queryField) {
            this.processQuery();
        } else if (object == this.cutMI) {
            this.cut();
        } else if (object == this.copyMI) {
            this.copy();
        } else if (object == this.pasteMI) {
            this.paste();
        } else if (object == this.traceBox) {
            this.toggleTrace();
        }
    }
}

