/*
 * Decompiled with CFR 0.152.
 */
package com.kb.gui.oms;

import com.kb.gui.ImageIconKBI;
import com.kb.gui.OWIFrame;
import com.kb.gui.SplashPane;
import com.kb.gui.Util;
import com.kb.gui.oms.ExitOMSAction;
import com.kb.kbddutil.KBProperties;
import com.kb.oms.OMSAPI;
import com.ow.gui.Typematic;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class AppWindow
extends OWIFrame {
    public static final String PFX = "omsgui.";
    public static final String expireProp = "omsgui.typematicExpire";
    public static final String foregroundProp = "omsgui.foreground";
    public static final String foregroundDef = "#000000";
    public static final String defaultImage = "oms/omsb.gif";
    private static boolean firstWindowHandled = false;
    private static int appWindowCount = 0;
    private static SplashPane splashPane;
    boolean exitOnLastClosed;
    boolean disposed;
    OMSAPI omsapi;
    static /* synthetic */ Class class$com$kb$gui$oms$AppWindow;

    public AppWindow() {
        this("");
    }

    public AppWindow(String string) {
        this(string, null, true);
    }

    public AppWindow(String string, AppWindow appWindow) {
        this(string, appWindow.getOMSAPI(), appWindow.getExitOnLastClosed());
    }

    public AppWindow(String string, OMSAPI oMSAPI, boolean bl) {
        super(string);
        AppWindow.init();
        this.exitOnLastClosed = bl;
        this.omsapi = oMSAPI;
        this.disposed = true;
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                AppWindow.handleFirstWindowOpening();
            }

            public void windowClosing(WindowEvent windowEvent) {
                AppWindow.this.dispose();
            }
        });
    }

    public OMSAPI getOMSAPI() {
        return this.omsapi;
    }

    private static void handleFirstWindowOpening() {
        if (splashPane != null) {
            splashPane.dispose();
        }
    }

    public static void init() {
        AppWindow.init(null);
    }

    public static void init(JComponent jComponent) {
        try {
            System.setErr(System.out);
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            Util.setUIFont("MS Sans Serif", 0, 11);
            Util.replaceUIForeground(foregroundDef, KBProperties.get(foregroundProp, foregroundDef));
            UIManager.put("EditorPane.selectionBackground", UIManager.get("TextArea.selectionBackground"));
            UIManager.put("EditorPane.selectionForeground", UIManager.get("TextArea.selectionForeground"));
            Typematic.setDefaultExpire(KBProperties.get_int(expireProp, Typematic.getDefaultExpire()));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        Class clazz = class$com$kb$gui$oms$AppWindow == null ? (class$com$kb$gui$oms$AppWindow = AppWindow.class$("com.kb.gui.oms.AppWindow")) : class$com$kb$gui$oms$AppWindow;
        synchronized (clazz) {
            if (splashPane == null) {
                splashPane = new SplashPane();
            }
        }
    }

    private static JComponent makeDefaultPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel("Loading...", new ImageIconKBI(defaultImage), 0);
        jLabel.setHorizontalTextPosition(0);
        jLabel.setVerticalTextPosition(3);
        jLabel.setOpaque(true);
        jLabel.setForeground(Color.white);
        jLabel.setBackground(Color.black);
        Border border = BorderFactory.createRaisedBevelBorder();
        Border border2 = BorderFactory.createEmptyBorder(5, 5, 6, 6);
        Border border3 = BorderFactory.createEtchedBorder();
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border, border3);
        CompoundBorder compoundBorder2 = BorderFactory.createCompoundBorder(compoundBorder, border2);
        jPanel.setBorder(compoundBorder2);
        jPanel.add("Center", jLabel);
        return jPanel;
    }

    public void positionFrame() {
        int n = KBProperties.get_int(this.getWinXProp(), this.getWinXDef());
        int n2 = KBProperties.get_int(this.getWinYProp(), this.getWinYDef());
        int n3 = KBProperties.get_int(this.getWinWidthProp(), this.getWinWidthDef());
        int n4 = KBProperties.get_int(this.getWinHeightProp(), this.getWinHeightDef());
        ((Component)this).setBounds(n, n2, n3, n4);
    }

    public void saveWindowMetrics() {
        Rectangle rectangle = this.getBounds();
        KBProperties.put(this.getWinXProp(), rectangle.x);
        KBProperties.put(this.getWinYProp(), rectangle.y);
        KBProperties.put(this.getWinWidthProp(), rectangle.width);
        KBProperties.put(this.getWinHeightProp(), rectangle.height);
        KBProperties.saveFamily(this.getWindowPFX());
    }

    public String getWindowPFX() {
        return PFX + this.getWindowName() + ".win.";
    }

    public String getWindowName() {
        return this.getTitle().replace(' ', '_');
    }

    public int getWinXDef() {
        return 0;
    }

    public int getWinYDef() {
        return 0;
    }

    public int getWinWidthDef() {
        return 500;
    }

    public int getWinHeightDef() {
        return 500;
    }

    public String getWinXProp() {
        return this.getWindowPFX() + "x";
    }

    public String getWinYProp() {
        return this.getWindowPFX() + "y";
    }

    public String getWinWidthProp() {
        return this.getWindowPFX() + "width";
    }

    public String getWinHeightProp() {
        return this.getWindowPFX() + "height";
    }

    public boolean getExitOnLastClosed() {
        return this.exitOnLastClosed;
    }

    public void pack() {
        super.pack();
        this.markUndisposed();
    }

    public void show() {
        super.show();
        this.markUndisposed();
    }

    private void markUndisposed() {
        if (this.disposed) {
            this.disposed = false;
            if (this.exitOnLastClosed) {
                ++appWindowCount;
            }
        }
    }

    public void dispose() {
        this.saveWindowMetrics();
        super.dispose();
        if (!this.disposed) {
            this.disposed = true;
            if (this.exitOnLastClosed && --appWindowCount == 0) {
                this.exit();
            }
        }
    }

    public void exit() {
        new ExitOMSAction().actionPerformed(new ActionEvent(this, 0, null));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

