/*
 * Decompiled with CFR 0.152.
 */
package com.kb.gui.oms;

import com.kb.gui.Util;
import com.kb.kbddutil.KBProperties;
import com.ow.gui.OWImage;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class AboutAction
extends AbstractAction {
    JDialog about;
    public static final String installDirProp = "com.kb.installDir";
    public static final String title = "About the OMS Browser";
    public static final String defaultImage = "oms/omsb.gif";
    public static final String patchDirName = "patches";
    public static final String baseFileName = "base";

    public AboutAction(Frame frame) {
        super("About OMS...");
        this.about = this.newAboutPane(frame);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.about.show();
    }

    public static void main(String[] stringArray) {
        new AboutAction(null).actionPerformed(null);
    }

    public JDialog newAboutPane(Frame frame) {
        JDialog jDialog = new JDialog(frame, title, true);
        jDialog.setContentPane(this.makeDefaultPane());
        jDialog.pack();
        Util.center(jDialog);
        return jDialog;
    }

    private JComponent makeDefaultPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(OWImage.splashIcon, 0);
        jLabel.setOpaque(true);
        Border border = BorderFactory.createRaisedBevelBorder();
        Border border2 = BorderFactory.createEmptyBorder(5, 5, 6, 6);
        Border border3 = BorderFactory.createEtchedBorder();
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border, border3);
        CompoundBorder compoundBorder2 = BorderFactory.createCompoundBorder(compoundBorder, border2);
        jPanel.setBorder(compoundBorder2);
        jPanel.add("West", jLabel);
        jPanel.add("Center", this.defaultTextPane());
        return jPanel;
    }

    private JComponent defaultTextPane() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setText(this.defaultText());
        return new JScrollPane(jTextArea);
    }

    private String defaultText() {
        StringBuffer stringBuffer = new StringBuffer("Version and Patch Information:\n\n");
        File file = this.getPatchDirectory();
        if (!file.isDirectory()) {
            stringBuffer.append("No information could be found.\n (");
            stringBuffer.append(file.toString());
            stringBuffer.append(" is not a directory)\n");
            return stringBuffer.toString();
        }
        File file2 = new File(file, baseFileName);
        if (!file2.isFile()) {
            stringBuffer.append("No base version information could be found.\n (");
            stringBuffer.append(file2.toString());
            stringBuffer.append(" is not a file)\n");
        } else {
            stringBuffer.append(this.textOf(file2));
        }
        stringBuffer.append('\n');
        File[] fileArray = this.getPatchFiles(file);
        if (fileArray.length == 0) {
            stringBuffer.append("No patches loaded.\n");
        } else {
            stringBuffer.append("Patches loaded:\n");
            int n = 0;
            while (n < fileArray.length) {
                stringBuffer.append(fileArray[n].getName());
                stringBuffer.append('\n');
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    private File getPatchDirectory() {
        return new File(KBProperties.get(installDirProp), patchDirName);
    }

    private File[] getPatchFiles(File file) {
        return file.listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return !string.equals(AboutAction.baseFileName);
            }
        });
    }

    private String textOf(File file) {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append('\n');
            }
            bufferedReader.close();
            string = stringBuffer.toString();
        }
        catch (Exception exception) {
            string = "(error reading " + file.toString() + ")\n";
        }
        return string;
    }
}

