/*
 * Decompiled with CFR 0.152.
 */
package com.kb.gui.hier;

import com.kb.gui.FocusBorder;
import com.kb.gui.event.SelectionEvent;
import com.kb.gui.event.SelectionListener;
import com.kb.gui.hier.HNode;
import com.kb.gui.hier.SuperList;
import com.kb.gui.oms.Sage;
import com.kb.owl.OWL;
import com.ow.gui.Typematic;
import java.awt.BorderLayout;
import java.awt.event.FocusListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class SuperView
extends JPanel
implements ListSelectionListener {
    JLabel title;
    SuperList superList;
    Sage sage;
    String pred;
    OWL root;
    Vector selListeners;

    public SuperView(Sage sage, String string, OWL oWL) {
        this.sage = sage;
        this.root = oWL;
        this.pred = string;
        this.initGUI();
        this.selListeners = new Vector();
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.superList = new SuperList(this.root, this.pred, this.sage);
        new Typematic(this.superList);
        JScrollPane jScrollPane = new JScrollPane(this.superList);
        FocusBorder focusBorder = new FocusBorder(jScrollPane, this.superList);
        this.title = new JLabel();
        this.title.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setTitle();
        this.add("North", this.title);
        this.add("Center", jScrollPane);
    }

    public HNode getSelectedHNode() {
        return (HNode)this.superList.getSelectedValue();
    }

    public boolean hasFocus() {
        return this.superList.hasFocus();
    }

    public void setRoot(OWL oWL) {
        this.root = oWL;
        this.setTitle();
        this.superList.setRoot(this.root);
        this.revalidate();
    }

    public void setRoot(HNode hNode) {
        this.root = hNode.getTerm();
        this.setTitle();
        this.superList.setRoot(hNode);
        this.revalidate();
    }

    public void refresh() {
        this.superList.refresh();
    }

    public SuperList getSuperList() {
        return this.superList;
    }

    private void setTitle() {
        this.title.setText("Parents of " + this.root + ':');
    }

    public void addChildSelectionListener(SelectionListener selectionListener) {
        this.selListeners.add(selectionListener);
    }

    public void addChildFocusListener(FocusListener focusListener) {
        this.superList.addFocusListener(focusListener);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.notifyListeners(new SelectionEvent(this.superList, this.getSelectedHNode()));
    }

    private void notifyListeners(SelectionEvent selectionEvent) {
        Enumeration enumeration = this.selListeners.elements();
        while (enumeration.hasMoreElements()) {
            SelectionListener selectionListener = (SelectionListener)enumeration.nextElement();
            selectionListener.selectionChanged(selectionEvent);
        }
    }
}

