/*
 * Decompiled with CFR 0.152.
 */
package com.kb.gui.hier;

import com.kb.gui.FocusBorder;
import com.kb.gui.event.SelectionEvent;
import com.kb.gui.event.SelectionListener;
import com.kb.gui.hier.HNode;
import com.kb.gui.hier.SubTree;
import com.kb.gui.oms.Sage;
import com.kb.owl.OWL;
import com.ow.gui.Typematic;
import java.awt.BorderLayout;
import java.awt.event.FocusListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

class SubView
extends JPanel
implements TreeSelectionListener {
    JLabel title;
    SubTree subTree;
    JPanel topBar;
    Sage sage;
    String pred;
    OWL root;
    Vector selListeners;
    static /* synthetic */ Class class$javax$swing$JScrollPane;

    public SubView(Sage sage, String string, OWL oWL) {
        this.sage = sage;
        this.root = oWL;
        this.pred = string;
        this.initGUI();
        this.selListeners = new Vector();
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.subTree = new SubTree(this.root, this.pred, this.sage);
        this.subTree.addTreeSelectionListener(this);
        new Typematic(this.subTree);
        JScrollPane jScrollPane = new JScrollPane(this.subTree);
        FocusBorder focusBorder = new FocusBorder(jScrollPane, this.subTree);
        this.title = new JLabel();
        this.title.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setTitle();
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(5);
        this.topBar = new JPanel(borderLayout);
        this.topBar.add("Center", this.title);
        this.add("North", this.topBar);
        this.add("Center", jScrollPane);
    }

    public JPanel getTopBar() {
        return this.topBar;
    }

    public HNode getSelectedHNode() {
        TreePath treePath = this.subTree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        return (HNode)treePath.getLastPathComponent();
    }

    public boolean hasFocus() {
        return this.subTree.hasFocus();
    }

    public void setRoot(OWL oWL) {
        this.root = oWL;
        this.setTitle();
        this.subTree.setRoot(oWL);
        this.revalidate();
    }

    public void setRoot(HNode hNode) {
        this.root = hNode.getTerm();
        this.setTitle();
        this.subTree.setRoot(hNode);
        this.revalidate();
    }

    public SubTree refresh() {
        this.subTree.refresh();
        JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JScrollPane == null ? (class$javax$swing$JScrollPane = SubView.class$("javax.swing.JScrollPane")) : class$javax$swing$JScrollPane, this.subTree);
        this.remove(jScrollPane);
        this.subTree = new SubTree(this.root, this.pred, this.sage);
        this.subTree.addTreeSelectionListener(this);
        new Typematic(this.subTree);
        jScrollPane = new JScrollPane(this.subTree);
        FocusBorder focusBorder = new FocusBorder(jScrollPane, this.subTree);
        this.add("Center", jScrollPane);
        this.revalidate();
        return this.subTree;
    }

    public SubTree getSubTree() {
        return this.subTree;
    }

    private void setTitle() {
        this.title.setText("Children of " + this.root + ':');
    }

    public void addChildSelectionListener(SelectionListener selectionListener) {
        this.selListeners.add(selectionListener);
    }

    public void addChildFocusListener(FocusListener focusListener) {
        this.subTree.addFocusListener(focusListener);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.notifyListeners(new SelectionEvent(this.subTree, this.getSelectedHNode()));
    }

    private void notifyListeners(SelectionEvent selectionEvent) {
        Enumeration enumeration = this.selListeners.elements();
        while (enumeration.hasMoreElements()) {
            SelectionListener selectionListener = (SelectionListener)enumeration.nextElement();
            selectionListener.selectionChanged(selectionEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

