/*
 * Decompiled with CFR 0.152.
 */
package com.kb.gui.hier;

import com.kb.gui.Util;
import com.kb.gui.event.SelectionListener;
import com.kb.gui.hier.HNode;
import com.kb.gui.hier.SubTree;
import com.kb.gui.hier.SubView;
import com.kb.gui.hier.SuperView;
import com.kb.gui.oms.Popup;
import com.kb.gui.oms.Sage;
import com.kb.oms.OMSAPI;
import com.kb.owl.OWL;
import com.kb.owl.Symbol;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class HierView
extends JSplitPane
implements ActionListener {
    SubView subView;
    SuperView superView;
    JButton refreshButton;
    Popup subPopup;
    Popup superPopup;
    Sage sage;

    public HierView(Sage sage, String string, OWL oWL) {
        super(0, new SubView(sage, string, oWL), new SuperView(sage, string, oWL));
        this.sage = sage;
        this.subView = (SubView)this.getLeftComponent();
        this.superView = (SuperView)this.getRightComponent();
        this.subPopup = this.createPopup(this.subView.getSubTree());
        this.superPopup = this.createPopup(this.superView.getSuperList());
        JPanel jPanel = this.subView.getTopBar();
        this.refreshButton = Util.createSmallButton("refresh");
        this.refreshButton.addActionListener(this);
        jPanel.add("East", this.refreshButton);
    }

    private Popup createPopup(Component component) {
        Popup popup = new Popup(component, this.sage);
        popup.add(0);
        popup.add(1);
        popup.add(2);
        return popup;
    }

    public HNode getSelectedHNode() {
        if (this.subView.hasFocus()) {
            return this.subView.getSelectedHNode();
        }
        if (this.superView.hasFocus()) {
            return this.superView.getSelectedHNode();
        }
        return null;
    }

    public void setRoot(OWL oWL) {
        this.subView.setRoot(oWL);
        this.superView.setRoot(oWL);
        this.resetToPreferredSizes();
    }

    public void setRoot(HNode hNode) {
        this.subView.setRoot(hNode);
        this.superView.setRoot(hNode);
        this.resetToPreferredSizes();
    }

    public void resetToPreferredSizes() {
        double d;
        double d2 = this.getTopComponent().getPreferredSize().getHeight();
        double d3 = d2 + (d = this.getBottomComponent().getPreferredSize().getHeight());
        if (d3 == 0.0) {
            d3 = 1.0;
        }
        this.setDividerLocation(d2 / d3);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.resetToPreferredSizes();
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 2) {
                Sage sage = Sage.getSage(new OMSAPI());
                String string = stringArray[0];
                Symbol symbol = new Symbol(stringArray[1]);
                HierView hierView = new HierView(sage, string, symbol);
                JFrame jFrame = new JFrame("HierView: " + string);
                jFrame.setContentPane(hierView);
                jFrame.pack();
                jFrame.show();
            } else {
                System.out.println("Usage:  java HierView <predicate> <rootconstant>");
                System.out.println("Example:  java HierView genls1 Organization");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.refreshButton) {
            this.refresh();
        }
    }

    protected void refresh() {
        SubTree subTree = this.subView.refresh();
        this.subPopup = this.createPopup(subTree);
        this.superView.refresh();
    }

    public void addChildSelectionListener(SelectionListener selectionListener) {
        this.subView.addChildSelectionListener(selectionListener);
        this.superView.addChildSelectionListener(selectionListener);
    }

    public void addChildFocusListener(FocusListener focusListener) {
        this.subView.addChildFocusListener(focusListener);
        this.superView.addChildFocusListener(focusListener);
    }
}

