/*
 * Decompiled with CFR 0.152.
 */
package com.kb.gui.hier;

import com.kb.gui.Util;
import com.kb.gui.oms.Sage;
import com.kb.owl.OWL;
import com.kb.owl.Symbol;
import com.ow.util.TrivialComparator;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class HNode {
    static Hashtable nodes = new Hashtable();
    static HNode nullNode = new HNode(null, null, null);
    Sage sage;
    OWL term;
    String pred;
    HNode[] subs;
    HNode[] supers;

    private HNode(OWL oWL, String string, Sage sage) {
        this.term = oWL;
        this.pred = string;
        this.sage = sage;
    }

    public static HNode getHNode(OWL oWL, String string, Sage sage) {
        if (oWL == null || string == null || sage == null) {
            return nullNode;
        }
        HNode hNode = null;
        Object v = nodes.get(oWL);
        if (v == null) {
            hNode = HNode.createHNode(oWL, string, sage);
        } else if (v instanceof HNode) {
            HNode hNode2 = (HNode)v;
            hNode = hNode2.getSage() == sage && hNode2.getPred() == string ? hNode2 : HNode.createHNode(oWL, string, sage);
        } else if (v instanceof Vector) {
            Vector vector = (Vector)v;
            int n = 0;
            boolean bl = false;
            HNode hNode3 = null;
            while (n < vector.size() && !bl) {
                hNode3 = (HNode)vector.elementAt(n);
                boolean bl2 = bl = hNode3.getSage() == sage && hNode3.getPred() == string;
                if (bl) continue;
                ++n;
            }
            hNode = bl ? hNode3 : HNode.createHNode(oWL, string, sage);
        }
        return hNode;
    }

    private static HNode createHNode(OWL oWL, String string, Sage sage) {
        HNode hNode = new HNode(oWL, string, sage);
        Object v = nodes.get(oWL);
        if (v == null) {
            nodes.put(oWL, hNode);
        } else if (v instanceof HNode) {
            Vector<Object> vector = new Vector<Object>();
            vector.add(v);
            vector.add(hNode);
            nodes.put(oWL, vector);
        } else if (v instanceof Vector) {
            Vector vector = (Vector)v;
            vector.add(hNode);
            nodes.put(oWL, vector);
        }
        return hNode;
    }

    public int getSubCount() {
        this.findSubsIfNeeded();
        return this.subs.length;
    }

    public HNode getSubAt(int n) {
        this.findSubsIfNeeded();
        return this.subs[n];
    }

    public int getIndexOfSub(HNode hNode) {
        int n = this.subs.length - 1;
        while (n >= 0 && this.subs[n] != hNode) {
            ++n;
        }
        return n;
    }

    public HNode[] getSupers() {
        this.findSupersIfNeeded();
        HNode[] hNodeArray = new HNode[this.supers.length];
        System.arraycopy(this.supers, 0, hNodeArray, 0, this.supers.length);
        return hNodeArray;
    }

    public static void refreshAll() {
        nodes = new Hashtable();
    }

    public static void refreshAll(HNode hNode) {
        HNode.refreshAllRec(nodes.elements(), hNode);
        hNode.refresh();
    }

    private static void refreshAllRec(Enumeration enumeration, HNode hNode) {
        String string = hNode.getPred();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof HNode) {
                HNode hNode2 = (HNode)e;
                if (!hNode2.getPred().equals(string) || hNode2 == hNode) continue;
                HNode.removeNode(hNode2);
                continue;
            }
            if (!(e instanceof Vector)) continue;
            HNode.refreshAllRec(((Vector)e).elements(), hNode);
        }
    }

    private static void removeNode(HNode hNode) {
        Object v = nodes.get(hNode.getTerm());
        if (v == null) {
            return;
        }
        if (v instanceof HNode) {
            nodes.remove(hNode.getTerm());
        } else if (v instanceof Vector) {
            Vector vector = (Vector)v;
            vector.remove(hNode);
            if (vector.size() == 1) {
                nodes.remove(hNode.getTerm());
                nodes.put(hNode.getTerm(), hNode);
            }
        }
    }

    public void refresh() {
        if (this != nullNode) {
            this.supers = null;
            this.subs = null;
        }
    }

    public OWL getTerm() {
        return this.term;
    }

    public String toString() {
        return this.term == null ? "null" : this.term.toString();
    }

    public Sage getSage() {
        return this.sage;
    }

    public String getPred() {
        return this.pred;
    }

    private void findSubsIfNeeded() {
        if (this.subs != null) {
            return;
        }
        TrivialComparator trivialComparator = TrivialComparator.instance;
        Object[] objectArray = this.sage.getSubs(this.term, this.pred);
        Arrays.sort(objectArray, trivialComparator);
        objectArray = Util.removeDupes(objectArray, trivialComparator);
        this.subs = new HNode[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            OWL oWL = objectArray[n] instanceof OWL ? (OWL)objectArray[n] : new Symbol(objectArray[n].toString());
            this.subs[n] = HNode.getHNode(oWL, this.pred, this.sage);
            ++n;
        }
    }

    private void findSupersIfNeeded() {
        if (this.supers != null) {
            return;
        }
        TrivialComparator trivialComparator = TrivialComparator.instance;
        Object[] objectArray = this.sage.getSupers(this.term, this.pred);
        Arrays.sort(objectArray, trivialComparator);
        objectArray = Util.removeDupes(objectArray, trivialComparator);
        this.supers = new HNode[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            OWL oWL = objectArray[n] instanceof OWL ? (OWL)objectArray[n] : new Symbol(objectArray[n].toString());
            this.supers[n] = HNode.getHNode(oWL, this.pred, this.sage);
            ++n;
        }
    }

    static {
        HNode.nullNode.supers = new HNode[0];
        HNode.nullNode.subs = HNode.nullNode.supers;
    }
}

