/*
 * Decompiled with CFR 0.152.
 */
package com.kb.gui;

import com.ow.util.TrivialComparator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;

public class Util {
    public static final int maxDispLen = 20;

    public static void setUIFont(String string, int n, int n2) {
        Util.setUIFont(new FontUIResource(string, n, n2));
    }

    public static void setUIFont(FontUIResource fontUIResource) {
        Enumeration enumeration = UIManager.getDefaults().keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object object = UIManager.get(k);
            if (!(object instanceof FontUIResource)) continue;
            UIManager.put(k, fontUIResource);
        }
    }

    public static void setUIForeground(String string) {
        Util.setUIForeground(Util.toColorUIResource(string));
    }

    public static void setUIForeground(ColorUIResource colorUIResource) {
        Enumeration enumeration = UIManager.getDefaults().keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object object = UIManager.get(k);
            if (!(k instanceof String) || !((String)k).endsWith("foreground")) continue;
            UIManager.put(k, colorUIResource);
        }
    }

    public static void replaceUIForeground(ColorUIResource colorUIResource, ColorUIResource colorUIResource2) {
        if (colorUIResource == null || colorUIResource2 == null) {
            return;
        }
        Enumeration enumeration = UIManager.getDefaults().keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object object = UIManager.get(k);
            if (!(k instanceof String) || !((String)k).endsWith("oreground") || !object.equals(colorUIResource)) continue;
            UIManager.put(k, colorUIResource2);
        }
    }

    public static void replaceUIForeground(String string, String string2) {
        Util.replaceUIForeground(Util.toColorUIResource(string), Util.toColorUIResource(string2));
    }

    public static ColorUIResource toColorUIResource(String string) {
        if (string.charAt(0) != '#') {
            return null;
        }
        String string2 = "0x";
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            n = Integer.decode(string2 + string.substring(1, 3));
            n2 = Integer.decode(string2 + string.substring(3, 5));
            n3 = Integer.decode(string2 + string.substring(5, 7));
        }
        catch (Exception exception) {
            return null;
        }
        return new ColorUIResource(n, n2, n3);
    }

    public static Object getSelectedItem(Component component) {
        Object object = null;
        if (component instanceof JList) {
            JList jList = (JList)component;
            object = jList.getSelectedValue();
        } else if (component instanceof JTree) {
            JTree jTree = (JTree)component;
            TreePath treePath = jTree.getSelectionPath();
            object = treePath == null ? null : treePath.getLastPathComponent();
        } else if (component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            object = jTextComponent.getSelectedText();
        } else if (component instanceof JTable) {
            JTable jTable = (JTable)component;
            object = jTable.getValueAt(jTable.getSelectedRow(), jTable.getSelectedColumn());
        }
        return object;
    }

    public static void setFontStyle(JComponent jComponent, int n) {
        Font font = jComponent.getFont();
        if (font.getStyle() == n) {
            return;
        }
        Font font2 = new Font(font.getName(), n, font.getSize());
        jComponent.setFont(font2);
    }

    public static void incFontSize(JComponent jComponent, int n) {
        if (n == 0) {
            return;
        }
        Font font = jComponent.getFont();
        int n2 = font.getSize() + n;
        if (n2 <= 0) {
            return;
        }
        Font font2 = new Font(font.getName(), font.getStyle(), n2);
        jComponent.setFont(font2);
    }

    public static void adjustFont(JComponent jComponent, int n, int n2) {
        Font font = jComponent.getFont();
        if (font.getStyle() == n && n2 == 0) {
            return;
        }
        int n3 = font.getSize() + n2;
        if (n3 <= 0) {
            return;
        }
        Font font2 = new Font(font.getName(), n, n3);
        jComponent.setFont(font2);
    }

    public static JButton createSmallButton(String string) {
        JButton jButton = new JButton(string);
        jButton.setMargin(new Insets(0, 2, 0, 0));
        return jButton;
    }

    public static JMenu createJMenu(char c, String string) {
        JMenu jMenu = new JMenu(string);
        jMenu.setMnemonic(c);
        return jMenu;
    }

    public static JMenuItem createMI(JMenu jMenu, ActionListener actionListener, String string, String string2) {
        return Util.createMI(jMenu, actionListener, string, Util.getBaseChar(string), string2);
    }

    public static JMenuItem createMI(JMenu jMenu, String string, Action action) {
        return Util.createMI(jMenu, string, Util.getBaseChar(string), action);
    }

    public static JMenuItem createMI(JMenu jMenu, String string, char c, Action action) {
        JMenuItem jMenuItem = jMenu.add(action);
        jMenuItem.setMnemonic(c);
        KeyStroke keyStroke = Util.getKeyStroke(string);
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        return jMenuItem;
    }

    public static JMenuItem createMI(JMenu jMenu, ActionListener actionListener, String string, char c, String string2) {
        JMenuItem jMenuItem = new JMenuItem(string2);
        jMenuItem.addActionListener(actionListener);
        jMenuItem.setMnemonic(c);
        KeyStroke keyStroke = Util.getKeyStroke(string);
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        jMenu.add(jMenuItem);
        return jMenuItem;
    }

    public static JButton createButton(String string, char c, ActionListener actionListener) {
        JButton jButton = new JButton(string);
        jButton.setMnemonic(c);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public static JLabel createMnemLabel(String string, String string2, Component component) {
        JLabel jLabel = new JLabel(string);
        KeyStroke keyStroke = Util.getKeyStroke(string2);
        if (keyStroke != null) {
            jLabel.setDisplayedMnemonic(keyStroke.getKeyCode());
        }
        jLabel.setLabelFor(component);
        return jLabel;
    }

    public static KeyStroke getKeyStroke(String string) {
        if (string.indexOf(120) != -1) {
            return null;
        }
        char c = Util.getBaseChar(string);
        int n = 0;
        int n2 = 0;
        while (n2 < string.length() - 1) {
            switch (string.charAt(n2)) {
                case 'a': {
                    n |= 8;
                    break;
                }
                case 'c': {
                    n |= 2;
                    break;
                }
                case 's': {
                    n |= 1;
                    break;
                }
            }
            ++n2;
        }
        return KeyStroke.getKeyStroke((int)c, n);
    }

    public static char getBaseChar(String string) {
        return string.charAt(string.length() - 1);
    }

    public static void center(Window window) {
        Dimension dimension = window.getPreferredSize();
        Rectangle rectangle = Util.center(new Rectangle(dimension));
        ((Component)window).setBounds(rectangle);
    }

    public static Rectangle center(Rectangle rectangle) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        rectangle.translate((dimension.width - rectangle.width) / 2, (dimension.height - rectangle.height) / 2);
        return rectangle;
    }

    public static Object[] removeDupes(Object[] objectArray, Comparator comparator) {
        if (objectArray.length <= 1) {
            return objectArray;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length - 1) {
            if (comparator.compare(objectArray[n2], objectArray[n2 + 1]) == 0) {
                objectArray[n2] = null;
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[objectArray.length - n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < objectArray.length) {
            if (objectArray[n4] != null) {
                objectArray2[n3] = objectArray[n4];
                ++n3;
            }
            ++n4;
        }
        return objectArray2;
    }

    public static Object[] removeDupes(Object[] objectArray) {
        return Util.removeDupes(objectArray, TrivialComparator.instance);
    }

    public static String dispString(String string) {
        if (string.length() <= 20) {
            return string;
        }
        String string2 = string.substring(0, 17);
        string2 = string2 + "...";
        return string2;
    }
}

