/*
 * Decompiled with CFR 0.152.
 */
package com.kb.gui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class TaskMonitor {
    Thread task;
    Vector textComps;
    PipedWriter pOut;
    PipedReader pIn;
    PrintWriter writer;
    Hashtable buffers;

    public TaskMonitor() {
        this(null);
    }

    public TaskMonitor(JTextComponent jTextComponent) {
        try {
            this.pIn = new PipedReader();
            this.pOut = new PipedWriter(this.pIn);
            this.writer = new PrintWriter((Writer)this.pOut, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.buffers = new Hashtable();
        this.textComps = new Vector();
        this.addJTextComponent(jTextComponent);
    }

    public void addJTextComponent(JTextComponent jTextComponent) {
        if (jTextComponent != null) {
            this.textComps.addElement(jTextComponent);
        }
    }

    public void removeJTextComponent(JTextComponent jTextComponent) {
        this.textComps.removeElement(jTextComponent);
    }

    public void setTask(Thread thread) {
        this.task = thread;
    }

    public PrintWriter getPrintWriter() {
        return this.writer;
    }

    public void close() {
        this.writer.close();
    }

    public void go() {
        this.task.start();
        new Thread(){

            public void run() {
                BufferedReader bufferedReader = new BufferedReader(TaskMonitor.this.pIn);
                Object[] objectArray = TaskMonitor.this.textComps.toArray();
                JTextComponent[] jTextComponentArray = new JTextComponent[objectArray.length];
                int n = 0;
                while (n < objectArray.length) {
                    jTextComponentArray[n] = (JTextComponent)objectArray[n];
                    ++n;
                }
                try {
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                        int n2 = 0;
                        while (n2 < jTextComponentArray.length) {
                            JTextComponent jTextComponent;
                            if (jTextComponentArray[n2] instanceof JTextArea) {
                                jTextComponent = (JTextArea)jTextComponentArray[n2];
                                ((JTextArea)jTextComponent).append(string);
                                ((JTextArea)jTextComponent).append("\n");
                            } else if (jTextComponentArray[n2] instanceof JTextField) {
                                jTextComponent = (JTextField)jTextComponentArray[n2];
                                jTextComponent.setText(string);
                            } else if (jTextComponentArray[n2] instanceof JEditorPane) {
                                jTextComponent = (JEditorPane)jTextComponentArray[n2];
                                StringBuffer stringBuffer = TaskMonitor.this.getBuffer((JEditorPane)jTextComponent);
                                stringBuffer.append(string);
                                ((JEditorPane)jTextComponent).setText(stringBuffer.toString());
                            }
                            ++n2;
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }.start();
    }

    private StringBuffer getBuffer(JEditorPane jEditorPane) {
        StringBuffer stringBuffer = (StringBuffer)this.buffers.get(jEditorPane);
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer(jEditorPane.getText());
            this.buffers.put(jEditorPane, stringBuffer);
        }
        return stringBuffer;
    }
}

