/*
 * Decompiled with CFR 0.152.
 */
package com.kb.gui;

import com.kb.gui.Util;
import com.ow.gui.Typematic;
import com.ow.util.TrivialComparator;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ObjChooser
extends JDialog
implements ActionListener,
KeyListener,
MouseListener {
    String message;
    Object[] selectionValues;
    Object selectedValue;
    JButton ok;
    JButton cancel;
    JList selList;

    public ObjChooser(Frame frame, String string, String string2, boolean bl, Object[] objectArray) {
        this(frame, string, string2, bl, false, objectArray);
    }

    public ObjChooser(Frame frame, String string, String string2, boolean bl, boolean bl2, Object[] objectArray) {
        super(frame, string, bl);
        this.message = string2;
        this.selectionValues = objectArray;
        if (bl2) {
            Arrays.sort(this.selectionValues, TrivialComparator.instance);
        }
        this.initGUI();
    }

    public static Object showObjChooser(Frame frame, String string, String string2, Object[] objectArray) {
        return ObjChooser.showObjChooser(frame, string, string2, false, objectArray);
    }

    public static Object showObjChooser(Frame frame, String string, String string2, boolean bl, Object[] objectArray) {
        ObjChooser objChooser = new ObjChooser(frame, string, string2, true, bl, objectArray);
        objChooser.show();
        return objChooser.getValue();
    }

    public Object getValue() {
        return this.selectedValue;
    }

    private void initGUI() {
        this.selList = new JList<Object>(this.selectionValues);
        this.selList.setVisibleRowCount(15);
        this.selList.addKeyListener(this);
        this.selList.addMouseListener(this);
        new Typematic(this.selList);
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(this.message);
        JScrollPane jScrollPane = new JScrollPane(this.selList);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 1, 5, 1));
        jPanel.add("North", jLabel);
        jPanel.add("Center", jScrollPane);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 10, 10));
        this.ok = this.createButton("Ok", 'O');
        jPanel2.add(this.ok);
        this.cancel = this.createButton("Cancel", 'C');
        jPanel2.add(this.cancel);
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.setLayout(new BorderLayout(5, 5));
        jComponent.add("Center", jPanel);
        jComponent.add("South", jPanel2);
        jComponent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.pack();
        Util.center(this);
    }

    private JButton createButton(String string, char c) {
        JButton jButton = Util.createButton(string, c, this);
        return jButton;
    }

    private void selectAndLeave() {
        this.selectedValue = this.selList.getSelectedValue();
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.ok) {
            this.selectedValue = this.selList.getSelectedValue();
        } else if (object == this.cancel) {
            this.selectedValue = null;
        }
        this.dispose();
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n') {
            this.selectAndLeave();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.selectAndLeave();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

