/*
 * Decompiled with CFR 0.152.
 */
package com.kb.gui;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class FocusBorder
implements FocusListener {
    static final Color defaultFocusColor = Color.red.brighter();
    static final int defaultThickness = 1;
    JComponent inner;
    JComponent focus;
    int thickness;
    Color focusColor;
    Color noFocusColor;

    public FocusBorder(JComponent jComponent) {
        this(jComponent, jComponent);
    }

    public FocusBorder(JComponent jComponent, JComponent jComponent2) {
        this.setFocusColor(null);
        this.setNoFocusColor(null);
        this.setThickness(-1);
        this.setFocusComponent(jComponent2);
        this.setInnerComponent(jComponent);
    }

    public JComponent getInnerComponent() {
        return this.inner;
    }

    public JComponent getFocusComponent() {
        return this.focus;
    }

    public Color getFocusColor() {
        return this.focusColor;
    }

    public Color getNoFocusColor() {
        return this.noFocusColor;
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setInnerComponent(JComponent jComponent) {
        if (this.inner != null) {
            this.inner.setBorder(null);
        }
        this.inner = jComponent;
        if (this.inner == null) {
            return;
        }
        this.inner.setBorder(this.getCorrectBorder());
    }

    public void setFocusComponent(JComponent jComponent) {
        if (this.focus != null) {
            this.focus.removeFocusListener(this);
        }
        this.focus = jComponent;
        if (this.focus == null) {
            return;
        }
        this.focus.addFocusListener(this);
    }

    public void setFocusColor(Color color) {
        this.focusColor = color;
    }

    public void setNoFocusColor(Color color) {
        this.noFocusColor = color;
    }

    public void setThickness(int n) {
        this.thickness = n;
    }

    private Border getCorrectBorder() {
        return this.focus.hasFocus() ? this.getFocusBorder() : this.getNoFocusBorder();
    }

    private Border getFocusBorder() {
        if (this.focusColor == null) {
            this.focusColor = defaultFocusColor;
        }
        if (this.thickness == -1) {
            this.thickness = 1;
        }
        return BorderFactory.createLineBorder(this.focusColor, this.thickness);
    }

    private Border getNoFocusBorder() {
        if (this.noFocusColor == null) {
            this.noFocusColor = this.inner.getBackground();
        }
        if (this.thickness == -1) {
            this.thickness = 1;
        }
        return BorderFactory.createLineBorder(this.noFocusColor, this.thickness);
    }

    public void focusLost(FocusEvent focusEvent) {
        this.inner.setBorder(this.getNoFocusBorder());
        this.inner.revalidate();
    }

    public void focusGained(FocusEvent focusEvent) {
        this.inner.setBorder(this.getFocusBorder());
        this.inner.revalidate();
    }
}

