/*
 * Decompiled with CFR 0.152.
 */
package com.kb.client_server;

import com.kb.client.CommunicationsFailure;
import com.kb.client.Database;
import com.kb.client.DatabaseFailure;
import com.kb.client.InvalidPassword;
import com.kb.client.Isolation;
import com.kb.client.MissingClass;
import com.kb.client.QueryFailure;
import com.kb.client_server.AbstractKBServer;
import com.kb.client_server.Answers;
import com.kb.client_server.ConnectionID;
import com.kb.client_server.ICStatus;
import com.kb.client_server.KBServer;
import com.kb.client_server.WireProtocol;
import com.kb.kbddutil.SerialForm;
import com.kb.owl.IVar;
import com.kb.owl.OWL;
import com.kb.xsb.Variable;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.Properties;
import java.util.Vector;

public class RemoteKBStub
extends AbstractKBServer
implements KBServer,
WireProtocol {
    protected DataInputStream in;
    protected DataOutputStream out;
    Socket socket;
    protected ConnectionID connection_id;
    boolean transactionInProgress = false;
    final String host;
    final int port;

    public RemoteKBStub(Database database) throws CommunicationsFailure {
        this.host = database.getHost() != null ? database.getHost() : "localhost";
        this.port = database.getPort();
        this.init();
    }

    public RemoteKBStub(String string, int n) throws CommunicationsFailure {
        this.host = string;
        this.port = n;
        this.init();
    }

    private void init() throws CommunicationsFailure {
        try {
            this.socket = new Socket(this.host, this.port);
            this.in = new DataInputStream(this.socket.getInputStream());
            this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            this.connect();
        }
        catch (IOException iOException) {
            throw new CommunicationsFailure("Cannot initialize", iOException);
        }
    }

    public void serverFailed(byte by) throws CommunicationsFailure {
        if (by == 90 || by == 88) {
            String string;
            try {
                string = this.in.readUTF();
            }
            catch (IOException iOException) {
                throw new CommunicationsFailure("Error from server", iOException);
            }
            this.disconnect();
            throw new DatabaseFailure("Database threw " + string);
        }
        this.disconnect();
        throw new DatabaseFailure("Invalid response from database: " + by);
    }

    public void handleError(int n) throws CommunicationsFailure, QueryFailure {
        if (n == 90 || n == 88) {
            String string;
            try {
                string = this.in.readUTF();
            }
            catch (IOException iOException) {
                throw new CommunicationsFailure("Error from server", iOException);
            }
            if (n == 88) {
                throw new QueryFailure(string);
            }
            this.disconnect();
            throw new DatabaseFailure("Database threw " + string);
        }
        this.disconnect();
        throw new DatabaseFailure("Invalid response from database: " + n);
    }

    void disconnect() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.socket = null;
    }

    protected void ensureConnected() throws DatabaseFailure {
        if (this.socket == null) {
            throw new DatabaseFailure("Not connected");
        }
    }

    public void connect() throws CommunicationsFailure {
        try {
            this.ensureConnected();
            this.out.writeInt(-17883392);
            this.out.writeInt(1);
            this.out.writeInt(0);
            this.out.flush();
            byte by = this.in.readByte();
            if (by == 79) {
                int n = this.in.readInt();
                this.connection_id = new ConnectionID(n);
                this.props = (Properties)new ObjectInputStream(this.in).readObject();
            } else {
                this.serverFailed(by);
            }
        }
        catch (IOException iOException) {
            throw new CommunicationsFailure("Error from database server", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CommunicationsFailure("Error from database server", classNotFoundException);
        }
    }

    public void login(String string, String string2) throws CommunicationsFailure, InvalidPassword {
        block6: {
            try {
                this.ensureConnected();
                this.out.writeByte(71);
                this.out.writeUTF(string);
                this.out.writeUTF(string2);
                this.out.flush();
                byte by = this.in.readByte();
                if (by == 79) {
                    boolean bl = this.in.readBoolean();
                    if (!bl) {
                        this.close();
                        throw new InvalidPassword();
                    }
                    break block6;
                }
                try {
                    this.handleError(by);
                }
                catch (QueryFailure queryFailure) {
                    throw new CommunicationsFailure("Unexpected error", queryFailure);
                }
            }
            catch (IOException iOException) {
                throw new CommunicationsFailure("Cannot login", iOException);
            }
        }
    }

    public ICStatus checkIntegrityConstraints() throws CommunicationsFailure, QueryFailure {
        try {
            this.ensureConnected();
            this.out.writeByte(49);
            this.out.flush();
            byte by = this.in.readByte();
            if (by == 79) {
                ICStatus iCStatus = (ICStatus)new ObjectInputStream(this.in).readObject();
                return iCStatus;
            }
            this.handleError(by);
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Error("Missing class: " + classNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw new CommunicationsFailure("IC check failed", iOException);
        }
    }

    public void close() throws CommunicationsFailure {
        try {
            if (this.socket == null) {
                return;
            }
            this.out.writeByte(88);
            this.out.flush();
            this.disconnect();
        }
        catch (IOException iOException) {
            throw new CommunicationsFailure("Close failed", iOException);
        }
    }

    protected Answers readAnswers() throws IOException, CommunicationsFailure {
        try {
            int n = this.in.readInt();
            int n2 = this.in.readInt();
            int[][] nArray = new int[n][n2];
            int n3 = 0;
            while (n3 < n) {
                int n4 = 0;
                while (n4 < n2) {
                    nArray[n3][n4] = this.in.readInt();
                    ++n4;
                }
                ++n3;
            }
            int n5 = this.in.readInt();
            Vector<Object> vector = null;
            if (n5 > 0) {
                vector = new Vector<Object>(n5);
                int n6 = 0;
                while (n6 < n5) {
                    Object object = SerialForm.read(this.in);
                    vector.addElement(object);
                    ++n6;
                }
            }
            return new Answers(n, nArray, vector);
        }
        catch (IOException iOException) {
            throw new CommunicationsFailure("Error from database server", iOException);
        }
    }

    public Answers query(Object object, Variable[] variableArray, int n, boolean bl, Isolation isolation) throws CommunicationsFailure, QueryFailure {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(113);
            SerialForm.write(object, dataOutputStream);
            dataOutputStream.writeInt(variableArray.length);
            int n2 = 0;
            while (n2 < variableArray.length) {
                SerialForm.write(variableArray[n2], dataOutputStream);
                ++n2;
            }
            dataOutputStream.writeInt(this.encodeFlags(bl, isolation, n));
            this.issue(byteArrayOutputStream.toByteArray());
            byte by = this.in.readByte();
            if (by == 79) {
                return this.readAnswers();
            }
            this.handleError(by);
            return null;
        }
        catch (IOException iOException) {
            throw new CommunicationsFailure("Query failed", iOException);
        }
    }

    public Answers extent(Object object, boolean bl, Isolation isolation) throws CommunicationsFailure, QueryFailure {
        try {
            this.out.writeByte(69);
            SerialForm.write(object, this.out);
            this.out.writeInt(this.encodeFlags(bl, isolation, -1));
            this.out.flush();
            byte by = this.in.readByte();
            if (by == 79) {
                return this.readAnswers();
            }
            this.handleError(by);
            return null;
        }
        catch (IOException iOException) {
            throw new CommunicationsFailure("Communication error", iOException);
        }
    }

    public ICStatus listICViolations() throws CommunicationsFailure {
        try {
            this.ensureConnected();
            this.out.writeByte(66);
            this.out.flush();
            byte by = this.in.readByte();
            if (by == 79) {
                ICStatus iCStatus = (ICStatus)new ObjectInputStream(this.in).readObject();
                return iCStatus;
            }
            this.serverFailed(by);
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Error("Missing class: " + classNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw new CommunicationsFailure("Error", iOException);
        }
    }

    public boolean recheckIntegrityConstraintViolation(Object object) throws CommunicationsFailure {
        try {
            this.out.writeByte(70);
            this.out.flush();
            SerialForm.write(object, this.out);
            boolean bl = this.getDefaultAutoCommit();
            this.out.writeBoolean(bl);
            this.out.flush();
            byte by = this.in.readByte();
            if (by == 79) {
                boolean bl2 = this.in.readBoolean();
                return bl2;
            }
            this.serverFailed(by);
            return true;
        }
        catch (IOException iOException) {
            throw new CommunicationsFailure("Error", iOException);
        }
    }

    public ICStatus commit() throws CommunicationsFailure, DatabaseFailure {
        try {
            this.out.writeByte(84);
            this.out.flush();
            byte by = this.in.readByte();
            if (by == 79) {
                ICStatus iCStatus = (ICStatus)new ObjectInputStream(this.in).readObject();
                this.transactionInProgress = iCStatus.databaseOK();
                return iCStatus;
            }
            try {
                this.handleError(by);
            }
            catch (QueryFailure queryFailure) {
                throw new CommunicationsFailure("Unexpected query failure from server", queryFailure);
            }
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MissingClass(classNotFoundException);
        }
        catch (IOException iOException) {
            throw new CommunicationsFailure("Error", iOException);
        }
    }

    public void rollback() throws CommunicationsFailure, DatabaseFailure, QueryFailure {
        try {
            this.out.writeByte(82);
            this.out.flush();
            byte by = this.in.readByte();
            if (by == 79) {
                this.transactionInProgress = false;
                return;
            }
            this.handleError(by);
        }
        catch (IOException iOException) {
            throw new CommunicationsFailure("Error", iOException);
        }
    }

    public ICStatus insert(Object object, boolean bl, Isolation isolation) throws CommunicationsFailure, QueryFailure, DatabaseFailure {
        try {
            this.out.writeByte(105);
            SerialForm.write(object, this.out);
            this.out.writeInt(this.encodeFlags(bl, isolation, 0));
            this.out.flush();
            this.transactionInProgress = !bl;
            byte by = this.in.readByte();
            if (by == 79) {
                return (ICStatus)new ObjectInputStream(this.in).readObject();
            }
            this.handleError(by);
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MissingClass(classNotFoundException);
        }
        catch (IOException iOException) {
            throw new CommunicationsFailure("Error", iOException);
        }
    }

    public ICStatus delete(Object object, boolean bl, Isolation isolation) throws CommunicationsFailure, QueryFailure, DatabaseFailure {
        try {
            this.out.writeByte(100);
            SerialForm.write(object, this.out);
            this.out.writeInt(this.encodeFlags(bl, isolation, 0));
            this.out.flush();
            this.transactionInProgress = !bl;
            byte by = this.in.readByte();
            if (by == 79) {
                return (ICStatus)new ObjectInputStream(this.in).readObject();
            }
            this.handleError(by);
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MissingClass(classNotFoundException);
        }
        catch (IOException iOException) {
            throw new CommunicationsFailure("Error", iOException);
        }
    }

    int encodeFlags(boolean bl, Isolation isolation, int n) {
        int n2 = 0;
        n2 = isolation == Isolation.READ_UNCOMMITTED ? 0 : (isolation == Isolation.READ_COMMITTED ? 2 : (isolation == Isolation.REPEATABLE_READ ? 4 : 6));
        if (bl) {
            n2 |= 1;
        }
        return n2 |= n << 3;
    }

    public void archive(String string) throws DatabaseFailure {
        throw new DatabaseFailure("Archive not implemented for remote access");
    }

    public void restore(String string) throws DatabaseFailure {
        throw new DatabaseFailure("Restore not implemented for remote access");
    }

    void issue(byte[] byArray) throws IOException {
        int n = 0;
        while (n < 2) {
            try {
                this.out.write(byArray);
                this.out.flush();
                return;
            }
            catch (IOException iOException) {
                if (this.transactionInProgress) {
                    throw new CommunicationsFailure(iOException);
                }
                this.init();
                ++n;
            }
        }
        throw new CommunicationsFailure("Database not available");
    }

    public Answers query(OWL oWL, IVar[] iVarArray, int n, boolean bl, Isolation isolation) throws QueryFailure {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(81);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(dataOutputStream);
            objectOutputStream.writeObject(oWL);
            objectOutputStream.writeObject(iVarArray);
            objectOutputStream.flush();
            this.transactionInProgress = !bl;
            dataOutputStream.writeInt(this.encodeFlags(bl, isolation, n));
            this.issue(byteArrayOutputStream.toByteArray());
            byte by = this.in.readByte();
            if (by == 79) {
                return this.readAnswers();
            }
            this.handleError(by);
            return null;
        }
        catch (IOException iOException) {
            throw new CommunicationsFailure("Query failed", iOException);
        }
    }

    public OWL create(OWL oWL, boolean bl, Isolation isolation) throws QueryFailure {
        try {
            this.out.writeByte(67);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.out);
            objectOutputStream.writeObject(oWL);
            objectOutputStream.flush();
            this.out.writeInt(this.encodeFlags(bl, isolation, 0));
            this.out.flush();
            this.transactionInProgress = !bl;
            byte by = this.in.readByte();
            if (by == 79) {
                return (OWL)new ObjectInputStream(this.in).readObject();
            }
            this.handleError(by);
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MissingClass(classNotFoundException);
        }
        catch (IOException iOException) {
            throw new CommunicationsFailure(iOException);
        }
    }

    public ICStatus insert(OWL oWL, boolean bl, Isolation isolation) throws DatabaseFailure, QueryFailure {
        try {
            this.out.writeByte(73);
            new ObjectOutputStream(this.out).writeObject(oWL);
            this.out.writeInt(this.encodeFlags(bl, isolation, 0));
            this.out.flush();
            this.transactionInProgress = !bl;
            byte by = this.in.readByte();
            if (by == 79) {
                return (ICStatus)new ObjectInputStream(this.in).readObject();
            }
            this.handleError(by);
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MissingClass(classNotFoundException);
        }
        catch (IOException iOException) {
            throw new CommunicationsFailure("Error", iOException);
        }
    }

    public ICStatus delete(OWL oWL, boolean bl, Isolation isolation) throws DatabaseFailure, QueryFailure {
        try {
            this.out.writeByte(68);
            new ObjectOutputStream(this.out).writeObject(oWL);
            this.out.writeInt(this.encodeFlags(bl, isolation, 0));
            this.out.flush();
            this.transactionInProgress = !bl;
            byte by = this.in.readByte();
            if (by == 79) {
                return (ICStatus)new ObjectInputStream(this.in).readObject();
            }
            this.handleError(by);
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MissingClass(classNotFoundException);
        }
        catch (IOException iOException) {
            throw new CommunicationsFailure("Error", iOException);
        }
    }
}

