/*
 * Decompiled with CFR 0.152.
 */
package com.kb.client;

import com.kb.client.Connection;
import com.kb.client.ConnectionFailure;
import com.kb.client.Query;
import com.kb.client.QueryFailure;
import com.kb.client.RequestFailure;
import com.kb.client_server.Answers;
import com.kb.client_server.KBServer;
import com.kb.kbddutil.KBProperties;
import com.kb.owl.OWL;
import com.kb.owl.Symbol;
import com.kb.xsb.List;
import com.kb.xsb.Structure;
import com.kb.xsb.Variable;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.util.Vector;

public class SMConnection {
    protected KBServer server;
    String pkg;
    int heartbeat = Integer.getInteger("com.kb.client.heartbeat", new Integer("0"));
    Symbol[] preds;
    OWL[] types;
    Class[] classes;
    protected PrintStream errorlog = System.err;

    protected SMConnection() {
        String string = KBProperties.get("com.kb.server.errorlog");
        if (string != null && string.length() > 0) {
            PrintStream printStream = this.errorlog;
            try {
                this.errorlog = new PrintStream(new FileOutputStream(string));
            }
            catch (Exception exception) {
                this.errorlog = printStream;
                this.errorlog.println("Could not open log " + string);
            }
        }
    }

    protected void insert(Object object) throws RequestFailure {
        this.server.insert(object);
    }

    protected void delete(Object object) throws RequestFailure {
        this.server.delete(object);
    }

    protected void insert(Object object, Object[] objectArray) throws RequestFailure {
        this.insert(new Structure(object, objectArray));
    }

    protected void delete(Object object, Object[] objectArray) throws RequestFailure {
        this.delete(new Structure(object, objectArray));
    }

    protected Answers query(Object object, Variable[] variableArray, int n) throws ConnectionFailure, QueryFailure {
        return this.server.query(object, variableArray, n);
    }

    protected Answers query(Object object) throws ConnectionFailure, QueryFailure {
        Variable[] variableArray = SMConnection.findVars(object);
        return this.query(object, variableArray, -1);
    }

    public static Variable[] findVars(Object object) {
        Vector vector = new Vector();
        SMConnection.findVars(object, vector);
        Object[] objectArray = new Variable[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    static void findVars(Object object, Vector vector) {
        if (object instanceof Variable) {
            if (!vector.contains(object)) {
                vector.addElement(object);
            }
        } else if (object instanceof Structure) {
            Structure structure = (Structure)object;
            int n = 0;
            while (n < structure.arity()) {
                SMConnection.findVars(structure.arg(n), vector);
                ++n;
            }
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = 0;
            while (n < objectArray.length) {
                SMConnection.findVars(objectArray[n], vector);
                ++n;
            }
        } else if (object instanceof List) {
            while (object instanceof List) {
                List list = (List)object;
                SMConnection.findVars(list.car, vector);
                object = list.cdr;
            }
            SMConnection.findVars(object, vector);
        }
    }

    public Symbol getPredicate(int n) {
        return this.preds[n];
    }

    protected KBServer getServer() {
        if (this.server == null) {
            throw new ConnectionFailure("Cannot use this connection; it is closed");
        }
        return this.server;
    }

    protected void init_api() throws ConnectionFailure {
        try {
            InputStream inputStream;
            String string = this.getClass().getName();
            int n = string.lastIndexOf(46);
            this.pkg = n < 0 ? string : string.substring(0, n + 1);
            if (this.pkg.endsWith("api.")) {
                this.pkg = this.pkg.substring(0, this.pkg.length() - 4);
            }
            if ((inputStream = ClassLoader.getSystemResourceAsStream(this.pkg.replace('.', '/') + "api_index")) == null) {
                throw new Exception("Cannot find api_index");
            }
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            this.preds = (Symbol[])objectInputStream.readObject();
            this.types = (OWL[])objectInputStream.readObject();
            this.classes = new Class[this.types.length];
        }
        catch (Throwable throwable) {
            throw new ConnectionFailure("Cannot read API", throwable);
        }
    }

    protected Query makeQuery(int n, Object object) {
        return new Query(n, new Object[]{object}, (Connection)this);
    }

    protected Query makeQuery(int n, Object object, Object object2) {
        return new Query(n, new Object[]{object, object2}, (Connection)this);
    }

    protected Query makeQuery(int n, Object object, Object object2, Object object3) {
        return new Query(n, new Object[]{object, object2, object3}, (Connection)this);
    }

    protected Query makeQuery(int n, Object object, Object object2, Object object3, Object object4) {
        return new Query(n, new Object[]{object, object2, object3, object4}, (Connection)this);
    }
}

