/*
 * Decompiled with CFR 0.152.
 */
package com.kb.client;

import com.kb.client.Connection;
import com.kb.client.ConnectionFailure;
import com.kb.client.HardICViolation;
import com.kb.client.IKBObject;
import com.kb.client.InvalidTupleException;
import com.kb.client.KBObject;
import com.kb.client.Metadata;
import com.kb.client.MixedDatabaseException;
import com.kb.client.RequestFailure;
import com.kb.client.Results;
import com.kb.owl.Form;
import com.kb.owl.IVar;
import com.kb.owl.OWL;
import com.kb.owl.QuotedString;
import com.kb.owl.Symbol;
import com.kb.owl.Time;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;

public class Query
implements Cloneable {
    static final String[] standardPredicates = new String[]{"", "", "and", "or", "findall"};
    final Connection connection;
    OWL query;
    final ArrayList variables = new ArrayList();
    Results answers = null;
    int current_answer = -1;

    protected Query(Connection connection) {
        this.connection = connection;
    }

    Query(String string, Query query, Query query2) {
        this.connection = query.connection;
        this.useConnection(query2.connection);
        this.query = new Form(string, query.query, query2.query);
        this.variables.addAll(query.variables);
        int n = 0;
        while (n < query2.variables.size()) {
            if (!this.variables.contains(query2.variables.get(n))) {
                this.variables.add(query2.variables.get(n));
            }
            ++n;
        }
    }

    Query(OWL oWL, Connection connection) {
        this(connection);
        this.query = oWL;
    }

    Query(String string, Query query) {
        this.connection = query.connection;
        this.query = new Form(string, query.query);
        this.variables.addAll(query.variables);
    }

    Query(int n, Object[] objectArray, Connection connection) {
        this.connection = connection;
        OWL[] oWLArray = new OWL[objectArray.length];
        HashSet hashSet = new HashSet();
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (objectArray[n2] instanceof KBObject) {
                KBObject kBObject = (KBObject)objectArray[n2];
                this.useConnection(kBObject.getConnection());
                oWLArray[n2] = kBObject.oid;
                if (kBObject.isVariable() && !this.variables.contains(kBObject)) {
                    this.variables.add(kBObject);
                }
            } else if (objectArray[n2] instanceof OWL) {
                oWLArray[n2] = (OWL)objectArray[n2];
            } else if (objectArray[n2] instanceof String) {
                oWLArray[n2] = new QuotedString(objectArray[n2].toString());
            } else if (objectArray[n2] instanceof Integer) {
                oWLArray[n2] = new Symbol((Integer)objectArray[n2]);
            } else if (objectArray[n2] instanceof Float) {
                oWLArray[n2] = new Symbol(((Float)objectArray[n2]).floatValue());
            } else {
                throw new Error("Unknown object: " + objectArray[n2] + " is a " + objectArray[n2].getClass().getName());
            }
            ++n2;
        }
        this.query = new Form((OWL)connection.getPredicate(n), oWLArray);
    }

    public Query not() {
        return new Query("not", this);
    }

    public static Query andNot(Query query, Query query2) {
        if (query == null) {
            return query2.not();
        }
        return query.andNot(query2);
    }

    public static Query orNot(Query query, Query query2) {
        if (query2 == null) {
            return query;
        }
        if (query == null) {
            return query2.not();
        }
        return query.orNot(query2);
    }

    public Query andNot(Query query) {
        if (query == null) {
            return this;
        }
        return this.and(query.not());
    }

    public Query orNot(Query query) {
        if (query == null) {
            return this;
        }
        return this.or(query.not());
    }

    public Query and(Query query) {
        if (query == null) {
            return this;
        }
        return new Query("and", this, query);
    }

    public Query or(Query query) {
        if (query == null) {
            return this;
        }
        return new Query("or", this, query);
    }

    public static Query and(Query query, Query query2) {
        if (query == null) {
            return query2;
        }
        if (query2 == null) {
            return query;
        }
        return query.and(query2);
    }

    public static Query or(Query query, Query query2) {
        if (query == null) {
            return query2;
        }
        if (query2 == null) {
            return query;
        }
        return query.or(query2);
    }

    public void insert() throws RequestFailure, ConnectionFailure, HardICViolation {
        if (this.variables.size() > 0) {
            throw new InvalidTupleException("Cannot insert tuple with variables");
        }
        this.connection.insert(this.query);
    }

    public void insert(Date date, Date date2) throws RequestFailure, ConnectionFailure, HardICViolation {
        if (this.variables.size() > 0) {
            throw new InvalidTupleException("Cannot insert tuple with variables");
        }
        Form form = new Form("holdsIn", (OWL)new Form("RootCtx.Span", Time.java2owl(date), Time.java2owl(date2)), this.query);
        this.connection.insert(form);
    }

    public void insert(Date[] dateArray) throws RequestFailure, ConnectionFailure, HardICViolation {
        this.insert(dateArray[0], dateArray[1]);
    }

    public void delete() throws RequestFailure, ConnectionFailure, HardICViolation {
        this.connection.delete(this.query);
    }

    void force() throws RequestFailure, ConnectionFailure {
        if (this.answers == null) {
            this.answers = this.connection.query(this.query);
            this.current_answer = -1;
        }
    }

    public boolean more() throws RequestFailure, ConnectionFailure {
        return this.hasMoreElements();
    }

    public boolean hasMoreElements() throws RequestFailure, ConnectionFailure {
        this.force();
        return this.current_answer + 1 < this.answers.count();
    }

    public Results getResults() throws RequestFailure {
        this.force();
        return this.answers;
    }

    public int count() throws RequestFailure {
        this.force();
        return this.answers.count();
    }

    public IKBObject[] variables() {
        IKBObject[] iKBObjectArray = new IKBObject[this.variables.size()];
        int n = 0;
        while (n < iKBObjectArray.length) {
            iKBObjectArray[n] = ((IKBObject)this.variables.get(n)).bind();
            ++n;
        }
        return iKBObjectArray;
    }

    public OWL getQuery() {
        return this.query;
    }

    public IVar[] getOWLVariables() {
        IVar[] iVarArray = new IVar[this.variables.size()];
        int n = 0;
        while (n < iVarArray.length) {
            iVarArray[n] = ((KBObject)this.variables.get((int)n)).var;
            ++n;
        }
        return iVarArray;
    }

    public OWL[] answer() throws RequestFailure {
        if (this.answers == null && !this.fetch()) {
            return null;
        }
        if (this.current_answer < this.answers.count()) {
            return this.answers.answer(this.current_answer);
        }
        return null;
    }

    public boolean fetch() throws RequestFailure, ConnectionFailure {
        return this.fetch(null);
    }

    public boolean fetch(Metadata metadata) throws RequestFailure {
        this.force();
        if (!this.hasMoreElements()) {
            ++this.current_answer;
            return false;
        }
        ++this.current_answer;
        int n = 0;
        Iterator iterator = ((AbstractList)this.variables).iterator();
        while (iterator.hasNext()) {
            KBObject kBObject = (KBObject)iterator.next();
            kBObject.rebind(this.answers.answer(this.current_answer, n));
            kBObject.setConnection(this.connection);
            ++n;
        }
        if (metadata != null) {
            metadata.aid = this.answers.width() > this.variables.size() ? this.answers.answer(this.current_answer, this.answers.width() - 1) : null;
        }
        return true;
    }

    public String toString() {
        if (this.answers == null) {
            return "[Query: " + this.query + "]";
        }
        return "[Query: " + this.query + " " + this.current_answer + " of " + this.answers.count() + "]";
    }

    public void useConnection(Connection connection) {
        if (connection != null) {
            if (this.connection == null) {
                throw new Error("This query has a null connection; why?");
            }
            if (!this.connection.equals(connection)) {
                throw new MixedDatabaseException(this.connection, connection);
            }
        }
    }

    public Connection getConnection() {
        return this.connection;
    }
}

