/*
 * Decompiled with CFR 0.152.
 */
package com.kb.client;

import com.kb.client.Connection;
import com.kb.client.ConnectionFailure;
import com.kb.client.IKBObject;
import com.kb.client.KBError;
import com.kb.client.RequestFailure;
import com.kb.client.Results;
import com.kb.owl.Form;
import com.kb.owl.IVar;
import com.kb.owl.OWL;
import com.kb.owl.QuotedString;
import com.kb.owl.Symbol;
import com.kb.owl.SyntaxError;
import com.kb.owl.Time;
import java.util.Date;
import java.util.HashMap;

public class KBObject
implements Cloneable,
IKBObject {
    static HashMap oidNames = new HashMap();
    private Connection connection;
    IVar var = new IVar("?" + anonymous++);
    protected OWL oid = this.var;
    static int anonymous = 0;

    protected KBObject() {
    }

    public String toString() {
        String string = this.getName();
        if (string != null) {
            return string;
        }
        if (this.oid instanceof IVar) {
            return "[" + this.getClass().getName() + " " + this.oid + "]";
        }
        if (this.oid instanceof QuotedString) {
            return ((QuotedString)this.oid).text();
        }
        return this.oid.toString();
    }

    public OWL getOid() {
        return this.oid;
    }

    public int hashCode() {
        if (this.oid == null) {
            return this.var.hashCode();
        }
        return this.oid.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof KBObject) {
            KBObject kBObject = (KBObject)object;
            if (this.oid == null) {
                return kBObject.oid == null;
            }
            return this.oid.equals(kBObject.oid);
        }
        return false;
    }

    public boolean isVariable() {
        return this.oid instanceof IVar;
    }

    protected void rebind(OWL oWL) {
        this.oid = oWL;
    }

    public Connection getConnection() {
        return this.connection;
    }

    void setConnection(Connection connection) {
        this.connection = connection;
        if (this.connection.getAutoName() && this.getName() == null) {
            try {
                Results results = this.connection.query("RootCtx.name", this.oid, new IVar("X"));
                if (results.count() > 0) {
                    this.setName(results.answer(0, 0).name());
                }
            }
            catch (RequestFailure requestFailure) {
                // empty catch block
            }
        }
    }

    public IKBObject cast(Class clazz) throws ClassCastException {
        return this.connection.cast(clazz, this);
    }

    protected KBObject createObject(String string, OWL oWL) {
        try {
            Class<?> clazz = Class.forName(string);
            return this.connection.createObject(clazz, oWL);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConnectionFailure(classNotFoundException);
        }
    }

    public IKBObject bind() {
        try {
            if (this.oid instanceof Form) {
                return this.connection.createObject(null, (Form)this.oid);
            }
            KBObject kBObject = (KBObject)this.clone();
            kBObject.var = null;
            return kBObject;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Unexpected CloneNotSupportedException");
        }
    }

    public Connection getAPI() {
        return this.connection;
    }

    public String getName() {
        return (String)oidNames.get(this.oid);
    }

    public void setName(String string) {
        oidNames.put(this.oid, string);
    }

    public int intValue() {
        return ((Symbol)this.getOid()).intValue();
    }

    public float floatValue() {
        return ((Symbol)this.getOid()).floatValue();
    }

    public Date[] timeValue() {
        try {
            return Time.owl2java(this.getOid());
        }
        catch (SyntaxError syntaxError) {
            throw new KBError("Invalid date format: " + this.getOid(), syntaxError);
        }
    }
}

