/*
 * Decompiled with CFR 0.152.
 */
package com.kb.client;

import com.kb.client.InvalidIsolationLevel;
import java.io.Serializable;

public class Isolation
implements Serializable {
    final String name;
    public final int level;
    public static final Isolation READ_UNCOMMITTED = new Isolation("ReadUncommitted", 1);
    public static final Isolation READ_COMMITTED = new Isolation("ReadCommitted", 2);
    public static final Isolation REPEATABLE_READ = new Isolation("RepeatableRead", 4);
    public static final Isolation SERIALIZABLE = new Isolation("Serializeable", 8);

    public String toString() {
        return this.name;
    }

    private Isolation(String string, int n) {
        this.name = string;
        this.level = n;
    }

    public int level() {
        return this.level;
    }

    public static final Isolation getIsolation(int n) throws InvalidIsolationLevel {
        switch (n) {
            case 2: {
                return READ_COMMITTED;
            }
            case 1: {
                return READ_UNCOMMITTED;
            }
            case 4: {
                return REPEATABLE_READ;
            }
            case 8: {
                return SERIALIZABLE;
            }
        }
        throw new InvalidIsolationLevel(n);
    }

    public boolean equals(Object object) {
        return object instanceof Isolation && ((Isolation)object).level == this.level;
    }
}

