/*
 * Decompiled with CFR 0.152.
 */
package com.kb.client;

import com.kb.admin.RemoteAdmin;
import com.kb.client.Connection;
import com.kb.client.ConnectionFailure;
import com.kb.client.DatabaseState;
import com.kb.client.KBError;
import com.kb.client.QueryFailure;
import com.kb.client.StartFailed;
import com.kb.client.StartFailedNoLicense;
import com.kb.client.StopFailed;
import com.kb.kbddutil.FileNamer;
import com.kb.kbddutil.KBProperties;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.ProgressMonitor;

public class Database
extends Properties {
    String dir;
    private DatabaseState state = DatabaseState.Unknown;
    private String name;

    public Database() throws MalformedURLException {
        this((String)null);
    }

    public Database(String string) throws MalformedURLException {
        if (string == null) {
            string = KBProperties.get("database");
        }
        if (string == null || string.length() == 0) {
            string = KBProperties.get("defaultDatabase");
        }
        if (string == null || string.length() == 0) {
            throw new KBError("Cannot determine which database to use; use -Ddatabase=<database> parameter or _kbprops file");
        }
        this.init(string);
        this.initialize();
    }

    void initialize() {
        this.getDir();
        if (this.dir != null) {
            ((Hashtable)this).put("storage", this.dir);
        }
        if (this.getDatabaseName() != null) {
            ((Hashtable)this).put("name", this.getDatabaseName());
        }
        if (this.getHost() != null) {
            ((Hashtable)this).put("host", this.getHost());
        }
        ((Hashtable)this).put("url", this.getURLString());
    }

    private void init(String string) throws MalformedURLException {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream("databases");
        if (inputStream != null) {
            Properties properties = new Properties();
            try {
                properties.load(inputStream);
            }
            catch (IOException iOException) {
                this.initializeOW(string);
                return;
            }
            String string2 = properties.getProperty(string);
            if (string2 == null) {
                this.initializeOW(string);
            } else {
                this.initializeOW(string2);
                this.name = string;
            }
        } else {
            this.initializeOW(string);
        }
    }

    private void initializeOW(String string) throws MalformedURLException {
        if (string == null) {
            return;
        }
        if (string.startsWith("ow:")) {
            this.initializeOW(string.substring(3));
        } else if (string.startsWith("local:")) {
            this.initializeLocal(string.substring(6));
        } else if (string.startsWith("remote:")) {
            this.initializeRemote(string.substring(7));
        } else if (string.startsWith("//")) {
            this.initializeRemote(string);
        } else {
            this.initializeLocal(string);
        }
    }

    private void initializeLocal(String string) {
        this.dir = string;
        this.name = new File(string).getName();
        this.dir = FileNamer.name(Database.getDatabaseDir(), this.dir);
        try {
            this.dir = new File(this.dir).getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.load(this.dir);
        if (((Hashtable)this).get("port") == null) {
            int n = Database.getPort(this.getDatabaseName());
            ((Hashtable)this).put("port", "" + n);
        }
    }

    private void initializeRemote(String string) throws MalformedURLException {
        if (!string.startsWith("//")) {
            throw new MalformedURLException("Invalid remote URL " + string);
        }
        string = string.substring(2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":/", true);
        String string2 = stringTokenizer.nextToken();
        ((Hashtable)this).put("host", "" + string2);
        int n = -1;
        try {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals(":")) {
                String string4 = stringTokenizer.nextToken();
                n = Integer.parseInt(string4);
                this.name = null;
            } else {
                this.name = stringTokenizer.nextToken();
                n = Database.getPort(this.getDatabaseName());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new MalformedURLException("Invalid remote URL " + string);
        }
        ((Hashtable)this).put("port", "" + n);
    }

    public static String getDatabaseDir() {
        String string = KBProperties.get("databasesDirectory");
        if (string == null || string.length() == 0) {
            string = "dbs";
            return "dbs";
        }
        return FileNamer.name(string);
    }

    public static int getPort(String string) {
        int n = string.hashCode() % 64511;
        if (n < 0) {
            n = -n;
        }
        return n += 1024;
    }

    public String getDatabaseName() {
        return this.name;
    }

    public String getName() {
        return this.getDatabaseName();
    }

    boolean load(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string + "/master.kb");
            this.load(fileInputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public boolean isLocal() {
        return this.getHost() == null || this.getHost().equals("");
    }

    public String getHost() {
        return this.getProperty("host");
    }

    public int getPort() {
        try {
            return Integer.parseInt(this.getProperty("port"));
        }
        catch (Exception exception) {
            return 44061;
        }
    }

    public String getDir() {
        try {
            if (this.dir == null) {
                this.initializeOW(this.getDatabaseName());
            }
            return this.dir;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String toString() {
        if (this.isLocal()) {
            return this.dir;
        }
        return this.getHost() + ":" + this.getPort();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Database)) {
            return false;
        }
        Database database = (Database)object;
        if (this.isLocal()) {
            return new File(this.getDir()).equals(new File(database.getDir()));
        }
        return this.getHost().equals(database.getHost()) && this.getPort() == database.getPort();
    }

    public void delete(ProgressMonitor progressMonitor) throws IOException {
        if (!this.isLocal()) {
            throw new IOException("Cannot delete remote database");
        }
        if (progressMonitor != null) {
            progressMonitor.setProgress(0);
        }
        Database.deleteRecursively(new File(this.getDir()), progressMonitor);
    }

    File getCloneCheckFile() {
        return new File(new File(this.getDir()), "cloning.state");
    }

    File getKBLoadFile() {
        String string = this.getDir();
        if (string != null) {
            return new File(new File(this.getDir()), "kbload.P");
        }
        return null;
    }

    File getGeneratingCheckFile() {
        return new File(new File(this.getDir()), "generating.state");
    }

    public void clone(File file, ProgressMonitor progressMonitor) throws IOException {
        File file2 = new File(file, "cloning.state");
        file.mkdirs();
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        fileOutputStream.close();
        Database.recursiveCopy(new File(this.getDir()), file, progressMonitor, 0, 100);
        boolean bl = file2.delete();
        if (!bl || progressMonitor != null && progressMonitor.isCanceled()) {
            if (progressMonitor != null) {
                progressMonitor.setNote("Cleaning up");
            }
            Database.deleteRecursively(file, null);
        }
    }

    public static void recursiveCopy(File file, File file2, ProgressMonitor progressMonitor, int n, int n2) throws IOException {
        if (progressMonitor == null || !progressMonitor.isCanceled()) {
            if (file.isDirectory()) {
                file2.mkdirs();
                File[] fileArray = file.listFiles();
                int n3 = (n2 - n) / fileArray.length;
                int n4 = 0;
                while (n4 < fileArray.length) {
                    int n5 = n + n4 * (n2 - n) / fileArray.length;
                    if (progressMonitor != null) {
                        progressMonitor.setProgress(n5);
                    }
                    File file3 = new File(file2, fileArray[n4].getName());
                    Database.recursiveCopy(fileArray[n4], file3, progressMonitor, n5, n5 + n3);
                    ++n4;
                }
            } else {
                Database.copyFile(file, file2, progressMonitor);
            }
        }
    }

    public static void copyFile(File file, File file2, ProgressMonitor progressMonitor) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        while (progressMonitor == null || !progressMonitor.isCanceled()) {
            byte[] byArray = new byte[1024];
            int n = ((InputStream)bufferedInputStream).read(byArray);
            if (n == -1) break;
            ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
        }
        ((OutputStream)bufferedOutputStream).flush();
        ((OutputStream)bufferedOutputStream).close();
    }

    public static void deleteRecursively(File file, ProgressMonitor progressMonitor) throws IOException {
        boolean bl;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                Database.deleteRecursively(fileArray[n], progressMonitor);
                ++n;
            }
        }
        if (progressMonitor != null) {
            progressMonitor.setNote(file.toString());
        }
        if (!(bl = file.delete())) {
            throw new IOException("Cannot delete " + file);
        }
    }

    public void deleteData(ProgressMonitor progressMonitor) throws IOException {
        File file = new File(this.getDir() + "/data");
        File[] fileArray = file.listFiles();
        if (progressMonitor != null) {
            progressMonitor.setProgress(0);
        }
        progressMonitor.setMaximum(fileArray.length);
        int n = 0;
        while (n < fileArray.length) {
            if (progressMonitor != null) {
                progressMonitor.setProgress(n);
                progressMonitor.setNote(fileArray[n].getName());
            }
            fileArray[n].delete();
            ++n;
        }
    }

    public String getURLString() {
        String string = this.getHost();
        if (string == null) {
            string = "localhost";
        }
        return "ow:remote://" + string + "/" + this.getDatabaseName();
    }

    static void test(String string) throws Exception {
        Database database = new Database(string);
        System.out.println(string + ": [" + database.getDatabaseName() + "] " + database);
    }

    public boolean isOMS() {
        if (Boolean.valueOf(this.getProperty("isOMS")).booleanValue()) {
            return true;
        }
        File file = this.getKBLoadFile();
        if (file == null) {
            return false;
        }
        return !file.exists();
    }

    public DatabaseState getState() {
        return this.state;
    }

    public void setState(DatabaseState databaseState) {
        if (this.state == databaseState) {
            return;
        }
        this.state = databaseState;
    }

    public void rename(String string) throws IOException {
        File file;
        File file2 = new File(this.getDir());
        if (file2.equals(file = new File(file2.getParent(), string))) {
            return;
        }
        if (!file2.renameTo(file)) {
            throw new IOException("Could not rename " + file2 + " to " + file);
        }
        this.name = string;
        this.dir = file.getCanonicalPath();
        this.initialize();
    }

    public boolean isStarted() {
        if (this.getState() == DatabaseState.Unknown) {
            this.setState(DatabaseState.Checking);
        }
        boolean bl = false;
        try {
            Connection connection = new Connection(this.getURLString(), "Ping", "Ping", true);
            this.defaults = connection.getServerProperties();
            bl = true;
            connection.close();
        }
        catch (ConnectionFailure connectionFailure) {
            this.defaults = null;
        }
        return bl;
    }

    public boolean isCloning() {
        if (this.isLocal()) {
            return this.getCloneCheckFile().exists();
        }
        return false;
    }

    public boolean isGenerating() {
        if (this.isLocal()) {
            return this.getGeneratingCheckFile().exists();
        }
        return false;
    }

    public void stop() throws StopFailed {
        try {
            new RemoteAdmin(this.getURLString()).stop();
        }
        catch (QueryFailure queryFailure) {
            throw new StopFailed("Stop failed", queryFailure);
        }
        catch (IOException iOException) {
            throw new StopFailed("Stop failed", iOException);
        }
    }

    public void stopAndWait(int n) throws StopFailed {
        this.stop();
        int n2 = 0;
        while (n2 < n) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.isStarted()) {
                return;
            }
            ++n2;
        }
        throw new StopFailed("Could not stop database");
    }

    public Process start(String string) throws IOException {
        String string2 = KBProperties.get("com.kb.java", "java");
        if (string == null) {
            string = "";
        }
        return Runtime.getRuntime().exec(new String[]{string2, "-Dcom.kb.xsb.args=-q", "-Dcom.kb.server.trace=" + string, "com.kb.server.RemoteKBServer", this.getName()});
    }

    public Process startAndWait(String string, int n) throws IOException, StartFailed {
        Process process = this.start(string);
        int n2 = 0;
        while (n2 < n) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.isStarted()) {
                return process;
            }
            try {
                int n3 = process.exitValue();
                if (n3 == -7) {
                    throw new StartFailedNoLicense();
                }
                throw new StartFailed("Database crashed during startup");
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                ++n2;
            }
        }
        throw new StartFailed("Database not responding");
    }

    public static void main(String[] stringArray) throws Exception {
        Database.test("oms");
        Database.test("//localhost/oms");
        Database.test("myDatabase");
        Database.test("local:myDatabase");
        Database.test("remote://localhost/myDatabase");
        Database.test("remote://anotherHost/myDatabase");
        Database.test("local:/dev/dbs/myDatabase");
        Database.test("ow:remote://localhost/myDatabase");
        Database.test("ow:remote://localhost:1234");
        Database.test("//dill/obrdb");
    }
}

