/*
 * Decompiled with CFR 0.152.
 */
package com.kb.client;

import com.kb.client.BadConfiguration;
import com.kb.client.CommunicationsFailure;
import com.kb.client.ConnectionFailure;
import com.kb.client.Database;
import com.kb.client.HardICViolation;
import com.kb.client.IKBObject;
import com.kb.client.InvalidIsolationLevel;
import com.kb.client.InvalidPassword;
import com.kb.client.Isolation;
import com.kb.client.KBError;
import com.kb.client.KBObject;
import com.kb.client.NotOMS;
import com.kb.client.Query;
import com.kb.client.QueryFailure;
import com.kb.client.RequestFailure;
import com.kb.client.Results;
import com.kb.client.ResultsAnswers;
import com.kb.client.SMConnection;
import com.kb.client.Violation;
import com.kb.client_server.Answers;
import com.kb.client_server.ICStatus;
import com.kb.client_server.KBServer;
import com.kb.client_server.RemoteKBStub;
import com.kb.client_server.WireProtocol;
import com.kb.kbddutil.APISupport;
import com.kb.kbddutil.KBProperties;
import com.kb.owl.Form;
import com.kb.owl.IVar;
import com.kb.owl.KBDate;
import com.kb.owl.OWL;
import com.kb.owl.Symbol;
import com.kb.owl.SyntaxError;
import com.kb.owl.Time;
import com.kb.xsb.Structure;
import com.kb.xsb.Variable;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class Connection
extends SMConnection
implements WireProtocol {
    Dictionary functionConstructors = new Hashtable();
    boolean readOnly = false;
    final Database db;
    private static boolean autoName = false;
    String databaseName;
    String urlString;
    static /* synthetic */ Class class$com$kb$owl$OWL;
    static /* synthetic */ Class class$com$kb$client$KBObject;

    public boolean getAutoCommit() {
        return this.server.getDefaultAutoCommit();
    }

    public Connection() throws ConnectionFailure {
        this((String)null);
    }

    public Connection(String string) throws ConnectionFailure {
        this(string, false);
    }

    public Connection(String string, boolean bl) throws ConnectionFailure {
        this(string, null, null, bl);
    }

    public Connection(String string, String string2, String string3, boolean bl) throws ConnectionFailure {
        try {
            this.db = new Database(string);
            this.databaseName = this.db.getDatabaseName();
            this.urlString = this.db.getURLString();
            this.readOnly = bl;
            this.connectTo(this.db);
            if (string2 != null && string3 != null) {
                this.server.login(string3, string2);
            }
        }
        catch (InvalidPassword invalidPassword) {
            throw new InvalidPassword("Invalid password", invalidPassword);
        }
        catch (CommunicationsFailure communicationsFailure) {
            throw new ConnectionFailure("Cannot login due to communications failure", communicationsFailure);
        }
        catch (IOException iOException) {
            throw new BadConfiguration("Cannot find properties for " + string, iOException);
        }
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public Connection(String string, String string2, String string3) throws ConnectionFailure {
        this(string, string2, string3, false);
    }

    public void begin() {
        this.setAutoCommit(false);
    }

    public void setAutoCommit(boolean bl) {
        this.getServer().setDefaultAutoCommit(bl);
    }

    public Violation[] icquery() throws RequestFailure, IOException {
        return APISupport.convertViolations(this.getServer().listICViolations());
    }

    public boolean isIntegrityConstraintViolation(Violation violation) throws RequestFailure, IOException {
        return this.getServer().recheckIntegrityConstraintViolation(violation.head());
    }

    public Violation[] checkIntegrityConstraints() throws RequestFailure {
        return APISupport.convertViolations(this.getServer().checkIntegrityConstraints());
    }

    public Violation[] commit() throws HardICViolation {
        return this.checkStatus(this.getServer().commit());
    }

    Violation[] checkStatus(ICStatus iCStatus) throws HardICViolation {
        if (iCStatus == null) {
            return new Violation[0];
        }
        Violation[] violationArray = APISupport.convertViolations(iCStatus);
        if (!iCStatus.databaseOK()) {
            throw new HardICViolation("Operation failed", violationArray);
        }
        return violationArray;
    }

    public void rollback() throws ConnectionFailure {
        try {
            this.getServer().rollback();
        }
        catch (Exception exception) {
            throw new ConnectionFailure(exception);
        }
    }

    private void connectTo(Database database) throws ConnectionFailure {
        try {
            if (this.heartbeat > 0) {
                System.out.println("Connecting to " + database);
            }
            this.server = database.isLocal() ? (KBServer)Class.forName("com.kb.client_server.LocalKBStub").getConstructors()[0].newInstance(database, new Boolean(this.readOnly)) : new RemoteKBStub(database);
        }
        catch (Throwable throwable) {
            throw new ConnectionFailure("Cannot connect to " + database.getDatabaseName() + " at " + database, throwable);
        }
    }

    public static Connection connect(String string) {
        return Connection.connect(string, Integer.MAX_VALUE);
    }

    public static Connection connect(String string, int n) {
        return Connection.connect(string, null, null, false, n);
    }

    public static Connection connect(String string, String string2, String string3, boolean bl, int n) throws InvalidPassword {
        long l = System.currentTimeMillis();
        while (System.currentTimeMillis() < l + (long)n) {
            try {
                Connection connection = new Connection(string, string2, string3, bl);
                if (connection != null) {
                    return connection;
                }
            }
            catch (InvalidPassword invalidPassword) {
                throw invalidPassword;
            }
            catch (KBError kBError) {
                // empty catch block
            }
            try {
                Thread.sleep(Math.min(1000, n));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return null;
    }

    public Properties getServerProperties() {
        return this.server.getProperties();
    }

    public Connection(String string, int n) throws ConnectionFailure {
        try {
            if (string == null) {
                string = KBProperties.get("host", null);
                if ("".equals(string)) {
                    string = null;
                }
                n = KBProperties.getInt("port", 44061);
            }
            this.db = string != null ? new Database("//" + string + ":" + n) : new Database();
            this.connectTo(this.db);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(this.errorlog);
            throw new ConnectionFailure(throwable);
        }
    }

    public Connection(Connection connection) {
        this.server = connection.server;
        this.db = connection.db;
    }

    OWL getTypeID(int n) {
        return this.types[n];
    }

    Class getImplClass(Class clazz) {
        try {
            return this.getImplClass(clazz.getField("collection_id").getInt(null));
        }
        catch (Exception exception) {
            throw new RuntimeException(clazz.getName() + " is not a Knowledge Bus class");
        }
    }

    Class getImplClass(int n) {
        if (this.classes[n] == null) {
            Class clazz;
            this.classes[n] = clazz = this.getImplClass(this.types[n]);
            return clazz;
        }
        return this.classes[n];
    }

    Class getImplClass(OWL oWL) {
        try {
            return Class.forName(APISupport.varName(oWL, this.pkg).replace('/', '.'));
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not create class for " + oWL + " due to " + exception);
        }
    }

    public void close() throws ConnectionFailure {
        try {
            this.getServer().close();
            Object var2_1 = null;
            this.server = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.server = null;
            throw throwable;
        }
    }

    public boolean isClosed() {
        return this.server == null;
    }

    public void setTransactionIsolation(int n) throws InvalidIsolationLevel {
        this.getServer().setDefaultIsolationLevel(Isolation.getIsolation(n));
    }

    public void setIsolation(Isolation isolation) {
        this.getServer().setDefaultIsolationLevel(isolation);
    }

    public int getTransactionIsolation() {
        return this.getServer().getDefaultIsolationLevel().level();
    }

    public Isolation getIsolation() {
        if (this.server == null) {
            System.out.println("Server is null");
        }
        return this.getServer().getDefaultIsolationLevel();
    }

    public Violation[] insert(OWL oWL) throws RequestFailure, HardICViolation {
        return this.checkStatus(this.getServer().insert(oWL));
    }

    public Violation[] delete(OWL oWL) throws RequestFailure, HardICViolation {
        return this.checkStatus(this.getServer().delete(oWL));
    }

    public static IVar[] findVars(OWL oWL) {
        Vector vector = new Vector();
        Connection.findIVars(oWL, vector);
        Object[] objectArray = new IVar[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    static void findIVars(OWL oWL, Vector vector) {
        if (oWL instanceof IVar && !vector.contains(oWL) && !((IVar)oWL).isAnonymous()) {
            vector.addElement(oWL);
        }
        int n = 0;
        while (n < oWL.arity()) {
            Connection.findIVars(oWL.arg(n), vector);
            ++n;
        }
    }

    public IKBObject getType(Class clazz) {
        try {
            int n = clazz.getField("collection_id").getInt(null);
            return this.createObject(this.getImplementation(Class.forName(this.pkg + "RootCtx.Property")), this.getTypeID(n));
        }
        catch (Exception exception) {
            throw new RuntimeException(clazz.getName() + " is not a Knowledge Bus class");
        }
    }

    public IKBObject cast(Class clazz, IKBObject iKBObject) throws ClassCastException {
        if (clazz.isInstance(iKBObject)) {
            return iKBObject;
        }
        try {
            OWL oWL = this.getTypeID(clazz.getField("collection_id").getInt(null));
            if (this.query(new Form(oWL, iKBObject.getOid())).yes()) {
                KBObject kBObject = (KBObject)iKBObject;
                return this.createObject(this.getImplementation(clazz), kBObject.oid);
            }
            throw new ClassCastException(iKBObject + " is not a " + oWL);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new Error("Invalid IKBObject class " + clazz.getName());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error("Invalid IKBObject class " + clazz.getName());
        }
        catch (QueryFailure queryFailure) {
            throw new KBError("API implementation error", queryFailure);
        }
    }

    KBObject createObject(Class clazz, OWL oWL) {
        KBObject kBObject = null;
        if (oWL instanceof Form) {
            kBObject = this.makeStructuredObject(clazz, (Form)oWL);
        }
        if (kBObject == null) {
            try {
                kBObject = (KBObject)clazz.newInstance();
                kBObject.oid = oWL;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(this.errorlog);
                throw new RuntimeException("Could not create Java object for " + oWL + " due to " + throwable);
            }
        }
        kBObject.setConnection(this);
        return kBObject;
    }

    KBObject makeStructuredObject(Class clazz, Form form) {
        Object object;
        KBObject kBObject = null;
        OWL oWL = form.functor();
        Constructor constructor = (Constructor)this.functionConstructors.get(oWL);
        if (constructor == null && clazz != null) {
            try {
                constructor = clazz.getConstructor(class$com$kb$owl$OWL == null ? (class$com$kb$owl$OWL = Connection.class$("com.kb.owl.OWL")) : class$com$kb$owl$OWL);
                this.functionConstructors.put(oWL, constructor);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (constructor == null) {
            String string = APISupport.functionName(oWL, this.pkg).replace('/', '.');
            try {
                object = Class.forName(string);
                Class[] classArray = new Class[]{};
                if (clazz != null) {
                    classArray = clazz.getInterfaces();
                    if (classArray.length != 1) {
                        throw new KBError("Unexpected interface structure in class " + clazz.getName() + "; " + classArray.length + " interfaces");
                    }
                    if (!classArray[0].isAssignableFrom((Class<?>)object)) {
                        throw new KBError("Received structured object " + form + " which is not compatible with type " + classArray[0].getName());
                    }
                }
                constructor = ((Class)object).getConstructor(class$com$kb$owl$OWL == null ? (class$com$kb$owl$OWL = Connection.class$("com.kb.owl.OWL")) : class$com$kb$owl$OWL);
                this.functionConstructors.put(oWL, constructor);
            }
            catch (Throwable throwable) {
                throw new KBError("Cannot find class " + string + " for OID " + form, throwable);
            }
        }
        try {
            if (constructor != null) {
                kBObject = (KBObject)constructor.newInstance(form);
            }
        }
        catch (Throwable throwable) {
            object = "Could not create " + constructor.toString() + " for " + form;
            this.errorlog.println((String)object);
            throw new KBError((String)object, throwable);
        }
        return kBObject;
    }

    public Violation[] insert(OWL oWL, OWL[] oWLArray) throws RequestFailure, HardICViolation {
        return this.insert(new Form(oWL, oWLArray));
    }

    public Query inquire(OWL oWL) {
        Query query = new Query(oWL, this);
        return query;
    }

    public Query inquire(String string) {
        return this.inquire(new Form(string));
    }

    public Query inquire(String string, String string2) {
        return this.inquire(new Form(string, (OWL)new Symbol(string2)));
    }

    public Query inquire(String string, OWL oWL) {
        return this.inquire(new Form(string, oWL));
    }

    public Query inquire(String string, OWL oWL, String string2) {
        return this.inquire(new Form(string, oWL, (OWL)new Symbol(string2)));
    }

    public Query inquire(String string, OWL oWL, OWL oWL2) {
        return this.inquire(new Form(string, oWL, oWL2));
    }

    public Query inquire(String string, String string2, String string3) {
        return this.inquire(new Form(string, (OWL)new Symbol(string2), (OWL)new Symbol(string3)));
    }

    public Results query(OWL oWL) throws ConnectionFailure, QueryFailure {
        IVar[] iVarArray = Connection.findVars(oWL);
        return new ResultsAnswers(this.getServer().query(oWL, Connection.findVars(oWL), -1, this.getAutoCommit(), this.getIsolation()), iVarArray);
    }

    public Results query(String string, OWL oWL) throws ConnectionFailure, QueryFailure {
        return this.query(new Form(string, oWL));
    }

    public Results query(String string, OWL oWL, OWL oWL2) throws ConnectionFailure, QueryFailure {
        return this.query(new Form(string, oWL, oWL2));
    }

    public Results query(String string, OWL oWL, OWL oWL2, OWL oWL3) throws ConnectionFailure, QueryFailure {
        return this.query(new Form(string, oWL, oWL2, oWL3));
    }

    public Results query(String string, OWL oWL, OWL oWL2, OWL oWL3, OWL oWL4) throws ConnectionFailure, QueryFailure {
        return this.query(new Form(string, new OWL[]{oWL, oWL2, oWL3, oWL4}));
    }

    public Results query(String string, OWL oWL, OWL oWL2, OWL oWL3, OWL oWL4, OWL oWL5) throws ConnectionFailure, QueryFailure {
        return this.query(new Form(string, new OWL[]{oWL, oWL2, oWL3, oWL4, oWL5}));
    }

    public Object[] extent(Class clazz) throws QueryFailure, ConnectionFailure {
        Class clazz2 = this.getImplementation(clazz);
        Results results = this.query(this.type(clazz).name(), new IVar("X"));
        Object[] objectArray = (Object[])Array.newInstance(clazz, results.count());
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = this.createObject(clazz2, results.answer(n, 0));
            ++n;
        }
        return objectArray;
    }

    Class getImplementation(Class clazz) {
        int n;
        Class clazz2 = clazz;
        clazz2 = clazz2.getSuperclass();
        while (clazz2 != null) {
            if (clazz2.equals(class$com$kb$client$KBObject == null ? Connection.class$("com.kb.client.KBObject") : class$com$kb$client$KBObject)) {
                return clazz;
            }
            clazz2 = clazz2.getSuperclass();
        }
        try {
            n = clazz.getField("collection_id").getInt(null);
        }
        catch (Exception exception) {
            throw new RuntimeException(clazz.getName() + " is not a Knowledge Bus class");
        }
        return this.getImplClass(n);
    }

    OWL type(Class clazz) {
        try {
            int n = clazz.getField("collection_id").getInt(null);
            return this.types[n];
        }
        catch (Exception exception) {
            throw new ConnectionFailure(exception);
        }
    }

    public IKBObject create(Class clazz) throws RequestFailure, ConnectionFailure {
        OWL oWL = this.getServer().create(this.type(clazz), this.getAutoCommit(), this.getIsolation());
        return this.createObject(this.getImplementation(clazz), oWL);
    }

    public Class findClass(OWL oWL) throws ClassNotFoundException {
        return Class.forName(this.pkg + APISupport.className(oWL).replace('/', '.'));
    }

    public void setAutoName(boolean bl) {
        autoName = bl;
    }

    public boolean getAutoName() {
        return autoName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getURLString() {
        return this.urlString;
    }

    public static Date parseDate(String string) throws SyntaxError {
        if (string.equals("start")) {
            return KBDate.start;
        }
        if (string.equals("now")) {
            return KBDate.now;
        }
        long[] lArray = Time.date2java(string);
        return new Date(lArray[0]);
    }

    public static Date[] parseSpan(String string) throws SyntaxError {
        long[] lArray = Time.date2java(string);
        return new Date[]{new Date(lArray[0]), new Date(lArray[1])};
    }

    public Database getDatabase() {
        return this.db;
    }

    public Symbol disambiguateSymbol(Symbol symbol, Symbol symbol2) {
        if (!this.getDatabase().isOMS()) {
            throw new NotOMS();
        }
        try {
            if (symbol.toString().indexOf(46) >= 0) {
                return symbol;
            }
            Answers answers = this.query(new Structure("oms_disambiguate_symbol", symbol.toString(), new Variable(), new Variable("X")));
            if (answers.yes()) {
                return new Symbol(answers.answer(0, 1).toString());
            }
            if (symbol2 == null) {
                return null;
            }
            return new Symbol(symbol2 + "." + symbol);
        }
        catch (QueryFailure queryFailure) {
            throw new KBError("Incorrectly configured oms", queryFailure);
        }
    }

    public OWL disambiguate(OWL oWL, Symbol symbol) {
        if (oWL instanceof Symbol) {
            return this.disambiguateSymbol((Symbol)oWL, symbol);
        }
        if (oWL instanceof Form) {
            Form form = (Form)oWL;
            OWL[] oWLArray = new OWL[form.arity()];
            int n = 0;
            while (n < oWLArray.length) {
                oWLArray[n] = this.disambiguate(form.arg(n), symbol);
                ++n;
            }
            return new Form(this.disambiguate(form.functor(), symbol), oWLArray);
        }
        return oWL;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

