/*
 * Decompiled with CFR 0.152.
 */
package com.kb.apps;

import com.kb.client.Connection;
import com.kb.client.QueryFailure;
import com.kb.client.Results;
import com.kb.gui.TableSorter;
import com.kb.gui.Util;
import com.kb.gui.oms.AppWindow;
import com.kb.gui.oms.CloseAppWinAction;
import com.kb.owl.IVar;
import com.kb.owl.OWL;
import com.kb.owl.OWLParser;
import com.kb.owl.SyntaxError;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;

public class QueryPane
extends AppWindow
implements ActionListener {
    Connection connection;
    JTextField queryField;
    JTextArea respArea;
    JTable respTable;
    RespModel respModel;
    JTabbedPane tabPane;
    JMenuItem closeMI;
    JMenuItem cutMI;
    JMenuItem copyMI;
    JMenuItem pasteMI;

    public static void main(String[] stringArray) {
        try {
            Connection connection = new Connection(stringArray[0]);
            QueryPane queryPane = new QueryPane(connection);
            ((Component)queryPane).setVisible(true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public QueryPane(Connection connection) {
        super("Query " + connection.getDatabaseName());
        this.connection = connection;
        this.initMenuBar();
        this.initPane();
        this.setDisposeOnClose(true);
    }

    private void initMenuBar() {
        JMenu jMenu = Util.createJMenu('G', "General");
        Util.createMI(jMenu, "aX", 'c', new CloseAppWinAction(this));
        JMenu jMenu2 = Util.createJMenu('E', "Edit");
        this.cutMI = this.createMI(jMenu2, "cX", 't', "Cut");
        this.copyMI = this.createMI(jMenu2, "cC", 'c', "Copy");
        this.pasteMI = this.createMI(jMenu2, "cV", 'p', "Paste");
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        this.setJMenuBar(jMenuBar);
    }

    private JMenuItem createMI(JMenu jMenu, String string, char c, String string2) {
        return Util.createMI(jMenu, this, string, c, string2);
    }

    private JMenuItem createMI(JMenu jMenu, String string, String string2) {
        return Util.createMI(jMenu, this, string, string2);
    }

    private void initPane() {
        JLabel jLabel = new JLabel("Query:");
        this.queryField = new JTextField();
        this.queryField.addActionListener(this);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("West", jLabel);
        jPanel.add("Center", this.queryField);
        this.respModel = new RespModel();
        TableSorter tableSorter = new TableSorter(this.respModel);
        this.respTable = new JTable(tableSorter);
        this.respTable.setCellSelectionEnabled(true);
        this.respTable.setSelectionMode(0);
        tableSorter.addMouseListenerToHeaderInTable(this.respTable);
        this.respArea = new JTextArea();
        this.respArea.setEditable(false);
        this.tabPane = new JTabbedPane();
        this.tabPane.add("Table", new JScrollPane(this.respTable));
        this.tabPane.add("Text", new JScrollPane(this.respArea));
        this.setTableEnabled(false);
        JLabel jLabel2 = new JLabel("Response:");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add("North", jLabel2);
        jPanel2.add("Center", this.tabPane);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add("North", jPanel);
        container.add("Center", jPanel2);
        this.pack();
    }

    private void processQuery() {
        try {
            OWLParser oWLParser = new OWLParser(new StringReader(this.queryField.getText()));
            Results results = this.connection.query(oWLParser.readExpr());
            this.respArea.setText(this.toStringTable(results));
            this.respModel.setData(results);
            this.setTableEnabled(results.count() > 1);
        }
        catch (QueryFailure queryFailure) {
            this.respArea.setText(queryFailure.getMessage());
        }
        catch (SyntaxError syntaxError) {
            this.respArea.setText(syntaxError.getMessage());
        }
        catch (Error error) {
            this.respArea.setText("\"" + this.queryField.getText() + "\" caused this error:\n" + error.toString());
            error.printStackTrace();
            this.setTableEnabled(false);
        }
        catch (Throwable throwable) {
            try {
                StringWriter stringWriter = new StringWriter();
                throwable.printStackTrace(new PrintWriter(stringWriter));
                stringWriter.close();
                this.respArea.setText(stringWriter.toString());
                this.setTableEnabled(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void cut() {
        if (this.queryField.getSelectedText() != null) {
            this.queryField.cut();
        } else {
            this.respArea.cut();
        }
    }

    private void copy() {
        if (this.queryField.getSelectedText() != null) {
            this.queryField.copy();
        } else {
            this.respArea.copy();
        }
    }

    private void paste() {
        this.queryField.paste();
    }

    private String toStringTable(Results results) {
        if (results.count() == 0) {
            return "False";
        }
        StringBuffer stringBuffer = new StringBuffer();
        OWL[][] oWLArray = results.asArray();
        if (oWLArray[0].length == 0) {
            return "True";
        }
        int n = 0;
        while (n < oWLArray.length) {
            int n2 = 0;
            while (n2 < oWLArray[n].length) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(oWLArray[n][n2].toString());
                ++n2;
            }
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    private void setTableEnabled(boolean bl) {
        int n = this.tabPane.indexOfTab("Table");
        int n2 = this.tabPane.indexOfTab("Text");
        this.tabPane.setEnabledAt(n, bl);
        int n3 = bl ? n : n2;
        this.tabPane.setSelectedIndex(n3);
        this.tabPane.revalidate();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.queryField) {
            this.processQuery();
        } else if (object == this.cutMI) {
            this.cut();
        } else if (object == this.copyMI) {
            this.copy();
        } else if (object == this.pasteMI) {
            this.paste();
        }
    }

    class RespModel
    extends AbstractTableModel {
        Object[][] ans;
        String[] cols;

        RespModel() {
        }

        public int getColumnCount() {
            if (this.ans == null) {
                return 0;
            }
            if (this.ans.length == 0) {
                return 0;
            }
            return this.ans[0].length;
        }

        public int getRowCount() {
            return this.ans == null ? 0 : this.ans.length;
        }

        public Object getValueAt(int n, int n2) {
            return this.ans == null ? null : this.ans[n][n2];
        }

        public String getColumnName(int n) {
            return this.cols == null ? null : this.cols[n];
        }

        public void setData(Results results) {
            if (results == null) {
                return;
            }
            this.ans = results.asArray();
            IVar[] iVarArray = results.getVars();
            this.cols = new String[iVarArray.length];
            int n = 0;
            while (n < iVarArray.length) {
                this.cols[n] = ((Object)iVarArray[n]).toString();
                ++n;
            }
            this.fireTableStructureChanged();
        }
    }
}

