/*
 * Decompiled with CFR 0.152.
 */
package com.kb.apps;

import com.kb.apps.TagEntry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class KFLTags {
    static int ntags = 0;

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("No input files specified.");
        } else {
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter("TAGS"));
                int n = 0;
                while (n < stringArray.length) {
                    if (new File(stringArray[n]).isDirectory()) {
                        KFLTags.processDirectory(stringArray[n], printWriter);
                    } else {
                        KFLTags.processFile(stringArray[n], printWriter);
                    }
                    ++n;
                }
                printWriter.close();
            }
            catch (IOException iOException) {
                System.err.println("TAGS: " + iOException);
            }
        }
        System.out.println(ntags + " tags generated");
    }

    public static void processDirectory(String string, PrintWriter printWriter) {
        File file = new File(string);
        String[] stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".kfl");
            }
        });
        int n = 0;
        while (n < stringArray.length) {
            KFLTags.processFile(string + "/" + stringArray[n], printWriter);
            ++n;
        }
    }

    public static void processFile(String string, PrintWriter printWriter) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            LineNumberReader lineNumberReader = new LineNumberReader(bufferedReader);
            Vector<TagEntry> vector = new Vector<TagEntry>();
            int n = 0;
            while (true) {
                int n2;
                int n3 = n;
                StringBuffer stringBuffer = new StringBuffer();
                while (true) {
                    n2 = lineNumberReader.read();
                    ++n;
                    if (n2 == 10 || n2 == -1) break;
                    stringBuffer.append((char)n2);
                }
                String string2 = stringBuffer.toString();
                if (n2 == -1) break;
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                try {
                    String string3 = stringTokenizer.nextToken();
                    if (!string3.equals(":Type") && !string3.equals(":Fun") && !string3.equals(":Const") && !string3.equals(":Pred")) continue;
                    String string4 = stringTokenizer.nextToken();
                    vector.addElement(new TagEntry(string2, string4, n, lineNumberReader.getLineNumber()));
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n4 = 0;
            while (n4 < vector.size()) {
                TagEntry tagEntry = (TagEntry)vector.elementAt(n4);
                stringBuffer.append(tagEntry.pat);
                stringBuffer.append('\u007f');
                stringBuffer.append(tagEntry.name);
                stringBuffer.append('\u0001');
                stringBuffer.append(Integer.toString(tagEntry.line));
                stringBuffer.append(',');
                stringBuffer.append(Integer.toString(tagEntry.pos));
                stringBuffer.append('\n');
                ++n4;
            }
            printWriter.println("\f\n" + string + "," + stringBuffer.length());
            printWriter.print(stringBuffer);
            ++ntags;
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }
}

