/*
 * Decompiled with CFR 0.152.
 */
package com.kb.admin;

import com.kb.admin.AnswerModel;
import com.kb.client.Connection;
import com.kb.client.RequestFailure;
import com.kb.client.Results;
import com.kb.gui.TableSorter;
import com.kb.owl.Form;
import com.kb.owl.OWL;
import com.kb.owl.OWLParser;
import com.ow.gui.iode.IODETable;
import com.ow.gui.iode.IODETableSorter;
import com.ow.gui.iode.IODEThrowableDisplayer;
import com.ow.util.OWUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;

public class QueryResultsPane
extends JScrollPane {
    Connection conn;
    AnswerModel answerModel;
    JTable answerTable;
    JTextArea messagePane;
    TableSorter sorter;

    public static void main(String[] stringArray) {
        String string = null;
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        Connection connection = new Connection(string);
        JFrame jFrame = new JFrame("Query " + connection.getDatabaseName());
        QueryResultsPane queryResultsPane = new QueryResultsPane(connection);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setColumns(60);
        JButton jButton = new JButton(queryResultsPane.new GoAction(jTextArea));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JScrollPane(jTextArea), "Center");
        jPanel.add((Component)jButton, "East");
        jFrame.getContentPane().add((Component)jPanel, "North");
        jFrame.getContentPane().add((Component)queryResultsPane, "Center");
        jFrame.pack();
        ((Component)jFrame).setVisible(true);
    }

    QueryResultsPane(Connection connection) {
        this.conn = connection;
        this.answerModel = new AnswerModel();
        this.sorter = new IODETableSorter(this.answerModel);
        this.answerTable = new IODETable(this.sorter);
        this.answerTable.setCellSelectionEnabled(true);
        this.answerTable.setSelectionMode(0);
        this.messagePane = new JTextArea();
        this.messagePane.setEditable(false);
        this.setViewportView(this.messagePane);
        this.addWiring();
    }

    private void addWiring() {
        this.sorter.addMouseListenerToHeaderInTable(this.answerTable);
    }

    public void query(OWL oWL) throws RequestFailure {
        Results results = this.conn.query(oWL);
        if (results != null && results.count() > 0) {
            this.answerModel.setData(results, oWL);
            this.setViewportView(this.answerTable);
        } else {
            this.messagePane.setText(results == null ? (OWUtil.isGround((Form)oWL) ? "False." : "No answers were found.") : "True.");
            this.setViewportView(this.messagePane);
        }
    }

    protected OWL[][] getAnswersNoCopy() {
        return this.answerModel.ans;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.addWiring();
    }

    class GoAction
    extends AbstractAction {
        JTextComponent text;

        GoAction(JTextComponent jTextComponent) {
            super("Ask");
            this.text = jTextComponent;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                OWLParser oWLParser = new OWLParser(new StringReader(this.text.getText()));
                QueryResultsPane.this.query(oWLParser.readExpr());
            }
            catch (Throwable throwable) {
                new IODEThrowableDisplayer().handle(throwable);
            }
        }
    }
}

