/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.sql.SQLException;
import oracle.sql.converter.CharacterConverter;

public abstract class CharacterConverter1Byte
extends CharacterConverter {
    static final int ORACHARMASK = 255;
    static final int UCSCHARWIDTH = 16;
    transient int m_l1KeyWidth;
    transient int m_l1KeyShift;
    transient int m_l1KeyMask;
    transient int m_l2KeyMask;
    transient char m_ucsReplacement;
    transient char[] m_ucsChar;
    transient char[] m_oraCharLevel1;
    transient byte[] m_oraCharLevel2;
    transient byte m_oraCharReplacement;

    CharacterConverter1Byte() {
        this.m_groupId = 1;
    }

    char toUnicode(byte by) throws SQLException {
        char c = this.m_ucsChar[by & 0xFF];
        if (c == this.m_ucsReplacement) {
            throw new SQLException("Cannot map Oracle character to Unicode.");
        }
        return c;
    }

    char toUnicodeWithReplacement(byte by) {
        return this.m_ucsChar[by & 0xFF];
    }

    byte toOracleCharacter(char c) throws SQLException {
        int n = c >> this.m_l1KeyShift & this.m_l1KeyMask;
        int n2 = c & this.m_l2KeyMask;
        byte by = this.m_oraCharLevel2[this.m_oraCharLevel1[n] + n2];
        if (by == this.m_oraCharReplacement) {
            throw new SQLException("Cannot map Unicode to Oracle character.");
        }
        return by;
    }

    byte toOracleCharacterWithReplacement(char c) {
        int n = c >> this.m_l1KeyShift & this.m_l1KeyMask;
        int n2 = c & this.m_l2KeyMask;
        return this.m_oraCharLevel2[this.m_oraCharLevel1[n] + n2];
    }

    public String toUnicodeString(byte[] byArray, int n, int n2) throws SQLException {
        char[] cArray = new char[n2];
        int n3 = 0;
        while (n3 < n2) {
            cArray[n3] = this.m_ucsChar[byArray[n3] & 0xFF];
            if (cArray[n3] == this.m_ucsReplacement) {
                throw new SQLException("Cannot map Oracle character to Unicode.");
            }
            ++n3;
        }
        return new String(cArray);
    }

    public String toUnicodeStringWithReplacement(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2];
        int n3 = 0;
        while (n3 < n2) {
            cArray[n3] = this.m_ucsChar[byArray[n3] & 0xFF];
            ++n3;
        }
        return new String(cArray);
    }

    public byte[] toOracleString(String string) throws SQLException {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = this.toOracleCharacter(cArray[n2]);
            ++n2;
        }
        return byArray;
    }

    public byte[] toOracleStringWithReplacement(String string) {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = this.toOracleCharacterWithReplacement(cArray[n2]);
            ++n2;
        }
        return byArray;
    }

    protected void buildUnicodeToOracleMapping(char[][] cArray) {
        int n;
        int n2;
        int n3;
        int n4;
        char c;
        int n5 = this.m_l1KeyWidth;
        int n6 = 16 - n5;
        int n7 = (1 << n5) - 1;
        int n8 = (1 << n6) - 1;
        this.m_l1KeyShift = n6;
        this.m_l1KeyMask = n7;
        this.m_l2KeyMask = n8;
        int n9 = 1 << n5;
        char[] cArray2 = new char[n9];
        char[][] cArray3 = new char[n9][2];
        int n10 = 0;
        while (n10 < n9) {
            cArray2[n10] = '\u0000';
            cArray3[n10][0] = (char)n8;
            cArray3[n10][1] = '\u0000';
            ++n10;
        }
        int n11 = this.m_ucsChar.length;
        char c2 = this.m_ucsReplacement;
        n10 = 0;
        while (n10 < n11) {
            c = this.m_ucsChar[n10];
            if (c != c2) {
                n4 = c >> n6 & n7;
                cArray2[n4] = '\u0001';
                n3 = c & n8;
                if (n3 < cArray3[n4][0]) {
                    cArray3[n4][0] = (char)n3;
                }
                if (n3 > cArray3[n4][1]) {
                    cArray3[n4][1] = (char)n3;
                }
            }
            ++n10;
        }
        if (cArray != null) {
            n11 = cArray.length;
            n10 = 0;
            while (n10 < n11) {
                c = cArray[n10][0];
                n4 = c >> n6 & n7;
                cArray2[n4] = '\u0001';
                n3 = c & n8;
                if (n3 < cArray3[n4][0]) {
                    cArray3[n4][0] = (char)n3;
                }
                if (n3 > cArray3[n4][1]) {
                    cArray3[n4][1] = (char)n3;
                }
                ++n10;
            }
        }
        int n12 = n2 = n8 + 1;
        int n13 = 0;
        n10 = 0;
        while (n10 < n9) {
            if (cArray2[n10] != '\u0000') {
                int n14 = cArray3[n10][0];
                cArray2[n10] = (char)(n12 - (n13 < n14 ? n13 : n14));
                n12 = cArray2[n10] + n2;
                n13 = n2 - cArray3[n10][1] - 1;
            }
            ++n10;
        }
        byte by = this.m_oraCharReplacement;
        byte[] byArray = new byte[n12];
        n10 = 0;
        while (n10 < n12) {
            byArray[n10] = by;
            ++n10;
        }
        n11 = this.m_ucsChar.length;
        n10 = 0;
        while (n10 < n11) {
            c = this.m_ucsChar[n10];
            if (c != c2 && byArray[n = cArray2[n4 = c >> n6 & n7] + (n3 = c & n8)] == by) {
                byArray[n] = (byte)n10;
            }
            ++n10;
        }
        if (cArray != null) {
            n11 = cArray.length;
            n10 = 0;
            while (n10 < n11) {
                c = cArray[n10][0];
                n4 = c >> n6 & n7;
                n3 = c & n8;
                n = cArray2[n4] + n3;
                if (byArray[n] == by) {
                    byArray[n] = (byte)cArray[n10][1];
                }
                ++n10;
            }
        }
        this.m_oraCharLevel1 = cArray2;
        this.m_oraCharLevel2 = byArray;
    }
}

