/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Dictionary;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.StructMetaData;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc2.SQLInput;
import oracle.jdbc2.SQLOutput;
import oracle.sql.Datum;
import oracle.sql.OracleJdbc2SQLInput;
import oracle.sql.OracleSQLOutput;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;

public class StructDescriptor {
    static final boolean DEBUG = false;
    String m_name;
    SQLName m_sqlName;
    OracleTypeADT m_oracleTypeADT;
    OracleConnection m_conn;

    public static StructDescriptor createDescriptor(String string, Connection connection) throws SQLException {
        SQLName sQLName;
        String string2;
        StructDescriptor structDescriptor;
        if (string == null || string.length() == 0 || connection == null) {
            DBError.check_error(60, "Invalid arguments");
        }
        if ((structDescriptor = (StructDescriptor)((OracleConnection)connection).getDescriptor(string2 = (sQLName = new SQLName(string, (OracleConnection)connection)).getName())) == null) {
            structDescriptor = new StructDescriptor(sQLName, connection);
        }
        ((OracleConnection)connection).putDescriptor(string2, structDescriptor);
        return structDescriptor;
    }

    public StructDescriptor(String string, Connection connection) throws SQLException {
        if (string == null || string.length() == 0 || connection == null) {
            DBError.check_error(60, "Invalid arguments");
        }
        this.m_conn = (OracleConnection)connection;
        this.m_sqlName = new SQLName(string, this.m_conn);
        this.m_name = this.m_sqlName.getName();
        try {
            this.m_oracleTypeADT = new OracleTypeADT(this.m_name, this.m_conn);
            this.m_conn.db_access.getOracleTypeADT(this.m_oracleTypeADT);
            this.m_oracleTypeADT.init(this.m_conn);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            DBError.check_error(60, "Unable to resolve type \"" + this.m_name + "\"");
            return;
        }
    }

    public StructDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        if (sQLName == null || connection == null) {
            DBError.check_error(60, "Invalid arguments");
        }
        this.m_sqlName = sQLName;
        this.m_name = this.m_sqlName.getName();
        this.m_conn = (OracleConnection)connection;
        try {
            this.m_oracleTypeADT = new OracleTypeADT(this.m_name, this.m_conn);
            this.m_conn.db_access.getOracleTypeADT(this.m_oracleTypeADT);
            this.m_oracleTypeADT.init(this.m_conn);
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            DBError.check_error(60, "Unable to resolve type \"" + this.m_name + "\"");
            return;
        }
    }

    public StructDescriptor(SQLName sQLName, OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        if (sQLName == null || oracleTypeADT == null || connection == null) {
            DBError.check_error(60, "Invalid arguments");
        }
        this.m_sqlName = sQLName;
        this.m_name = this.m_sqlName.getName();
        this.m_conn = (OracleConnection)connection;
        this.m_oracleTypeADT = oracleTypeADT;
    }

    public byte[] toBytes(Object[] objectArray) throws SQLException {
        Datum[] datumArray = this.toArray(objectArray);
        return this.toBytes(datumArray);
    }

    public byte[] toBytes(Datum[] datumArray) throws SQLException {
        STRUCT sTRUCT = new STRUCT(this, (Connection)this.m_conn, null);
        sTRUCT.setDatumArray(datumArray);
        return this.m_oracleTypeADT.linearize(sTRUCT);
    }

    public Datum[] toArray(Object[] objectArray) throws SQLException {
        if (objectArray == null) {
            return null;
        }
        OracleType[] oracleTypeArray = this.m_oracleTypeADT.types;
        int n = oracleTypeArray.length;
        if (objectArray.length != n) {
            DBError.check_error(49, null);
        }
        Datum[] datumArray = new Datum[n];
        int n2 = 0;
        while (n2 < n) {
            datumArray[n2] = oracleTypeArray[n2].toDatum(objectArray[n2], this.m_conn);
            ++n2;
        }
        return datumArray;
    }

    public Datum[] toArray(byte[] byArray) throws SQLException {
        if (byArray == null) {
            return null;
        }
        STRUCT sTRUCT = (STRUCT)this.m_oracleTypeADT.unlinearize(byArray);
        return sTRUCT.m_datumArray;
    }

    public String getName() throws SQLException {
        return this.m_name;
    }

    public SQLName getSQLName() throws SQLException {
        return this.m_sqlName;
    }

    public String getSchemaName() throws SQLException {
        return this.m_sqlName.getSchema();
    }

    public String getTypeName() throws SQLException {
        return this.m_sqlName.getSimpleName();
    }

    public int getLength() throws SQLException {
        return this.m_oracleTypeADT.types.length;
    }

    public OracleTypeADT getOracleTypeADT() {
        return this.m_oracleTypeADT;
    }

    public OracleConnection getConnection() {
        return this.m_conn;
    }

    private OracleType[] getFieldTypes() throws SQLException {
        return this.m_oracleTypeADT.types;
    }

    public SQLInput toJdbc2SQLInput(byte[] byArray, int n, int n2, Dictionary dictionary) throws SQLException {
        Datum[] datumArray = this.toArray(byArray);
        return new OracleJdbc2SQLInput(datumArray, dictionary, this.m_conn);
    }

    public SQLInput toJdbc2SQLInput(Datum[] datumArray, int n, int n2, Dictionary dictionary) throws SQLException {
        return new OracleJdbc2SQLInput(datumArray, dictionary, this.m_conn);
    }

    public SQLOutput toJdbc2SQLOutput() throws SQLException {
        return new OracleSQLOutput(this, this.m_conn);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return new StructMetaData(this);
    }

    public Class getClass(Dictionary dictionary) throws SQLException {
        String string = this.getName();
        Class clazz = (Class)dictionary.get(string);
        String string2 = this.getSchemaName();
        String string3 = this.getTypeName();
        if (clazz == null && this.m_conn.getUserName().equals(string2)) {
            clazz = (Class)dictionary.get(string3);
        }
        if (clazz == null && this.m_conn.getUserName().equals(string2)) {
            clazz = (Class)dictionary.get("\"" + string3 + "\"");
        }
        if (clazz == null) {
            clazz = (Class)dictionary.get("\"" + string2 + "\"" + "." + "\"" + string3 + "\"");
        }
        if (clazz == null) {
            clazz = (Class)dictionary.get("\"" + string2 + "\"" + "." + string3);
        }
        if (clazz == null) {
            clazz = (Class)dictionary.get(String.valueOf(string2) + "." + "\"" + string3 + "\"");
        }
        return clazz;
    }
}

