/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Dictionary;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc2.SQLData;
import oracle.jdbc2.SQLOutput;
import oracle.jdbc2.Struct;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.Datum;
import oracle.sql.OracleSQLOutput;
import oracle.sql.StructDescriptor;

public class STRUCT
extends Datum
implements Struct {
    StructDescriptor m_descriptor;
    OracleConnection m_conn;
    Datum[] m_datumArray;
    static /* synthetic */ Class class$oracle$sql$STRUCT;
    static /* synthetic */ Class class$oracle$jdbc2$Struct;

    public STRUCT(StructDescriptor structDescriptor, Connection connection, Object[] objectArray) throws SQLException {
        if (structDescriptor != null) {
            this.m_descriptor = structDescriptor;
        } else {
            DBError.check_error(61, "STRUCT");
        }
        if (connection != null) {
            this.m_conn = (OracleConnection)connection;
        } else {
            DBError.check_error(8, "Connection is null");
        }
        this.m_datumArray = objectArray != null ? this.m_descriptor.toArray(objectArray) : new Datum[0];
        this.setShareBytes(this.m_descriptor.toBytes(this.m_datumArray));
    }

    public STRUCT(StructDescriptor structDescriptor, Connection connection, byte[] byArray) throws SQLException {
        super(byArray);
        if (connection != null) {
            this.m_conn = (OracleConnection)connection;
        } else {
            DBError.check_error(8, "Connection is null");
        }
        this.m_descriptor = structDescriptor;
        this.m_datumArray = null;
    }

    public String getSQLTypeName() throws SQLException {
        return this.m_descriptor.getName();
    }

    public Object[] getAttributes() throws SQLException {
        return this.getAttributes(this.getMap());
    }

    public Object[] getAttributes(Dictionary dictionary) throws SQLException {
        Object[] objectArray = null;
        if (this.getOracleAttributes() != null) {
            objectArray = new Object[this.m_datumArray.length];
            int n = 0;
            while (n < this.m_datumArray.length) {
                objectArray[n] = this.m_datumArray[n] != null ? (this.m_datumArray[n] instanceof STRUCT ? ((STRUCT)this.m_datumArray[n]).toJdbc(dictionary) : this.m_datumArray[n].toJdbc()) : null;
                ++n;
            }
        }
        return objectArray;
    }

    public StructDescriptor getDescriptor() throws SQLException {
        return this.m_descriptor;
    }

    public void setDescriptor(StructDescriptor structDescriptor) {
        this.m_descriptor = structDescriptor;
    }

    public Datum[] getOracleAttributes() throws SQLException {
        if (this.m_datumArray == null && this.shareBytes() != null) {
            this.m_datumArray = this.m_descriptor.toArray(this.shareBytes());
        }
        return (Datum[])this.m_datumArray.clone();
    }

    public Dictionary getMap() {
        return this.getConnection().getTypeMap();
    }

    public OracleConnection getConnection() {
        return this.m_conn;
    }

    public byte[] toBytes() throws SQLException {
        if (this.shareBytes() == null && this.m_datumArray != null) {
            this.setShareBytes(this.m_descriptor.toBytes(this.m_datumArray));
        }
        return this.getBytes();
    }

    public void setDatumArray(Datum[] datumArray) {
        this.m_datumArray = datumArray == null ? new Datum[]{} : datumArray;
        this.setShareBytes(null);
    }

    public static STRUCT toSTRUCT(Object object, OracleConnection oracleConnection) throws SQLException {
        if (object == null) {
            return null;
        }
        STRUCT sTRUCT = null;
        if (object instanceof STRUCT) {
            sTRUCT = (STRUCT)object;
        } else if (object instanceof CustomDatum) {
            sTRUCT = (STRUCT)((CustomDatum)object).toDatum(oracleConnection);
        } else if (object instanceof SQLData) {
            SQLData sQLData = (SQLData)object;
            StructDescriptor structDescriptor = StructDescriptor.createDescriptor(sQLData.getSQLTypeName(), oracleConnection);
            SQLOutput sQLOutput = structDescriptor.toJdbc2SQLOutput();
            sQLData.writeSQL(sQLOutput);
            sTRUCT = ((OracleSQLOutput)sQLOutput).getSTRUCT();
        } else {
            DBError.check_error(59, object);
        }
        return sTRUCT;
    }

    public Object toJdbc() throws SQLException {
        Dictionary dictionary = this.getMap();
        return this.toJdbc(dictionary);
    }

    public Object toJdbc(Dictionary dictionary) throws SQLException {
        Object object = this;
        if (dictionary != null) {
            Class clazz = this.getClass(dictionary);
            object = this.toClass(clazz, dictionary);
        }
        return object;
    }

    public Object toClass(Class clazz) throws SQLException {
        return this.toClass(clazz, this.getMap());
    }

    public Object toClass(Class clazz, Dictionary dictionary) throws SQLException {
        Object object;
        block9: {
            object = null;
            try {
                if (clazz == (class$oracle$sql$STRUCT != null ? class$oracle$sql$STRUCT : (class$oracle$sql$STRUCT = STRUCT.class$("oracle.sql.STRUCT"))) || clazz == (class$oracle$jdbc2$Struct != null ? class$oracle$jdbc2$Struct : (class$oracle$jdbc2$Struct = STRUCT.class$("oracle.jdbc2.Struct")))) {
                    object = this;
                    break block9;
                }
                if (clazz != null) {
                    Object t = clazz.newInstance();
                    if (t instanceof SQLData) {
                        ((SQLData)t).readSQL(this.m_descriptor.toJdbc2SQLInput(this.toBytes(), 0, (int)this.getLength(), dictionary), this.m_descriptor.getName());
                        object = t;
                    } else if (t instanceof CustomDatumFactory) {
                        CustomDatumFactory customDatumFactory = (CustomDatumFactory)t;
                        object = customDatumFactory.create(this, 2002);
                    }
                    break block9;
                }
                return this;
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        if (object == null) {
            DBError.check_error(49, this.m_descriptor.getName());
        }
        return object;
    }

    public boolean isConvertibleTo(Class clazz) {
        return false;
    }

    public Object makeJdbcArray(int n) {
        return new Object[n];
    }

    public Class getClass(Dictionary dictionary) throws SQLException {
        return this.m_descriptor.getClass(dictionary);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

