/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Dictionary;
import java.util.Hashtable;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc2.SQLData;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class SQLUtil {
    private static final int CLASS_NOT_FOUND = -1;
    private static final int CLASS_STRING = 0;
    private static final int CLASS_BOOLEAN = 1;
    private static final int CLASS_INTEGER = 2;
    private static final int CLASS_LONG = 3;
    private static final int CLASS_FLOAT = 4;
    private static final int CLASS_DOUBLE = 5;
    private static final int CLASS_BIGDECIMAL = 6;
    private static final int CLASS_DATE = 7;
    private static final int CLASS_TIME = 8;
    private static final int CLASS_TIMESTAMP = 9;
    private static final int TOTAL_CLASSES = 10;
    private static Hashtable s_classTbl = new Hashtable(10);

    public static Object SQLToJava(OracleConnection oracleConnection, byte[] byArray, int n, String string, Class clazz, Dictionary dictionary) throws SQLException {
        Datum datum = SQLUtil.makeDatum(oracleConnection, byArray, n, string);
        return SQLUtil.SQLToJava(oracleConnection, datum, clazz, dictionary);
    }

    public static CustomDatum SQLToJava(OracleConnection oracleConnection, byte[] byArray, int n, String string, CustomDatumFactory customDatumFactory) throws SQLException {
        Datum datum = SQLUtil.makeDatum(oracleConnection, byArray, n, string);
        return customDatumFactory.create(datum, n);
    }

    public static Object SQLToJava(OracleConnection oracleConnection, Datum datum, Class clazz, Dictionary dictionary) throws SQLException {
        Object object = null;
        if (datum instanceof STRUCT) {
            object = clazz == null ? (dictionary != null ? ((STRUCT)datum).toJdbc(dictionary) : datum.toJdbc()) : (dictionary != null ? ((STRUCT)datum).toClass(clazz, dictionary) : ((STRUCT)datum).toClass(clazz));
        } else if (clazz == null) {
            object = datum.toJdbc();
        } else {
            int n = SQLUtil.classNumber(clazz);
            switch (n) {
                case 0: {
                    object = datum.stringValue();
                    break;
                }
                case 1: {
                    object = new Boolean(datum.longValue() != 0L);
                    break;
                }
                case 2: {
                    object = new Integer((int)datum.longValue());
                    break;
                }
                case 3: {
                    object = new Long(datum.longValue());
                    break;
                }
                case 4: {
                    object = new Float(datum.bigDecimalValue().floatValue());
                    break;
                }
                case 5: {
                    object = new Double(datum.bigDecimalValue().doubleValue());
                    break;
                }
                case 6: {
                    object = datum.bigDecimalValue();
                    break;
                }
                case 7: {
                    object = datum.dateValue();
                    break;
                }
                case 8: {
                    object = datum.timeValue();
                    break;
                }
                case 9: {
                    object = datum.timestampValue();
                    break;
                }
                default: {
                    object = datum.toJdbc();
                    if (object.getClass() == clazz || clazz.isInterface() && SQLUtil.implementsInterface(object.getClass(), clazz)) break;
                    DBError.check_error(59, "invalid data conversion");
                }
            }
        }
        return object;
    }

    public static byte[] JavaToSQL(OracleConnection oracleConnection, Object object, int n, String string) throws SQLException {
        if (object == null) {
            return null;
        }
        Datum datum = null;
        if (object instanceof Datum) {
            datum = (Datum)object;
        } else if (object instanceof CustomDatum) {
            datum = ((CustomDatum)object).toDatum(oracleConnection);
        } else if (object instanceof SQLData) {
            datum = STRUCT.toSTRUCT(object, oracleConnection);
        }
        if (datum != null) {
            if (!SQLUtil.checkDatumType(datum, n, string)) {
                datum = null;
            }
        } else {
            datum = SQLUtil.makeDatum(oracleConnection, object, n, string);
        }
        if (datum != null) {
            return datum.shareBytes();
        }
        DBError.check_error(1, "attempt to convert a Datum to incompatible SQL type");
        return null;
    }

    public static Datum makeDatum(OracleConnection oracleConnection, byte[] byArray, int n, String string) throws SQLException {
        Datum datum = null;
        switch (n) {
            case 1: 
            case 8: 
            case 96: 
            case 999: {
                short s = oracleConnection.getDbCsId();
                datum = new CHAR(byArray, CharacterSet.factory.make(s));
                break;
            }
            case 2: 
            case 6: {
                datum = new NUMBER(byArray);
                break;
            }
            case 23: 
            case 24: {
                datum = new RAW(byArray);
                break;
            }
            case 104: {
                datum = new ROWID(byArray);
                break;
            }
            case 102: {
                DBError.check_error(1, "need resolution: do we want to handle ResultSet?");
                break;
            }
            case 12: {
                datum = new DATE(byArray);
                break;
            }
            case 113: {
                datum = new BLOB(oracleConnection, byArray);
                break;
            }
            case 112: {
                datum = new CLOB(oracleConnection, byArray);
                break;
            }
            case 114: {
                datum = new BFILE(oracleConnection, byArray);
                break;
            }
            case 109: {
                Object object = SQLUtil.getTypeDescriptor(string, oracleConnection);
                if (object instanceof StructDescriptor) {
                    datum = new STRUCT((StructDescriptor)object, (Connection)oracleConnection, byArray);
                    break;
                }
                datum = new ARRAY((ArrayDescriptor)object, (Connection)oracleConnection, byArray);
                break;
            }
            case 111: {
                Object object = SQLUtil.getTypeDescriptor(string, oracleConnection);
                if (object instanceof StructDescriptor) {
                    datum = new REF((StructDescriptor)object, oracleConnection, byArray);
                    break;
                }
                DBError.check_error(1, "program error: REF points to a non-STRUCT");
                break;
            }
            default: {
                DBError.check_error(1, "program error: invalid SQL type code");
            }
        }
        return datum;
    }

    public static Datum makeDatum(OracleConnection oracleConnection, Object object, int n, String string) throws SQLException {
        Datum datum = null;
        switch (n) {
            case 1: 
            case 8: 
            case 96: 
            case 999: {
                short s = oracleConnection.getDbCsId();
                datum = new CHAR(object, CharacterSet.factory.make(s));
                break;
            }
            case 2: 
            case 6: {
                datum = new NUMBER(object);
                break;
            }
            case 23: 
            case 24: {
                datum = new RAW(object);
                break;
            }
            case 104: {
                datum = new ROWID((byte[])object);
                break;
            }
            case 102: {
                DBError.check_error(1, "need resolution: do we want to handle ResultSet");
                break;
            }
            case 12: {
                datum = new DATE(object);
                break;
            }
            case 113: {
                if (!(object instanceof BLOB)) break;
                datum = (Datum)object;
                break;
            }
            case 112: {
                if (!(object instanceof CLOB)) break;
                datum = (Datum)object;
                break;
            }
            case 114: {
                if (!(object instanceof BFILE)) break;
                datum = (Datum)object;
                break;
            }
            case 109: {
                if (!(object instanceof STRUCT) && !(object instanceof ARRAY)) break;
                datum = (Datum)object;
                break;
            }
            case 111: {
                if (!(object instanceof REF)) break;
                datum = (Datum)object;
            }
        }
        if (datum == null) {
            DBError.check_error(1, "Unable to construct a Datum from the specified input");
        }
        return datum;
    }

    private static int classNumber(Class clazz) {
        int n = -1;
        Integer n2 = (Integer)s_classTbl.get(clazz);
        if (n2 != null) {
            n = n2;
        }
        return n;
    }

    public static Object getTypeDescriptor(String string, OracleConnection oracleConnection) throws SQLException {
        Object object = null;
        SQLName sQLName = new SQLName(string, oracleConnection);
        String string2 = sQLName.getName();
        object = oracleConnection.getDescriptor(string2);
        if (object != null) {
            return object;
        }
        OracleTypeADT oracleTypeADT = new OracleTypeADT(string2, oracleConnection);
        oracleConnection.db_access.getOracleTypeADT(oracleTypeADT);
        oracleTypeADT.init(oracleConnection);
        OracleTypeADT oracleTypeADT2 = oracleTypeADT.cleanup();
        object = oracleTypeADT2 instanceof OracleTypeCOLLECTION ? new ArrayDescriptor(sQLName, (OracleTypeCOLLECTION)oracleTypeADT2, oracleConnection) : new StructDescriptor(sQLName, oracleTypeADT2, oracleConnection);
        oracleConnection.putDescriptor(string2, object);
        return object;
    }

    public static boolean checkDatumType(Datum datum, int n, String string) throws SQLException {
        switch (n) {
            case 1: 
            case 8: 
            case 96: 
            case 999: {
                return datum instanceof CHAR;
            }
            case 2: 
            case 6: {
                return datum instanceof NUMBER;
            }
            case 23: 
            case 24: {
                return datum instanceof RAW;
            }
            case 104: {
                return datum instanceof ROWID;
            }
            case 12: {
                return datum instanceof DATE;
            }
            case 113: {
                return datum instanceof BLOB;
            }
            case 112: {
                return datum instanceof CLOB;
            }
            case 114: {
                return datum instanceof BFILE;
            }
            case 111: {
                return datum instanceof REF && ((REF)datum).getBaseTypeName().equals(string);
            }
            case 109: {
                if (datum instanceof STRUCT) {
                    return ((STRUCT)datum).getSQLTypeName().equals(string);
                }
                if (datum instanceof ARRAY) {
                    return ((ARRAY)datum).getSQLTypeName().equals(string);
                }
                return false;
            }
        }
        return false;
    }

    public static boolean implementsInterface(Class clazz, Class clazz2) {
        if (clazz == null) {
            return false;
        }
        if (clazz == clazz2) {
            return true;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        while (n < classArray.length) {
            if (SQLUtil.implementsInterface(classArray[n], clazz2)) {
                return true;
            }
            ++n;
        }
        return SQLUtil.implementsInterface(clazz.getSuperclass(), clazz2);
    }

    public static Datum makeOracleDatum(OracleConnection oracleConnection, Object object, int n, String string) throws SQLException {
        return SQLUtil.makeDatum(oracleConnection, object, SQLUtil.get_internal_type(n), string);
    }

    public static int get_internal_type(int n) throws SQLException {
        switch (n) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return 6;
            }
            case 999: {
                return 999;
            }
            case 1: {
                return 96;
            }
            case 12: {
                return 1;
            }
            case -1: {
                return 8;
            }
            case 91: 
            case 92: 
            case 93: {
                return 12;
            }
            case -3: 
            case -2: {
                return 23;
            }
            case -4: {
                return 24;
            }
            case -8: {
                return 104;
            }
            case 2004: {
                return 113;
            }
            case 2005: {
                return 112;
            }
            case -13: {
                return 114;
            }
            case -10: {
                return 102;
            }
            case 2002: 
            case 2003: {
                return 109;
            }
            case 2006: {
                return 111;
            }
        }
        DBError.check_error(4, "get_internal_type");
        return 0;
    }

    public static void main(String[] stringArray) throws SQLException {
        Connection connection;
        block20: {
            System.out.println("\n< SQLUtil Test >");
            connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            int n = 0;
            int n2 = 0;
            System.out.println("\nArguments:");
            n = 0;
            while (n < stringArray.length) {
                System.out.println("  arg[" + n + "]: " + stringArray[n]);
                ++n;
            }
            try {
                System.out.println("\nconnecting to database ...");
                DriverManager.registerDriver(new OracleDriver());
                connection = DriverManager.getConnection(stringArray[0], stringArray[1], stringArray[2]);
                statement = connection.createStatement();
            }
            catch (Exception exception) {}
            try {
                statement.execute("drop table sutil_tbl");
            }
            catch (Exception exception) {}
            try {
                statement.execute("drop type my_obj1");
            }
            catch (Exception exception) {}
            try {
                try {
                    Datum datum;
                    System.out.println("\nConversion Tests:");
                    CHAR cHAR = new CHAR(new Integer(123), CharacterSet.factory.make(871));
                    Object object = null;
                    byte[] byArray = null;
                    object = SQLUtil.SQLToJava((OracleConnection)connection, cHAR, Class.forName("java.lang.Integer"), null);
                    byArray = SQLUtil.JavaToSQL((OracleConnection)connection, object, 96, null);
                    object = SQLUtil.SQLToJava((OracleConnection)connection, cHAR, null, null);
                    byArray = SQLUtil.JavaToSQL((OracleConnection)connection, object, 96, null);
                    object = SQLUtil.SQLToJava((OracleConnection)connection, cHAR, Class.forName("java.math.BigDecimal"), null);
                    System.out.println("  123 is converted back to " + (BigDecimal)object);
                    statement.execute("create type my_obj1 as object (a1 number, a2 varchar2(20))");
                    statement.execute("create table sutil_tbl (col1 varchar2(20), col2 number, col3 my_obj1)");
                    statement.execute("insert into sutil_tbl values ('Str1', 556, my_obj1(123, 'Str2'))");
                    resultSet = statement.executeQuery("select * from sutil_tbl");
                    n = 1;
                    while (resultSet.next()) {
                        resultSet.getString(1);
                        resultSet.getInt(2);
                        datum = (Datum)resultSet.getObject(3);
                        System.out.println("  STRUCT " + datum.shareBytes());
                        object = SQLUtil.SQLToJava((OracleConnection)connection, datum.shareBytes(), 109, resultSet.getMetaData().getColumnTypeName(3), Class.forName("oracle.sql.STRUCT"), null);
                        Object[] objectArray = ((STRUCT)object).getAttributes();
                        System.out.println("  1st object attribute: " + (BigDecimal)objectArray[0]);
                        System.out.println("  2nd object attribute: " + (String)objectArray[1]);
                        byte[] byArray2 = ((STRUCT)object).getBytes();
                        n2 = 0;
                        while (n2 < byArray2.length) {
                            System.out.print(" " + byArray2[n2]);
                            ++n2;
                        }
                        System.out.println(" ");
                        System.out.println("  - is converted to: " + ((Datum)object).shareBytes());
                        byArray = SQLUtil.JavaToSQL((OracleConnection)connection, ((Datum)object).shareBytes(), 23, null);
                        System.out.println("  - and then to:     " + byArray);
                        object = SQLUtil.SQLToJava((OracleConnection)connection, byArray, 109, resultSet.getMetaData().getColumnTypeName(3), null, null);
                        System.out.println("  - is converted to: " + ((Datum)object).shareBytes());
                        byArray = SQLUtil.JavaToSQL((OracleConnection)connection, object, 109, resultSet.getMetaData().getColumnTypeName(3));
                        objectArray = ((STRUCT)object).getAttributes();
                        System.out.println("  1st object attribute: " + (BigDecimal)objectArray[0]);
                        System.out.println("  2nd object attribute: " + (String)objectArray[1]);
                        byArray2 = ((STRUCT)object).getBytes();
                        n2 = 0;
                        while (n2 < byArray2.length) {
                            System.out.print(" " + byArray2[n2]);
                            ++n2;
                        }
                        System.out.println(" ");
                        System.out.println("  - and then to:     " + byArray);
                        object = SQLUtil.SQLToJava((OracleConnection)connection, byArray, 109, resultSet.getMetaData().getColumnTypeName(3), null, null);
                        System.out.println("  - and finally to:  " + ((Datum)object).shareBytes());
                        ++n;
                    }
                    datum = new BLOB((OracleConnection)connection);
                    object = SQLUtil.SQLToJava((OracleConnection)connection, datum, Class.forName("oracle.jdbc2.Blob"), null);
                    if (object == datum) {
                        System.out.println("  BLOB to oracle.jdbc2.Blob conversion okay");
                    } else {
                        System.out.println("  BLOB to oracle.jdbc2.Blob conversion failed");
                    }
                    object = SQLUtil.SQLToJava((OracleConnection)connection, datum, Class.forName("oracle.sql.BLOB"), null);
                    if (object == datum) {
                        System.out.println("  BLOB to BLOB conversion okay");
                    } else {
                        System.out.println("  BLOB to BLOB conversion failed");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                Object var7_13 = null;
                System.out.println("");
                if (statement == null) break block20;
                System.out.println("closing statement ...");
            }
            catch (Throwable throwable) {
                block21: {
                    Object var7_14 = null;
                    System.out.println("");
                    if (statement != null) {
                        System.out.println("closing statement ...");
                        statement.close();
                    }
                    if (connection == null) break block21;
                    System.out.println("closing connection ...");
                    connection.close();
                }
                throw throwable;
            }
            statement.close();
        }
        if (connection != null) {
            System.out.println("closing connection ...");
            connection.close();
        }
    }

    static {
        try {
            s_classTbl.put(Class.forName("java.lang.String"), new Integer(0));
            s_classTbl.put(Class.forName("java.lang.Boolean"), new Integer(1));
            s_classTbl.put(Class.forName("java.lang.Integer"), new Integer(2));
            s_classTbl.put(Class.forName("java.lang.Long"), new Integer(3));
            s_classTbl.put(Class.forName("java.lang.Float"), new Integer(4));
            s_classTbl.put(Class.forName("java.lang.Double"), new Integer(5));
            s_classTbl.put(Class.forName("java.math.BigDecimal"), new Integer(6));
            s_classTbl.put(Class.forName("java.sql.Date"), new Integer(7));
            s_classTbl.put(Class.forName("java.sql.Time"), new Integer(8));
            s_classTbl.put(Class.forName("java.sql.Timestamp"), new Integer(9));
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("program error: unexpected ClassNotFoundException");
        }
    }
}

