/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Dictionary;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc2.Ref;
import oracle.sql.Datum;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class REF
extends Datum
implements Ref {
    static final boolean DEBUG = false;
    StructDescriptor m_descriptor;
    OracleConnection m_conn;

    public String getBaseTypeName() throws SQLException {
        if (this.m_descriptor != null) {
            return this.m_descriptor.getName();
        }
        return null;
    }

    public REF(StructDescriptor structDescriptor, Connection connection, byte[] byArray) throws SQLException {
        super(byArray);
        if (connection != null) {
            this.m_conn = (OracleConnection)connection;
        } else {
            DBError.check_error(8, "Connection is null");
        }
        this.m_descriptor = structDescriptor;
        this.m_conn = (OracleConnection)connection;
    }

    public Object getValue(Dictionary dictionary) throws SQLException {
        STRUCT sTRUCT = this.getSTRUCT();
        if (sTRUCT != null) {
            return sTRUCT.toJdbc(dictionary);
        }
        return null;
    }

    public Object getValue() throws SQLException {
        STRUCT sTRUCT = this.getSTRUCT();
        if (sTRUCT != null) {
            return sTRUCT.toJdbc();
        }
        return null;
    }

    public STRUCT getSTRUCT() throws SQLException {
        if (this.m_descriptor == null) {
            DBError.check_error(52, "no descriptor");
        }
        if (this.shareBytes() == null) {
            return null;
        }
        OracleConnection oracleConnection = this.m_descriptor.getConnection();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        STRUCT sTRUCT = null;
        preparedStatement = oracleConnection.prepareStatement("select deref(?) from dual");
        ((OraclePreparedStatement)preparedStatement).setRowPrefetch(1);
        ((OraclePreparedStatement)preparedStatement).setREF(1, this);
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        sTRUCT = ((OracleResultSet)resultSet).getSTRUCT(1);
        resultSet.close();
        resultSet = null;
        preparedStatement.close();
        preparedStatement = null;
        return sTRUCT;
    }

    public void setValue(Object object) throws SQLException {
        CallableStatement callableStatement;
        block6: {
            OracleConnection oracleConnection;
            STRUCT sTRUCT;
            if (this.m_descriptor == null) {
                DBError.check_error(52, "no descriptor");
            }
            if ((sTRUCT = STRUCT.toSTRUCT(object, oracleConnection = this.m_descriptor.getConnection())).getDescriptor() == null) {
                sTRUCT.setDescriptor(this.m_descriptor);
            }
            byte[] byArray = sTRUCT.toBytes();
            byte[] byArray2 = this.m_descriptor.getOracleTypeADT().getTOID();
            callableStatement = null;
            try {
                callableStatement = oracleConnection.prepareCall(" begin ? := dbms_pickler.update_through_ref (?, ?, ?, ?); end; ");
                callableStatement.registerOutParameter(1, 2);
                callableStatement.setBytes(2, this.getBytes());
                callableStatement.setInt(3, 0);
                callableStatement.setBytes(4, byArray2);
                callableStatement.setBytes(5, byArray);
                callableStatement.execute();
                int n = 0;
                n = callableStatement.getInt(1);
                if (n == 0) break block6;
                DBError.throwSqlException(77, "ORA-" + n);
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (callableStatement != null) {
                    callableStatement.close();
                }
                callableStatement = null;
                throw throwable;
            }
        }
        Object var8_8 = null;
        if (callableStatement != null) {
            callableStatement.close();
        }
        callableStatement = null;
    }

    public StructDescriptor getDescriptor() throws SQLException {
        return this.m_descriptor;
    }

    public OracleConnection getConnection() {
        if (this.m_descriptor != null) {
            return this.m_descriptor.getConnection();
        }
        return null;
    }

    public Object toJdbc() throws SQLException {
        return this;
    }

    public boolean isConvertibleTo(Class clazz) {
        return false;
    }

    public Object makeJdbcArray(int n) {
        return new REF[n];
    }
}

