/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import oracle.sql.Datum;
import oracle.sql.LdxLib;
import oracle.sql.LdxLibServer;
import oracle.sql.LdxLibThin;
import oracle.sql.NUMBER;

public class DATE
extends Datum {
    public static final int BDA = 1;
    public static final int BDAL = 2;
    public static final int BMO = 4;
    public static final int BMOL = 8;
    public static final int BYR = 16;
    public static final int BYRL = 32;
    public static final int BHR = 64;
    public static final int BHRL = 128;
    public static final int BMN = 256;
    public static final int BMNL = 512;
    public static final int BSC = 1024;
    public static final int BSCL = 2048;
    public static final int MSD = 4096;
    public static final int YR0 = 8192;
    public static final int BDT = 32768;
    public static final int HRZER0 = 65536;
    public static final int MIZERO = 131072;
    public static final int SEZERO = 262144;
    private static final byte LDXTCE = 0;
    private static final byte LDXTYE = 1;
    private static final byte LDXTMO = 2;
    private static final byte LDXTDA = 3;
    private static final byte LDXTHO = 4;
    private static final byte LDXTMI = 5;
    private static final byte LDXTSE = 6;
    private static LdxLib _sldxlib;

    public DATE() {
        super(DATE._initDate());
    }

    public DATE(Object object) throws SQLException {
        if (object instanceof Date) {
            this.setShareBytes(DATE.toBytes((Date)object));
        } else if (object instanceof Time) {
            this.setShareBytes(DATE.toBytes((Time)object));
        } else if (object instanceof Timestamp) {
            this.setShareBytes(DATE.toBytes((Timestamp)object));
        } else if (object instanceof String) {
            this.setShareBytes(DATE.toBytes((String)object));
        } else {
            throw new SQLException("Initialization failed");
        }
    }

    public DATE(Object object, Calendar calendar) throws SQLException {
        if (object instanceof Date) {
            this.setShareBytes(DATE.toBytes((Date)object, calendar));
        } else if (object instanceof Time) {
            this.setShareBytes(DATE.toBytes((Time)object, calendar));
        } else if (object instanceof Timestamp) {
            this.setShareBytes(DATE.toBytes((Timestamp)object, calendar));
        } else if (object instanceof String) {
            this.setShareBytes(DATE.toBytes((String)object));
        } else {
            throw new SQLException("Initialization failed");
        }
    }

    public DATE(String string) {
        super(DATE.toBytes(string));
    }

    public DATE(Date date) {
        super(DATE.toBytes(date));
    }

    public DATE(Date date, Calendar calendar) {
        super(DATE.toBytes(date, calendar));
    }

    public DATE(Time time) {
        super(DATE.toBytes(time));
    }

    public DATE(Time time, Calendar calendar) {
        super(DATE.toBytes(time, calendar));
    }

    public DATE(Timestamp timestamp) {
        super(DATE.toBytes(timestamp));
    }

    public DATE(Timestamp timestamp, Calendar calendar) {
        super(DATE.toBytes(timestamp, calendar));
    }

    public DATE(byte[] byArray) {
        super(byArray);
    }

    private static LdxLib _getLdxLib() {
        if (_sldxlib == null) {
            _sldxlib = System.getProperty("oracle.server.version") != null ? new LdxLibServer() : new LdxLibThin();
        }
        return _sldxlib;
    }

    private static byte[] _initDate() {
        byte[] byArray = new byte[]{119, -86, 1, 1, 1, 1, 1};
        return byArray;
    }

    private static void _printBytes(byte[] byArray) {
        System.out.println(DATE.toString(byArray));
    }

    public DATE addJulianDays(int n, int n2) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxads(this.shareBytes(), n, n2));
    }

    public DATE addMonths(int n) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxadm(this.shareBytes(), n));
    }

    public static int checkValidity(byte[] byArray) throws SQLException {
        return DATE._getLdxLib().ldxchk(byArray);
    }

    public int compareTo(DATE dATE) {
        return Datum.compareBytes(this.shareBytes(), dATE.shareBytes());
    }

    public Date dateValue() {
        return DATE.toDate(this.getBytes());
    }

    public Date dateValue(Calendar calendar) {
        return DATE.toDate(this.getBytes(), calendar);
    }

    public void diffInJulianDays(DATE dATE, int[] nArray, int[] nArray2) throws SQLException {
        DATE._getLdxLib().ldxsub(this.shareBytes(), dATE.shareBytes(), nArray, nArray2);
    }

    public NUMBER diffInMonths(DATE dATE) throws SQLException {
        return new NUMBER(DATE._getLdxLib().ldxsbm(this.shareBytes(), dATE.shareBytes()));
    }

    public static DATE fromJulianDays(int n, int n2) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxdfd(n, n2));
    }

    public static DATE fromText(String string, String string2, String string3) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxstd(string, string2, string3));
    }

    public static DATE getCurrentDate() throws SQLException {
        return new DATE(DATE._getLdxLib().ldxgdt());
    }

    public boolean isConvertibleTo(Class clazz) {
        return clazz.getName().compareTo("java.sql.Date") == 0 || clazz.getName().compareTo("java.sql.Time") == 0 || clazz.getName().compareTo("java.sql.Timestamp") == 0 || clazz.getName().compareTo("java.lang.String") == 0;
    }

    public DATE lastDayOfMonth() throws SQLException {
        return new DATE(DATE._getLdxLib().ldxldd(this.shareBytes()));
    }

    public Object makeJdbcArray(int n) {
        Timestamp[] timestampArray = new Timestamp[n];
        return timestampArray;
    }

    public static void numberToJulianDays(NUMBER nUMBER, int[] nArray, int[] nArray2) throws SQLException {
        DATE._getLdxLib().ldxftd(nUMBER.toBytes(), nArray, nArray2);
    }

    public DATE round(String string) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxrnd(this.shareBytes(), string));
    }

    public DATE setDayOfWeek(int n) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxnxd(this.shareBytes(), n));
    }

    public String stringValue() {
        return DATE.toString(this.getBytes());
    }

    public Time timeValue() {
        return DATE.toTime(this.getBytes());
    }

    public Time timeValue(Calendar calendar) {
        return DATE.toTime(this.getBytes(), calendar);
    }

    public Timestamp timestampValue() {
        return DATE.toTimestamp(this.getBytes());
    }

    public Timestamp timestampValue(Calendar calendar) {
        return DATE.toTimestamp(this.getBytes(), calendar);
    }

    public byte[] toBytes() {
        return this.getBytes();
    }

    public static byte[] toBytes(String string) {
        return DATE.toBytes(Timestamp.valueOf(string));
    }

    public static byte[] toBytes(Date date) {
        if (date == null) {
            return null;
        }
        byte[] byArray = new byte[7];
        int n = date.getYear() + 1900;
        byArray[0] = (byte)(n / 100 + 100);
        byArray[1] = (byte)(n % 100 + 100);
        byArray[2] = (byte)(date.getMonth() + 1);
        byArray[3] = (byte)date.getDate();
        byArray[4] = 1;
        byArray[5] = 1;
        byArray[6] = 1;
        return byArray;
    }

    public static byte[] toBytes(Date date, Calendar calendar) {
        return DATE.toBytes(date);
    }

    public static byte[] toBytes(Time time) {
        if (time == null) {
            return null;
        }
        byte[] byArray = new byte[]{119, 100, 1, 1, (byte)(time.getHours() + 1), (byte)(time.getMinutes() + 1), (byte)(time.getSeconds() + 1)};
        return byArray;
    }

    public static byte[] toBytes(Time time, Calendar calendar) {
        return DATE.toBytes(time);
    }

    public static byte[] toBytes(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        byte[] byArray = new byte[7];
        int n = timestamp.getYear() + 1900;
        byArray[0] = (byte)(n / 100 + 100);
        byArray[1] = (byte)(n % 100 + 100);
        byArray[2] = (byte)(timestamp.getMonth() + 1);
        byArray[3] = (byte)timestamp.getDate();
        byArray[4] = (byte)(timestamp.getHours() + 1);
        byArray[5] = (byte)(timestamp.getMinutes() + 1);
        byArray[6] = (byte)(timestamp.getSeconds() + 1);
        return byArray;
    }

    public static byte[] toBytes(Timestamp timestamp, Calendar calendar) {
        return DATE.toBytes(timestamp);
    }

    public static Date toDate(byte[] byArray) {
        int[] nArray = new int[7];
        int n = 0;
        while (n < 7) {
            nArray[n] = byArray[n] & 0xFF;
            ++n;
        }
        int n2 = (nArray[0] - 100) * 100 + (nArray[1] - 100) - 1900;
        return new Date(n2, nArray[2] - 1, nArray[3]);
    }

    public static Date toDate(byte[] byArray, Calendar calendar) {
        return DATE.toDate(byArray);
    }

    public Object toJdbc() {
        return this.timestampValue();
    }

    public void toJulianDays(int[] nArray, int[] nArray2) throws SQLException {
        DATE._getLdxLib().ldxdtd(this.shareBytes(), nArray, nArray2);
    }

    public NUMBER toNumber() throws SQLException {
        return new NUMBER(DATE._getLdxLib().ldxdyf(this.shareBytes()));
    }

    public static String toString(byte[] byArray) {
        int[] nArray = new int[7];
        int n = 0;
        while (n < 7) {
            nArray[n] = byArray[n] < 0 ? byArray[n] + 256 : byArray[n];
            ++n;
        }
        nArray[4] = nArray[4] - 1;
        nArray[5] = nArray[5] - 1;
        nArray[6] = nArray[6] - 1;
        int n2 = (nArray[0] - 100) * 100 + (nArray[1] - 100);
        return String.valueOf(nArray[2]) + "/" + nArray[3] + "/" + n2 + " " + nArray[4] + ":" + nArray[5] + ":" + nArray[6];
    }

    public String toText(String string, String string2) throws SQLException {
        return DATE._getLdxLib().ldxdts(this.shareBytes(), string, string2);
    }

    public static Time toTime(byte[] byArray) {
        int[] nArray = new int[7];
        int n = 0;
        while (n < 7) {
            nArray[n] = byArray[n] & 0xFF;
            ++n;
        }
        return new Time(nArray[4] - 1, nArray[5] - 1, nArray[6] - 1);
    }

    public static Time toTime(byte[] byArray, Calendar calendar) {
        return DATE.toTime(byArray);
    }

    public static Timestamp toTimestamp(byte[] byArray) {
        int[] nArray = new int[7];
        int n = 0;
        while (n < 7) {
            nArray[n] = byArray[n] & 0xFF;
            ++n;
        }
        int n2 = (nArray[0] - 100) * 100 + (nArray[1] - 100) - 1900;
        return new Timestamp(n2, nArray[2] - 1, nArray[3], nArray[4] - 1, nArray[5] - 1, nArray[6] - 1, 0);
    }

    public static Timestamp toTimestamp(byte[] byArray, Calendar calendar) {
        return DATE.toTimestamp(byArray);
    }

    public DATE truncate(String string) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxtrn(this.shareBytes(), string));
    }
}

