/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterSet12Byte;
import oracle.sql.CharacterSet1Byte;
import oracle.sql.CharacterSetJAEUC;
import oracle.sql.CharacterSetLCFixed;
import oracle.sql.CharacterSetSJIS;
import oracle.sql.CharacterSetZHTEUC;
import oracle.sql.converter.CharacterConverter;
import oracle.sql.converter.CharacterConverter12Byte;
import oracle.sql.converter.CharacterConverter1Byte;
import oracle.sql.converter.CharacterConverterJAEUC;
import oracle.sql.converter.CharacterConverterLCFixed;
import oracle.sql.converter.CharacterConverterSJIS;
import oracle.sql.converter.CharacterConverterZHTEUC;

abstract class CharacterSetWithConverter
extends CharacterSet {
    CharacterConverter m_converter;

    CharacterSetWithConverter(int n, CharacterConverter characterConverter) {
        super(n);
        this.m_converter = characterConverter;
    }

    static CharacterSet getInstance(int n) {
        CharacterConverter characterConverter = CharacterConverter.getInstance(n);
        if (characterConverter == null) {
            return null;
        }
        CharacterSetWithConverter characterSetWithConverter = null;
        characterSetWithConverter = characterConverter.getGroupId() == 1 ? new CharacterSet1Byte(n, (CharacterConverter1Byte)characterConverter) : null;
        if (characterSetWithConverter != null) {
            return characterSetWithConverter;
        }
        characterSetWithConverter = characterConverter.getGroupId() == 6 ? new CharacterSetSJIS(n, (CharacterConverterSJIS)characterConverter) : null;
        if (characterSetWithConverter != null) {
            return characterSetWithConverter;
        }
        characterSetWithConverter = characterConverter.getGroupId() == 2 ? new CharacterSet12Byte(n, (CharacterConverter12Byte)characterConverter) : null;
        if (characterSetWithConverter != null) {
            return characterSetWithConverter;
        }
        characterSetWithConverter = characterConverter.getGroupId() == 3 ? new CharacterSetJAEUC(n, (CharacterConverterJAEUC)characterConverter) : null;
        if (characterSetWithConverter != null) {
            return characterSetWithConverter;
        }
        characterSetWithConverter = characterConverter.getGroupId() == 7 ? new CharacterSetZHTEUC(n, (CharacterConverterZHTEUC)characterConverter) : null;
        if (characterSetWithConverter != null) {
            return characterSetWithConverter;
        }
        if (characterConverter.getGroupId() == 5) {
            return new CharacterSetLCFixed(n, (CharacterConverterLCFixed)characterConverter);
        }
        return null;
    }

    public boolean isLossyFrom(CharacterSet characterSet) {
        return characterSet.getOracleId() != this.getOracleId();
    }

    public boolean isConvertibleFrom(CharacterSet characterSet) {
        return characterSet.getOracleId() == this.getOracleId();
    }

    public String toStringWithReplacement(byte[] byArray, int n, int n2) {
        return this.m_converter.toUnicodeStringWithReplacement(byArray, n, n2);
    }

    public String toString(byte[] byArray, int n, int n2) throws SQLException {
        return this.m_converter.toUnicodeString(byArray, n, n2);
    }

    public byte[] convert(String string) throws SQLException {
        return this.m_converter.toOracleString(string);
    }

    public byte[] convertWithReplacement(String string) {
        return this.m_converter.toOracleStringWithReplacement(string);
    }

    public byte[] convert(CharacterSet characterSet, byte[] byArray, int n, int n2) throws SQLException {
        if (characterSet.getOracleId() == this.getOracleId()) {
            return CharacterSet.useOrCopy(byArray, n, n2);
        }
        return this.convert(characterSet.toString(byArray, n, n2));
    }
}

