/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterWalker;
import oracle.sql.RepConstants;

class CharacterSetUTF
extends CharacterSet
implements RepConstants {
    CharacterSetUTF(int n) {
        super(n);
        this.rep = 2;
    }

    public boolean isLossyFrom(CharacterSet characterSet) {
        boolean bl;
        boolean bl2 = bl = characterSet.rep == 1 || characterSet.rep == 2;
        return !bl;
    }

    public boolean isConvertibleFrom(CharacterSet characterSet) {
        boolean bl = characterSet.rep == 1 || characterSet.rep == 2;
        return bl;
    }

    public String toStringWithReplacement(byte[] byArray, int n, int n2) {
        char[] cArray;
        try {
            cArray = CharacterSet.UTFToJavaChar(byArray, n, n2);
        }
        catch (SQLException sQLException) {
            cArray = new char[]{'?', '?', '?'};
        }
        return new String(cArray);
    }

    public String toString(byte[] byArray, int n, int n2) throws SQLException {
        return this.toStringWithReplacement(byArray, n, n2);
    }

    public byte[] convert(String string) throws SQLException {
        return CharacterSet.stringToUTF(string);
    }

    public byte[] convertWithReplacement(String string) {
        return CharacterSet.stringToUTF(string);
    }

    public byte[] convert(CharacterSet characterSet, byte[] byArray, int n, int n2) throws SQLException {
        byte[] byArray2;
        if (characterSet.rep == 2) {
            byArray2 = CharacterSet.useOrCopy(byArray, n, n2);
        } else {
            String string = characterSet.toString(byArray, n, n2);
            byArray2 = CharacterSet.stringToUTF(string);
        }
        return byArray2;
    }

    int decode(CharacterWalker characterWalker) throws SQLException {
        char c;
        byte[] byArray = characterWalker.bytes;
        int n = characterWalker.next;
        int n2 = characterWalker.end;
        if (n >= n2) {
            DBError.check_error(37, "failUTFConversion");
        }
        char c2 = byArray[n++];
        int n3 = c2 & 0xF0;
        switch (n3 / 16) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                c = c2;
                break;
            }
            case 12: 
            case 13: {
                byte by;
                if (n >= n2) {
                    DBError.check_error(37, "failUTFConversion");
                }
                if (((by = byArray[n++]) & 0xC0) != 128) {
                    DBError.check_error(37, "failUTFConversion");
                }
                c = (char)((c2 & 0x1F) << 6 | by & 0x3F);
                break;
            }
            case 14: {
                if (n + 1 >= n2) {
                    DBError.check_error(37, "failUTFConversion");
                }
                byte by = byArray[n++];
                byte by2 = byArray[n++];
                if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                    DBError.check_error(37, "failUTFConversion");
                }
                c = (char)((c2 & 0xF) << 12 | (by & 0x3F) << 6 | by2 & 0x3F);
                break;
            }
            default: {
                DBError.check_error(37, "failUTFConversion");
                c = '\u0000';
            }
        }
        characterWalker.next = n;
        return c;
    }

    void encode(CharacterBuffer characterBuffer, int n) throws SQLException {
        if (n > 65535) {
            DBError.check_error(37, "failUTFConversion");
            return;
        }
        CharacterSet.need(characterBuffer, 3);
        char[] cArray = new char[]{(char)n};
        int n2 = CharacterSet.javaCharsToUTF(cArray, 0, 1, characterBuffer.bytes, characterBuffer.next);
        characterBuffer.next += n2;
    }
}

