/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.CharacterConverter;
import oracle.sql.converter.CharacterConverterJAEUC;

class CharacterSetJAEUC
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverterJAEUC";
    static final transient short MAX_7BIT = 127;
    static final transient short LEADINGCODE = 143;
    static Class m_charConvSuperclass;

    CharacterSetJAEUC(int n, CharacterConverterJAEUC characterConverterJAEUC) {
        super(n, characterConverterJAEUC);
    }

    static CharacterSetJAEUC getInstance(int n, CharacterConverter characterConverter) {
        if (characterConverter.getGroupId() == 3) {
            return new CharacterSetJAEUC(n, (CharacterConverterJAEUC)characterConverter);
        }
        return null;
    }

    int decode(CharacterWalker characterWalker) throws SQLException {
        int n = characterWalker.bytes[characterWalker.next] & 0xFF;
        ++characterWalker.next;
        if (n > 127) {
            if (n != 143) {
                if (characterWalker.bytes.length > characterWalker.next) {
                    n = n << 8 | characterWalker.bytes[characterWalker.next];
                    ++characterWalker.next;
                }
            } else {
                int n2 = 0;
                while (n2 < 2) {
                    if (characterWalker.bytes.length > characterWalker.next) {
                        n = n << 8 | characterWalker.bytes[characterWalker.next];
                        ++characterWalker.next;
                    }
                    ++n2;
                }
            }
        }
        return n;
    }

    void encode(CharacterBuffer characterBuffer, int n) throws SQLException {
        CharacterSet.need(characterBuffer, 1);
        characterBuffer.bytes[characterBuffer.next] = (byte)n;
        ++characterBuffer.next;
        while (((n >>= 8) & 0xFF) != 0) {
            CharacterSet.need(characterBuffer, 1);
            characterBuffer.bytes[characterBuffer.next] = (byte)n;
            ++characterBuffer.next;
        }
    }
}

