/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterWalker;
import oracle.sql.RepConstants;

class CharacterSetByte
extends CharacterSet
implements RepConstants {
    CharacterSetByte(int n) {
        super(n);
        this.rep = 1;
    }

    public boolean isLossyFrom(CharacterSet characterSet) {
        return characterSet.rep != 1;
    }

    public boolean isConvertibleFrom(CharacterSet characterSet) {
        return characterSet.rep <= 1024;
    }

    private String toString(byte[] byArray, int n, int n2, char c) throws SQLException {
        return new String(byArray, 0, n, n2);
    }

    public String toStringWithReplacement(byte[] byArray, int n, int n2) {
        try {
            return new String(byArray, 0, n, n2);
        }
        catch (SQLException sQLException) {
            throw new Error("CharacterSetByte.toString");
        }
    }

    public String toString(byte[] byArray, int n, int n2) throws SQLException {
        return new String(byArray, 0, n, n2);
    }

    public byte[] convert(String string) throws SQLException {
        int n = string.length();
        char[] cArray = new char[string.length()];
        string.getChars(0, n, cArray, 0);
        return CharacterSetByte.charsToBytes(cArray, (byte)0);
    }

    public byte[] convertWithReplacement(String string) {
        int n = string.length();
        char[] cArray = new char[string.length()];
        string.getChars(0, n, cArray, 0);
        try {
            return CharacterSetByte.charsToBytes(cArray, (byte)63);
        }
        catch (SQLException sQLException) {
            return new byte[0];
        }
    }

    public byte[] convert(CharacterSet characterSet, byte[] byArray, int n, int n2) throws SQLException {
        byte[] byArray2;
        if (characterSet.rep == 1) {
            byArray2 = CharacterSet.useOrCopy(byArray, n, n2);
        } else if (characterSet.rep == 2) {
            char[] cArray = CharacterSet.UTFToJavaChar(byArray, n, n2);
            byArray2 = CharacterSetByte.charsToBytes(cArray, (byte)0);
        } else {
            String string = characterSet.toString(byArray, n, n2);
            char[] cArray = string.toCharArray();
            byArray2 = CharacterSetByte.charsToBytes(cArray, (byte)0);
        }
        return byArray2;
    }

    int decode(CharacterWalker characterWalker) {
        int n = characterWalker.bytes[characterWalker.next] & 0xFF;
        ++characterWalker.next;
        return n;
    }

    void encode(CharacterBuffer characterBuffer, int n) throws SQLException {
        CharacterSet.need(characterBuffer, 1);
        if (n < 256) {
            characterBuffer.bytes[characterBuffer.next] = (byte)n;
            ++characterBuffer.next;
        }
    }

    static byte[] charsToBytes(char[] cArray, byte by) throws SQLException {
        byte[] byArray = new byte[cArray.length];
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] > '\u00ff') {
                byArray[n] = by;
                if (by == 0) {
                    CharacterSet characterSet = CharacterSet.factory.make(31);
                    DBError.check_error(55, characterSet);
                }
            } else {
                byArray[n] = (byte)cArray[n];
            }
            ++n;
        }
        return byArray;
    }
}

