/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.CharacterConverter;
import oracle.sql.converter.CharacterConverter12Byte;

class CharacterSet12Byte
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverter12Byte";
    static final int MAX_7BIT = 127;
    static Class m_charConvSuperclass;

    CharacterSet12Byte(int n, CharacterConverter12Byte characterConverter12Byte) {
        super(n, characterConverter12Byte);
    }

    static CharacterSet12Byte getInstance(int n, CharacterConverter characterConverter) {
        if (characterConverter.getGroupId() == 2) {
            return new CharacterSet12Byte(n, (CharacterConverter12Byte)characterConverter);
        }
        return null;
    }

    int decode(CharacterWalker characterWalker) throws SQLException {
        int n = characterWalker.bytes[characterWalker.next] & 0xFF;
        ++characterWalker.next;
        if (n > 127) {
            if (characterWalker.bytes.length > characterWalker.next) {
                n = n << 8 | characterWalker.bytes[characterWalker.next];
                ++characterWalker.next;
            } else {
                throw new SQLException();
            }
        }
        return n;
    }

    void encode(CharacterBuffer characterBuffer, int n) throws SQLException {
        CharacterSet.need(characterBuffer, 1);
        characterBuffer.bytes[characterBuffer.next] = (byte)n;
        ++characterBuffer.next;
        n = n >> 8 & 0xFF;
        if (n != 0) {
            CharacterSet.need(characterBuffer, 1);
            characterBuffer.bytes[characterBuffer.next] = (byte)n;
            ++characterBuffer.next;
        }
    }
}

