/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleClobInputStream;
import oracle.jdbc.driver.OracleClobOutputStream;
import oracle.jdbc.driver.OracleClobReader;
import oracle.jdbc.driver.OracleClobWriter;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc2.Clob;
import oracle.sql.Datum;

public class CLOB
extends Datum
implements Clob {
    static final boolean DEBUG = false;
    static final int MAX_PLSQL_SIZE = 32512;
    static final int MAX_PLSQL_INSTR_SIZE = 32512;
    static final int MAX_CHUNK_SIZE = 32512;
    OracleConnection m_conn;
    private int m_dbChunkSize;
    private int m_thinVC2MaxSize;

    protected CLOB() {
    }

    public CLOB(OracleConnection oracleConnection) throws SQLException {
        this(oracleConnection, null);
        this.m_dbChunkSize = -1;
        this.m_thinVC2MaxSize = 0;
    }

    public CLOB(OracleConnection oracleConnection, byte[] byArray) throws SQLException {
        super(byArray);
        if (oracleConnection != null) {
            this.m_conn = oracleConnection;
            return;
        }
        DBError.check_error(8, "Connection is null");
    }

    public long length() throws SQLException {
        return this.getConnection().db_access.lobLength(this);
    }

    public String getSubString(long l, int n) throws SQLException {
        if (n < 0 || l < 1L) {
            DBError.check_error(68, "getSubString");
        }
        if (n == 0) {
            return new String();
        }
        char[] cArray = new char[n];
        int n2 = this.getChars(l, n, cArray);
        if (n2 > 0) {
            return new String(cArray, 0, n2);
        }
        return new String();
    }

    public Reader getCharacterStream() throws SQLException {
        return new OracleClobReader(this, this.getBufferSize());
    }

    public InputStream getAsciiStream() throws SQLException {
        return new OracleClobInputStream(this, this.getBufferSize());
    }

    public long position(String string, long l) throws SQLException {
        if (l < 1L) {
            DBError.check_error(68, "position()");
        }
        if (string == null || string.length() == 0) {
            return -1L;
        }
        long l2 = this.getConnection().db_access.hasPattern(this, string.toCharArray(), l);
        if (l2 == 0L) {
            return -1L;
        }
        return l2;
    }

    public long position(Clob clob, long l) throws SQLException {
        if (l < 1L) {
            DBError.check_error(68, "position");
        }
        if (clob == null) {
            return -1L;
        }
        long l2 = this.getConnection().db_access.isSubLob(this, (CLOB)clob, l);
        if (l2 == 0L) {
            return -1L;
        }
        return l2;
    }

    public int getChars(long l, int n, char[] cArray) throws SQLException {
        if (n < 0 || l < 1L || cArray == null) {
            DBError.check_error(68, "getChars()");
        }
        if (n == 0) {
            return 0;
        }
        return (int)this.getConnection().db_access.lobRead(this, l, (long)n, cArray);
    }

    public Writer getCharacterOutputStream() throws SQLException {
        return new OracleClobWriter(this, this.getBufferSize());
    }

    public OutputStream getAsciiOutputStream() throws SQLException {
        return new OracleClobOutputStream(this, this.getBufferSize());
    }

    public byte[] getLocator() {
        return this.getBytes();
    }

    public void setLocator(byte[] byArray) {
        this.setBytes(byArray);
    }

    public OracleConnection getConnection() throws SQLException {
        if (this.m_conn == null) {
            this.m_conn = (OracleConnection)new OracleDriver().defaultConnection();
        }
        return this.m_conn;
    }

    public int putChars(long l, char[] cArray) throws SQLException {
        if (l < 1L) {
            DBError.check_error(68, "putChars()");
        }
        if (cArray == null || cArray.length < 0) {
            return 0;
        }
        return (int)this.getConnection().db_access.lobWrite(this, l, cArray);
    }

    public int putString(long l, String string) throws SQLException {
        if (l < 1L) {
            DBError.check_error(68, "putString()");
        }
        if (string == null || string.length() == 0) {
            return 0;
        }
        return this.putChars(l, string.toCharArray());
    }

    public int getChunkSize() throws SQLException {
        if (this.m_dbChunkSize <= 0) {
            this.m_dbChunkSize = (int)this.getConnection().db_access.getLobChunkSize(this);
        }
        return this.m_dbChunkSize;
    }

    public int getBufferSize() throws SQLException {
        int n = this.getChunkSize();
        if (n >= 32512 || n <= 0) {
            return 32512;
        }
        return 32512 / n * n;
    }

    public long plsql_read(long l, long l2, char[] cArray) throws SQLException {
        OraclePreparedStatement oraclePreparedStatement = null;
        int n = 0;
        int n2 = 1;
        try {
            block7: {
                try {
                    DBConversion dBConversion = this.m_conn.conversion;
                    boolean bl = DBConversion.isCharSetMultibyte(dBConversion.getAccessCharSet());
                    if (bl) {
                        n2 = this.m_conn.db_access.getNlsRatio();
                    }
                    oraclePreparedStatement = (OracleCallableStatement)this.getConnection().prepareCall("begin dbms_lob.read(?, ?, ?, ?); end;");
                    int n3 = 0;
                    int n4 = 0;
                    byte[] byArray = null;
                    char[] cArray2 = new char[32512];
                    oraclePreparedStatement.setCLOB(1, this);
                    ((OracleCallableStatement)oraclePreparedStatement).registerOutParameter(2, 2);
                    ((OracleCallableStatement)oraclePreparedStatement).registerOutParameter(4, 12);
                    while ((long)n < l2) {
                        n4 = (int)Math.min(l2 - (long)n, (long)(32512 / n2));
                        oraclePreparedStatement.setInt(2, n4);
                        oraclePreparedStatement.setInt(3, (int)l + n);
                        oraclePreparedStatement.execute();
                        n3 = ((OracleCallableStatement)oraclePreparedStatement).getInt(2);
                        byArray = ((OracleCallableStatement)oraclePreparedStatement).getBytes(4);
                        int n5 = 0;
                        n5 = this.getConnection().conversion.CHARBytesToJavaChars(byArray, byArray.length, cArray2);
                        if (n5 != n3) {
                            DBError.check_error(37, null);
                        }
                        System.arraycopy(cArray2, 0, cArray, n, n3);
                        n += n3;
                    }
                }
                catch (SQLException sQLException) {
                    if (sQLException.getErrorCode() == 1403) break block7;
                    throw sQLException;
                }
            }
            Object var10_15 = null;
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            oraclePreparedStatement.close();
            oraclePreparedStatement = null;
            throw throwable;
        }
        oraclePreparedStatement.close();
        oraclePreparedStatement = null;
        return n;
    }

    public long plsql_write(long l, char[] cArray) throws SQLException {
        OraclePreparedStatement oraclePreparedStatement = null;
        int n = cArray.length;
        int n2 = 0;
        try {
            String string = null;
            int n3 = 0;
            DBConversion dBConversion = this.m_conn.conversion;
            boolean bl = DBConversion.isCharSetMultibyte(dBConversion.getAccessCharSet());
            oraclePreparedStatement = (OracleCallableStatement)this.getConnection().prepareCall("begin dbms_lob.write (?, ?, ?, ?); end;");
            ((OracleCallableStatement)oraclePreparedStatement).registerOutParameter(1, 2005);
            if (!bl) {
                while (n2 < n) {
                    oraclePreparedStatement.setCLOB(1, this);
                    oraclePreparedStatement.setInt(3, (int)l + n2);
                    n3 = Math.min(n - n2, 32512);
                    n3 = Math.min(n3, this.getThinVC2MaxSize());
                    string = new String(cArray, n2, n3);
                    oraclePreparedStatement.setInt(2, n3);
                    oraclePreparedStatement.setString(4, string);
                    oraclePreparedStatement.execute();
                    n2 += n3;
                    this.setLocator(((OracleCallableStatement)oraclePreparedStatement).getCLOB(1).getLocator());
                }
            } else {
                int n4 = 32512 / this.m_conn.db_access.getC2SNlsRatio();
                int n5 = dBConversion.getMaxCharbyteSize();
                int n6 = Math.min(n4 / n5, n);
                int n7 = n6 / 3;
                byte[] byArray = new byte[n6 * n5];
                char[] cArray2 = new char[n6];
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                int n12 = 0;
                boolean bl2 = false;
                boolean bl3 = true;
                while (n2 < n) {
                    oraclePreparedStatement.setCLOB(1, this);
                    oraclePreparedStatement.setInt(3, (int)l + n2);
                    bl2 = false;
                    n11 = 0;
                    n12 = 0;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    bl3 = true;
                    while (!bl2) {
                        if (n9 != 0) {
                            bl3 = false;
                            byteArrayOutputStream.write(byArray, 0, n9);
                            n11 += n9;
                            n9 = 0;
                            n12 += n10;
                            n10 = 0;
                        }
                        if (bl3) {
                            n10 = Math.min(n6, n - n8);
                            bl3 = false;
                        } else {
                            n10 = Math.min(n7, n - n8);
                            if (n10 * n5 + n11 > n4 && n10 > 100) {
                                n10 = 100;
                            }
                        }
                        if (n10 > 0) {
                            int n13 = 0;
                            while (n13 < n10) {
                                cArray2[n13] = cArray[n8 + n13];
                                ++n13;
                            }
                            n8 += n10;
                            n9 = this.m_conn.conversion.javaCharsToCHARBytes(cArray2, n10, byArray);
                            if (n11 + n9 <= n4) {
                                byteArrayOutputStream.write(byArray, 0, n9);
                                n12 += n10;
                                n11 += n9;
                                n9 = 0;
                                n10 = 0;
                                if (n11 != n4) continue;
                                bl2 = true;
                                continue;
                            }
                            bl2 = true;
                            continue;
                        }
                        bl2 = true;
                    }
                    if (n12 > 0) {
                        byte[] byArray2 = byteArrayOutputStream.toByteArray();
                        oraclePreparedStatement.setInt(2, n12);
                        oraclePreparedStatement.setInternalBytes(4, byArray2, 1);
                        oraclePreparedStatement.execute();
                        n2 += n12;
                        this.setLocator(((OracleCallableStatement)oraclePreparedStatement).getCLOB(1).getLocator());
                        continue;
                    }
                    if (n2 >= n) continue;
                    DBError.throwSqlException(1);
                }
            }
        }
        catch (Throwable throwable) {
            Object var8_27 = null;
            if (oraclePreparedStatement != null) {
                oraclePreparedStatement.close();
                oraclePreparedStatement = null;
            }
            throw throwable;
        }
        Object var8_26 = null;
        if (oraclePreparedStatement != null) {
            oraclePreparedStatement.close();
            oraclePreparedStatement = null;
        }
        return n2;
    }

    public long plsql_length() throws SQLException {
        long l = 0L;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)this.getConnection().prepareCall("begin ? := dbms_lob.getLength(?); end;");
            oracleCallableStatement.registerOutParameter(1, 2);
            oracleCallableStatement.setCLOB(2, this);
            oracleCallableStatement.execute();
            l = oracleCallableStatement.getLong(1);
        }
        finally {
            Object var5_3 = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
        }
        return l;
    }

    public long plsql_hasPattern(char[] cArray, long l) throws SQLException {
        if (cArray == null || l <= 0L) {
            return 0L;
        }
        long l2 = cArray.length;
        long l3 = this.length();
        if (l2 == 0L || l2 > l3 - l + 1L || l > l3) {
            return 0L;
        }
        if (l2 <= (long)this.getThinMaxInstrSize()) {
            long l4;
            OracleCallableStatement oracleCallableStatement = null;
            try {
                oracleCallableStatement = (OracleCallableStatement)this.getConnection().prepareCall("begin ? := dbms_lob.instr(?, ?, ?); end;");
                oracleCallableStatement.registerOutParameter(1, 2);
                oracleCallableStatement.setCLOB(2, this);
                oracleCallableStatement.setString(3, new String(cArray));
                oracleCallableStatement.setLong(4, l);
                oracleCallableStatement.execute();
                l4 = oracleCallableStatement.getLong(1);
                Object var12_9 = null;
            }
            catch (Throwable throwable) {
                Object var12_10 = null;
                oracleCallableStatement.close();
                oracleCallableStatement = null;
                throw throwable;
            }
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            return l4;
        }
        int n = 0;
        long l5 = l;
        boolean bl = false;
        long l6 = 0L;
        while (!bl) {
            if (l2 > l3 - l5 + 1L) {
                return 0L;
            }
            n = 0;
            int n2 = (int)Math.min((long)this.getThinMaxInstrSize(), l2 - (long)n);
            char[] cArray2 = new char[n2];
            System.arraycopy(cArray, n, cArray2, 0, n2);
            long l7 = this.plsql_hasPattern(cArray2, l5);
            if (l7 == 0L) {
                return 0L;
            }
            l6 = l7;
            n += n2;
            l5 = l7 + (long)n2;
            boolean bl2 = true;
            while (bl2) {
                n2 = (int)Math.min((long)this.getThinMaxInstrSize(), l2 - (long)n);
                cArray2 = new char[n2];
                System.arraycopy(cArray, n, cArray2, 0, n2);
                l7 = this.plsql_hasPattern(cArray2, l5);
                if (l7 == l5) {
                    l5 += (long)n2;
                    if ((long)(n += n2) != l2) continue;
                    bl2 = false;
                    bl = true;
                    continue;
                }
                if (l7 == 0L) {
                    return 0L;
                }
                l5 = l7 - (long)n;
                bl2 = false;
            }
        }
        return l6;
    }

    public long plsql_isSubLob(CLOB cLOB, long l) throws SQLException {
        if (cLOB == null || l <= 0L) {
            return 0L;
        }
        long l2 = cLOB.length();
        long l3 = this.length();
        if (l2 == 0L || l2 > l3 - l + 1L || l > l3) {
            return 0L;
        }
        if (l2 <= (long)this.getThinMaxInstrSize()) {
            char[] cArray = new char[(int)l2];
            cLOB.getChars(1L, (int)l2, cArray);
            return this.plsql_hasPattern(cArray, l);
        }
        int n = 0;
        long l4 = l;
        boolean bl = false;
        long l5 = 0L;
        while (!bl) {
            if (l2 > l3 - l4 + 1L) {
                return 0L;
            }
            n = 0;
            int n2 = (int)Math.min((long)this.getThinMaxInstrSize(), l2 - (long)n);
            char[] cArray = new char[n2];
            cLOB.getChars(n + 1, n2, cArray);
            long l6 = this.plsql_hasPattern(cArray, l4);
            if (l6 == 0L) {
                return 0L;
            }
            l5 = l6;
            n += n2;
            l4 = l6 + (long)n2;
            boolean bl2 = true;
            while (bl2) {
                n2 = (int)Math.min((long)this.getThinMaxInstrSize(), l2 - (long)n);
                cArray = new char[n2];
                cLOB.getChars(n + 1, n2, cArray);
                l6 = this.plsql_hasPattern(cArray, l4);
                if (l6 == l4) {
                    l4 += (long)n2;
                    if ((long)(n += n2) != l2) continue;
                    bl2 = false;
                    bl = true;
                    continue;
                }
                if (l6 == 0L) {
                    return 0L;
                }
                l4 = l6 - (long)n;
                bl2 = false;
            }
        }
        return l5;
    }

    public long plsql_getChunkSize() throws SQLException {
        long l = 0L;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            try {
                oracleCallableStatement = (OracleCallableStatement)this.getConnection().prepareCall("begin ? := dbms_lob.getchunksize(?); end;");
                oracleCallableStatement.registerOutParameter(1, 2);
                oracleCallableStatement.setCLOB(2, this);
                oracleCallableStatement.execute();
                l = oracleCallableStatement.getLong(1);
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() != 6550) {
                    throw sQLException;
                }
                l = 32512L;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        oracleCallableStatement = null;
        return l;
    }

    public Object toJdbc() throws SQLException {
        return this;
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.io.InputStream") == 0 || string.compareTo("java.io.Reader") == 0;
    }

    public Reader characterStreamValue() throws SQLException {
        return this.getCharacterStream();
    }

    public InputStream asciiStreamValue() throws SQLException {
        return this.getAsciiStream();
    }

    public InputStream binaryStreamValue() throws SQLException {
        return this.getAsciiStream();
    }

    public Object makeJdbcArray(int n) {
        return new CLOB[n];
    }

    private int getThinVC2MaxSize() throws SQLException {
        if (this.m_thinVC2MaxSize == 0) {
            short s = this.m_conn.db_access.getVersionNumber();
            int n = this.m_conn.db_access.getC2SNlsRatio();
            this.m_thinVC2MaxSize = s >= 8100 ? 4000 / n : 2000 / n;
        }
        return this.m_thinVC2MaxSize;
    }

    private int getThinMaxInstrSize() throws SQLException {
        DBConversion dBConversion = this.m_conn.conversion;
        boolean bl = DBConversion.isCharSetMultibyte(dBConversion.getAccessCharSet());
        int n = dBConversion.getMaxCharbyteSize();
        if (bl) {
            return 32512 / (this.m_conn.db_access.getC2SNlsRatio() * n);
        }
        return 32512;
    }
}

