/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.util.RepConversion;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;

public class CHAR
extends Datum {
    public static final CharacterSet DEFAULT_CHARSET = CharacterSet.make(-1);
    private CharacterSet charSet;
    private int oracleId;
    private static byte[] empty = new byte[0];

    protected CHAR() {
    }

    public CHAR(byte[] byArray, CharacterSet characterSet) {
        this.setValue(byArray, characterSet);
    }

    public CHAR(byte[] byArray, int n, int n2, CharacterSet characterSet) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.setValue(byArray2, characterSet);
    }

    public CHAR(String string, CharacterSet characterSet) throws SQLException {
        if (characterSet == null) {
            characterSet = DEFAULT_CHARSET;
        }
        this.setValue(characterSet.convert(string), characterSet);
    }

    public CHAR(Object object, CharacterSet characterSet) throws SQLException {
        this(object.toString(), characterSet);
    }

    public CharacterSet getCharacterSet() {
        if (this.charSet == null) {
            if (this.oracleId == 0) {
                this.oracleId = -1;
            }
            int n = this.oracleId;
            this.charSet = CharacterSet.factory.make(n);
        }
        return this.charSet;
    }

    public String getString() throws SQLException {
        return this.getCharacterSet().toString(this.shareBytes(), 0, (int)this.getLength());
    }

    public String getStringWithReplacement() {
        byte[] byArray = this.shareBytes();
        return this.getCharacterSet().toStringWithReplacement(byArray, 0, byArray.length);
    }

    /*
     * Unable to fully structure code
     */
    public String toString() {
        block3: {
            try {
                var1_1 = this.getString();
                break block3;
            }
            catch (SQLException v0) {
                var2_2 = new StringBuffer();
                var2_2.append("0x");
                var3_3 = this.shareBytes();
                var4_4 = 0;
                ** while (var4_4 < var3_3.length)
            }
lbl-1000:
            // 1 sources

            {
                var2_2.append((char)RepConversion.nibbleToHex((byte)(var3_3[var4_4] >> 4 & 15)));
                var2_2.append((char)RepConversion.nibbleToHex((byte)(var3_3[var4_4] & 15)));
                ++var4_4;
                continue;
            }
lbl17:
            // 1 sources

            var1_1 = var2_2.toString();
        }
        return var1_1;
    }

    public boolean equals(Object object) {
        return object instanceof CHAR && this.getCharacterSet().equals(((CHAR)object).getCharacterSet()) && super.equals(object);
    }

    void setValue(byte[] byArray, CharacterSet characterSet) {
        this.charSet = characterSet == null ? DEFAULT_CHARSET : characterSet;
        this.oracleId = this.charSet.getOracleId();
        this.setShareBytes(byArray == null ? empty : byArray);
    }

    public Object toJdbc() throws SQLException {
        return this.stringValue();
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.lang.String") == 0 || string.compareTo("java.lang.Long") == 0 || string.compareTo("java.math.BigDecimal") == 0 || string.compareTo("java.io.InputStream") == 0 || string.compareTo("java.sql.Date") == 0 || string.compareTo("java.sql.Time") == 0 || string.compareTo("java.sql.Timestamp") == 0 || string.compareTo("java.io.Reader") == 0;
    }

    public String stringValue() {
        return this.toString();
    }

    public boolean booleanValue() throws SQLException {
        String string = this.stringValue();
        if (string == null) {
            return false;
        }
        return string.length() != 1 || string.charAt(0) != '0';
    }

    public int intValue() throws SQLException {
        long l = this.longValue();
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            DBError.throwSqlException(26);
        }
        return (int)l;
    }

    public long longValue() throws SQLException {
        long l = 0L;
        try {
            l = Long.valueOf(this.stringValue());
        }
        catch (NumberFormatException numberFormatException) {
            DBError.throwSqlException(59);
        }
        return l;
    }

    public float floatValue() throws SQLException {
        float f = 0.0f;
        try {
            f = Float.valueOf(this.stringValue()).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            DBError.throwSqlException(59);
        }
        return f;
    }

    public double doubleValue() throws SQLException {
        double d = 0.0;
        try {
            d = Double.valueOf(this.stringValue());
        }
        catch (NumberFormatException numberFormatException) {
            DBError.throwSqlException(59);
        }
        return d;
    }

    public byte byteValue() throws SQLException {
        long l = this.longValue();
        if (l > 127L || l < -128L) {
            DBError.throwSqlException(26);
        }
        return (byte)l;
    }

    public Date dateValue() throws SQLException {
        return Date.valueOf(this.stringValue());
    }

    public Time timeValue() throws SQLException {
        return Time.valueOf(this.stringValue());
    }

    public Timestamp timestampValue() throws SQLException {
        return Timestamp.valueOf(this.stringValue());
    }

    public BigDecimal bigDecimalValue() throws SQLException {
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = new BigDecimal(this.stringValue());
        }
        catch (NumberFormatException numberFormatException) {
            DBError.check_error(12, "bigDecimalValue");
        }
        return bigDecimal;
    }

    public Reader characterStreamValue() throws SQLException {
        return new StringReader(this.getString());
    }

    public InputStream asciiStreamValue() throws SQLException {
        return this.getStream();
    }

    public InputStream binaryStreamValue() throws SQLException {
        return this.getStream();
    }

    public Object makeJdbcArray(int n) {
        return new String[n];
    }
}

