/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleBlobInputStream;
import oracle.jdbc.driver.OracleBlobOutputStream;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleConversionInputStream;
import oracle.jdbc.driver.OracleConversionReader;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc2.Blob;
import oracle.sql.Datum;

public class BLOB
extends Datum
implements Blob {
    static boolean PLSQL_DEBUG;
    static final int MAX_PLSQL_SIZE = 32512;
    static final int MAX_PLSQL_INSTR_SIZE = 32512;
    static final int MAX_CHUNK_SIZE = 32512;
    OracleConnection m_conn;
    private int m_dbChunkSize;

    protected BLOB() {
    }

    public BLOB(OracleConnection oracleConnection) throws SQLException {
        this(oracleConnection, null);
        this.m_dbChunkSize = -1;
    }

    public BLOB(OracleConnection oracleConnection, byte[] byArray) throws SQLException {
        super(byArray);
        if (oracleConnection != null) {
            this.m_conn = oracleConnection;
            return;
        }
        DBError.check_error(8, "Connection is null");
    }

    public long length() throws SQLException {
        return this.getConnection().db_access.lobLength(this);
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (n < 0 || l < 1L) {
            DBError.check_error(68, "getBytes()");
        }
        if (n == 0) {
            return new byte[0];
        }
        long l2 = 0L;
        byte[] byArray = new byte[n];
        l2 = this.getBytes(l, n, byArray);
        if (l2 > 0L) {
            if (l2 == (long)n) {
                return byArray;
            }
            byte[] byArray2 = new byte[(int)l2];
            System.arraycopy(byArray, 0, byArray2, 0, (int)l2);
            return byArray2;
        }
        return null;
    }

    public InputStream getBinaryStream() throws SQLException {
        return new OracleBlobInputStream(this, this.getBufferSize());
    }

    public long position(byte[] byArray, long l) throws SQLException {
        if (l < 1L) {
            DBError.check_error(68, "position()");
        }
        if (byArray == null || byArray.length == 0) {
            return -1L;
        }
        long l2 = this.getConnection().db_access.hasPattern(this, byArray, l);
        if (l2 == 0L) {
            return -1L;
        }
        return l2;
    }

    public long position(Blob blob, long l) throws SQLException {
        if (l < 1L) {
            DBError.check_error(68, "position()");
        }
        if (blob == null) {
            return -1L;
        }
        long l2 = this.getConnection().db_access.isSubLob(this, (BLOB)blob, l);
        if (l2 == 0L) {
            return -1L;
        }
        return l2;
    }

    public int getBytes(long l, int n, byte[] byArray) throws SQLException {
        if (n < 0 || l < 1L || byArray == null) {
            DBError.check_error(68, "getBytes()");
        }
        if (n == 0) {
            return 0;
        }
        return (int)this.getConnection().db_access.lobRead(this, l, (long)n, byArray);
    }

    public int putBytes(long l, byte[] byArray) throws SQLException {
        if (l < 1L) {
            DBError.check_error(68, "putBytes()");
        }
        if (byArray == null || byArray.length == 0) {
            return 0;
        }
        return (int)this.getConnection().db_access.lobWrite(this, l, byArray);
    }

    public OutputStream getBinaryOutputStream() throws SQLException {
        return new OracleBlobOutputStream(this, this.getBufferSize());
    }

    public byte[] getLocator() {
        return this.getBytes();
    }

    public void setLocator(byte[] byArray) {
        this.setBytes(byArray);
    }

    public int getChunkSize() throws SQLException {
        if (this.m_dbChunkSize <= 0) {
            this.m_dbChunkSize = (int)this.getConnection().db_access.getLobChunkSize(this);
        }
        return this.m_dbChunkSize;
    }

    public int getBufferSize() throws SQLException {
        int n = this.getChunkSize();
        if (n >= 32512 || n <= 0) {
            return 32512;
        }
        return 32512 / n * n;
    }

    public OracleConnection getConnection() throws SQLException {
        if (this.m_conn == null) {
            this.m_conn = (OracleConnection)new OracleDriver().defaultConnection();
        }
        return this.m_conn;
    }

    public long plsql_read(long l, long l2, byte[] byArray) throws SQLException {
        if (PLSQL_DEBUG) {
            System.out.println("plsql_read(" + l + "," + l2 + ")");
        }
        OracleCallableStatement oracleCallableStatement = null;
        int n = 0;
        try {
            block11: {
                try {
                    oracleCallableStatement = (OracleCallableStatement)this.getConnection().prepareCall("begin dbms_lob.read (?, ?, ?, ?); end;");
                    int n2 = 0;
                    int n3 = 0;
                    oracleCallableStatement.setBLOB(1, this);
                    oracleCallableStatement.registerOutParameter(2, 2);
                    oracleCallableStatement.registerOutParameter(4, -3);
                    while ((long)n < l2) {
                        n3 = Math.min((int)l2, 32512);
                        if (PLSQL_DEBUG) {
                            System.out.println("read chunks: chunkSize=" + n3);
                        }
                        oracleCallableStatement.setInt(2, n3);
                        oracleCallableStatement.setInt(3, (int)l + n);
                        oracleCallableStatement.execute();
                        n2 = oracleCallableStatement.getInt(2);
                        byte[] byArray2 = oracleCallableStatement.getBytes(4);
                        System.arraycopy(byArray2, 0, byArray, n, n2);
                        if (PLSQL_DEBUG) {
                            System.out.println("==> sizeRead=" + n2);
                        }
                        n += n2;
                    }
                }
                catch (SQLException sQLException) {
                    if (sQLException.getErrorCode() != 1403) {
                        throw sQLException;
                    }
                    if (!PLSQL_DEBUG) break block11;
                    System.out.println("end of file");
                }
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            if (PLSQL_DEBUG) {
                System.out.println("end plsql_read =" + n);
            }
            throw throwable;
        }
        oracleCallableStatement.close();
        oracleCallableStatement = null;
        if (PLSQL_DEBUG) {
            System.out.println("end plsql_read =" + n);
        }
        return n;
    }

    public long plsql_write(long l, byte[] byArray) throws SQLException {
        int n = byArray.length;
        OracleCallableStatement oracleCallableStatement = null;
        int n2 = 0;
        try {
            oracleCallableStatement = (OracleCallableStatement)this.getConnection().prepareCall("begin dbms_lob.write (?, ?, ?, ?); end;");
            int n3 = Math.min(n, 32512);
            byte[] byArray2 = new byte[n3];
            oracleCallableStatement.registerOutParameter(1, 2004);
            while (n2 < n) {
                n3 = Math.min(n - n2, 32512);
                System.arraycopy(byArray, n2, byArray2, 0, n3);
                oracleCallableStatement.setBLOB(1, this);
                oracleCallableStatement.setInt(2, n3);
                oracleCallableStatement.setInt(3, (int)l + n2);
                oracleCallableStatement.setBytes(4, byArray2);
                oracleCallableStatement.execute();
                n2 += n3;
                this.setLocator(oracleCallableStatement.getBLOB(1).getLocator());
            }
        }
        finally {
            Object var8_8 = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
        }
        return n2;
    }

    public long plsql_length() throws SQLException {
        long l = 0L;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)this.getConnection().prepareCall("begin ? := dbms_lob.getLength (?); end;");
            oracleCallableStatement.registerOutParameter(1, 2);
            oracleCallableStatement.setBLOB(2, this);
            oracleCallableStatement.execute();
            l = oracleCallableStatement.getLong(1);
        }
        finally {
            Object var5_3 = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
        }
        return l;
    }

    public long plsql_hasPattern(byte[] byArray, long l) throws SQLException {
        if (byArray == null || l <= 0L) {
            return 0L;
        }
        long l2 = byArray.length;
        long l3 = this.length();
        if (l2 == 0L || l2 > l3 - l + 1L || l > l3) {
            return 0L;
        }
        if (l2 <= 32512L) {
            long l4;
            OracleCallableStatement oracleCallableStatement = null;
            try {
                oracleCallableStatement = (OracleCallableStatement)this.getConnection().prepareCall("begin ? := dbms_lob.instr(?, ?, ?); end;");
                oracleCallableStatement.registerOutParameter(1, 2);
                oracleCallableStatement.setBLOB(2, this);
                oracleCallableStatement.setBytes(3, byArray);
                oracleCallableStatement.setLong(4, l);
                oracleCallableStatement.execute();
                l4 = oracleCallableStatement.getLong(1);
                Object var12_9 = null;
            }
            catch (Throwable throwable) {
                Object var12_10 = null;
                oracleCallableStatement.close();
                oracleCallableStatement = null;
                throw throwable;
            }
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            return l4;
        }
        int n = 0;
        long l5 = l;
        boolean bl = false;
        long l6 = 0L;
        while (!bl) {
            if (l2 > l3 - l5 + 1L) {
                return 0L;
            }
            n = 0;
            int n2 = (int)Math.min(32512L, l2 - (long)n);
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            long l7 = this.plsql_hasPattern(byArray2, l5);
            if (l7 == 0L) {
                return 0L;
            }
            l6 = l7;
            n += n2;
            l5 = l7 + (long)n2;
            boolean bl2 = true;
            while (bl2) {
                n2 = (int)Math.min(32512L, l2 - (long)n);
                byArray2 = new byte[n2];
                System.arraycopy(byArray, n, byArray2, 0, n2);
                l7 = this.plsql_hasPattern(byArray2, l5);
                if (l7 == l5) {
                    l5 += (long)n2;
                    if ((long)(n += n2) != l2) continue;
                    bl2 = false;
                    bl = true;
                    continue;
                }
                if (l7 == 0L) {
                    return 0L;
                }
                l5 = l7 - (long)n;
                bl2 = false;
            }
        }
        return l6;
    }

    public long plsql_isSubLob(BLOB bLOB, long l) throws SQLException {
        if (bLOB == null || l <= 0L) {
            return 0L;
        }
        long l2 = bLOB.length();
        long l3 = this.length();
        if (l2 == 0L || l2 > l3 - l + 1L || l > l3) {
            return 0L;
        }
        if (l2 <= 32512L) {
            byte[] byArray = new byte[(int)l2];
            bLOB.getBytes(1L, (int)l2, byArray);
            return this.plsql_hasPattern(byArray, l);
        }
        int n = 0;
        long l4 = l;
        boolean bl = false;
        long l5 = 0L;
        while (!bl) {
            if (l2 > l3 - l4 + 1L) {
                return 0L;
            }
            n = 0;
            int n2 = (int)Math.min(32512L, l2 - (long)n);
            byte[] byArray = new byte[n2];
            bLOB.getBytes(n + 1, n2, byArray);
            long l6 = this.plsql_hasPattern(byArray, l4);
            if (l6 == 0L) {
                return 0L;
            }
            l5 = l6;
            n += n2;
            l4 = l6 + (long)n2;
            boolean bl2 = true;
            while (bl2) {
                n2 = (int)Math.min(32512L, l2 - (long)n);
                byArray = new byte[n2];
                bLOB.getBytes(n + 1, n2, byArray);
                l6 = this.plsql_hasPattern(byArray, l4);
                if (l6 == l4) {
                    l4 += (long)n2;
                    if ((long)(n += n2) != l2) continue;
                    bl2 = false;
                    bl = true;
                    continue;
                }
                if (l6 == 0L) {
                    return 0L;
                }
                l4 = l6 - (long)n;
                bl2 = false;
            }
        }
        return l5;
    }

    public long plsql_getChunkSize() throws SQLException {
        long l = 0L;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            try {
                oracleCallableStatement = (OracleCallableStatement)this.getConnection().prepareCall("begin ? := dbms_lob.getchunksize(?); end;");
                oracleCallableStatement.registerOutParameter(1, 2);
                oracleCallableStatement.setBLOB(2, this);
                oracleCallableStatement.execute();
                l = oracleCallableStatement.getLong(1);
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() != 6550) {
                    throw sQLException;
                }
                l = 32512L;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        oracleCallableStatement = null;
        return l;
    }

    public Object toJdbc() throws SQLException {
        return this;
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.io.InputStream") == 0 || string.compareTo("java.io.Reader") == 0;
    }

    public Reader characterStreamValue() throws SQLException {
        return new OracleConversionReader(this.m_conn.conversion, this.getBinaryStream(), 8);
    }

    public InputStream asciiStreamValue() throws SQLException {
        return new OracleConversionInputStream(this.m_conn.conversion, this.getBinaryStream(), 2);
    }

    public InputStream binaryStreamValue() throws SQLException {
        return this.getBinaryStream();
    }

    public Object makeJdbcArray(int n) {
        return new BLOB[n];
    }
}

