/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleBlobInputStream;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleConversionInputStream;
import oracle.jdbc.driver.OracleConversionReader;
import oracle.jdbc.driver.OracleDriver;
import oracle.sql.Datum;

public class BFILE
extends Datum {
    static final int MAX_CHUNK_SIZE = 32512;
    static final int MAX_PLSQL_SIZE = 32512;
    static final int MAX_PLSQL_INSTR_SIZE = 32512;
    OracleConnection m_conn;

    protected BFILE() {
    }

    public BFILE(OracleConnection oracleConnection) throws SQLException {
        this(oracleConnection, null);
    }

    public BFILE(OracleConnection oracleConnection, byte[] byArray) throws SQLException {
        super(byArray);
        if (oracleConnection != null) {
            this.m_conn = oracleConnection;
            return;
        }
        DBError.check_error(8, "Connection is null");
    }

    public long length() throws SQLException {
        return this.getConnection().db_access.lobLength(this);
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (l < 1L || n < 0) {
            DBError.check_error(68, null);
        }
        if (n == 0) {
            return new byte[0];
        }
        long l2 = 0L;
        byte[] byArray = new byte[n];
        l2 = this.getBytes(l, n, byArray);
        if (l2 > 0L) {
            if (l2 == (long)n) {
                return byArray;
            }
            byte[] byArray2 = new byte[(int)l2];
            System.arraycopy(byArray, 0, byArray2, 0, (int)l2);
            return byArray2;
        }
        return new byte[0];
    }

    public int getBytes(long l, int n, byte[] byArray) throws SQLException {
        if (l < 1L || n < 0 || byArray == null) {
            DBError.check_error(68, "getBytes()");
        }
        if (n == 0) {
            return 0;
        }
        return (int)this.getConnection().db_access.lobRead(this, l, (long)n, byArray);
    }

    public InputStream getBinaryStream() throws SQLException {
        return new OracleBlobInputStream(this, 32512);
    }

    public long position(byte[] byArray, long l) throws SQLException {
        if (l < 1L) {
            DBError.check_error(68, "position()");
        }
        if (byArray == null || byArray.length == 0) {
            return -1L;
        }
        long l2 = this.getConnection().db_access.hasPattern(this, byArray, l);
        if (l2 == 0L) {
            return -1L;
        }
        return l2;
    }

    public long position(BFILE bFILE, long l) throws SQLException {
        if (l < 1L) {
            DBError.check_error(68, "position()");
        }
        if (bFILE == null) {
            return -1L;
        }
        long l2 = this.getConnection().db_access.isSubLob(this, bFILE, l);
        if (l2 == 0L) {
            return -1L;
        }
        return l2;
    }

    public String getName() throws SQLException {
        return this.getConnection().db_access.fileGetName(this);
    }

    public String getDirAlias() throws SQLException {
        return this.getConnection().db_access.fileGetDirAlias(this);
    }

    public void openFile() throws SQLException {
        this.getConnection().db_access.fileOpen(this);
    }

    public boolean isFileOpen() throws SQLException {
        return this.getConnection().db_access.fileIsOpen(this);
    }

    public boolean fileExists() throws SQLException {
        return this.getConnection().db_access.fileExists(this);
    }

    public void closeFile() throws SQLException {
        this.getConnection().db_access.fileClose(this);
    }

    public byte[] getLocator() {
        return this.getBytes();
    }

    public void setLocator(byte[] byArray) {
        this.setBytes(byArray);
    }

    public OracleConnection getConnection() throws SQLException {
        if (this.m_conn == null) {
            this.m_conn = (OracleConnection)new OracleDriver().defaultConnection();
        }
        return this.m_conn;
    }

    public void plsql_fileOpen() throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)this.m_conn.prepareCall("begin dbms_lob.fileopen (?, ?); end;");
            oracleCallableStatement.setBFILE(1, this);
            oracleCallableStatement.setInt(2, 0);
            oracleCallableStatement.registerOutParameter(1, -13);
            oracleCallableStatement.execute();
            this.setLocator(oracleCallableStatement.getBFILE(1).getLocator());
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        Object var3_2 = null;
        oracleCallableStatement.close();
        oracleCallableStatement = null;
    }

    public boolean plsql_fileIsOpen() throws SQLException {
        boolean bl;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)this.m_conn.prepareCall("begin ? := dbms_lob.fileIsOpen(?); end; ");
            oracleCallableStatement.registerOutParameter(1, 2);
            oracleCallableStatement.setBFILE(2, this);
            oracleCallableStatement.execute();
            bl = oracleCallableStatement.getBoolean(1);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        oracleCallableStatement = null;
        return bl;
    }

    public boolean plsql_fileExists() throws SQLException {
        boolean bl;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)this.m_conn.prepareCall("begin ? := dbms_lob.fileExists(?); end; ");
            oracleCallableStatement.registerOutParameter(1, 2);
            oracleCallableStatement.setBFILE(2, this);
            oracleCallableStatement.execute();
            bl = oracleCallableStatement.getBoolean(1);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        oracleCallableStatement = null;
        return bl;
    }

    public String plsql_fileGetName() throws SQLException {
        String string;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)this.m_conn.prepareCall("begin dbms_lob.fileGetName(?, ?, ?); end; ");
            oracleCallableStatement.setBFILE(1, this);
            oracleCallableStatement.registerOutParameter(2, 12);
            oracleCallableStatement.registerOutParameter(3, 12);
            oracleCallableStatement.execute();
            string = oracleCallableStatement.getString(3);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        oracleCallableStatement = null;
        return string;
    }

    public String plsql_fileGetDirAlias() throws SQLException {
        String string;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)this.m_conn.prepareCall("begin dbms_lob.fileGetName(?, ?, ?); end; ");
            oracleCallableStatement.setBFILE(1, this);
            oracleCallableStatement.registerOutParameter(2, 12);
            oracleCallableStatement.registerOutParameter(3, 12);
            oracleCallableStatement.execute();
            string = oracleCallableStatement.getString(2);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        oracleCallableStatement = null;
        return string;
    }

    public void plsql_fileClose() throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)this.m_conn.prepareCall("begin dbms_lob.fileclose (?); end;");
            oracleCallableStatement.setBFILE(1, this);
            oracleCallableStatement.registerOutParameter(1, -13);
            oracleCallableStatement.execute();
            this.setLocator(oracleCallableStatement.getBFILE(1).getLocator());
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        Object var3_2 = null;
        oracleCallableStatement.close();
        oracleCallableStatement = null;
    }

    public long plsql_read(long l, long l2, byte[] byArray) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        int n = 0;
        try {
            block5: {
                try {
                    oracleCallableStatement = (OracleCallableStatement)this.m_conn.prepareCall("begin dbms_lob.read (?, ?, ?, ?); end;");
                    int n2 = 0;
                    byte[] byArray2 = null;
                    int n3 = 0;
                    oracleCallableStatement.setBFILE(1, this);
                    oracleCallableStatement.registerOutParameter(2, 2);
                    oracleCallableStatement.registerOutParameter(4, -3);
                    while ((long)n < l2) {
                        n3 = Math.min((int)l2 - n, 32512);
                        oracleCallableStatement.setInt(2, n3);
                        oracleCallableStatement.setInt(3, (int)l + n);
                        oracleCallableStatement.execute();
                        n2 = oracleCallableStatement.getInt(2);
                        byArray2 = oracleCallableStatement.getBytes(4);
                        System.arraycopy(byArray2, 0, byArray, n, n2);
                        n += n2;
                    }
                }
                catch (SQLException sQLException) {
                    if (sQLException.getErrorCode() == 1403) break block5;
                    throw sQLException;
                }
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        oracleCallableStatement = null;
        return n;
    }

    public long plsql_length() throws SQLException {
        long l = 0L;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)this.m_conn.prepareCall("begin ? := dbms_lob.getLength (?); end;");
            oracleCallableStatement.registerOutParameter(1, 2);
            oracleCallableStatement.setBFILE(2, this);
            oracleCallableStatement.execute();
            l = oracleCallableStatement.getLong(1);
        }
        finally {
            Object var5_3 = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
        }
        return l;
    }

    public long plsql_hasPattern(byte[] byArray, long l) throws SQLException {
        if (byArray == null || l <= 0L) {
            return 0L;
        }
        long l2 = byArray.length;
        long l3 = this.length();
        if (l2 == 0L || l2 > l3 - l + 1L || l > l3) {
            return 0L;
        }
        if (l2 <= 32512L) {
            long l4;
            OracleCallableStatement oracleCallableStatement = null;
            try {
                oracleCallableStatement = (OracleCallableStatement)this.m_conn.prepareCall("begin ? := dbms_lob.instr(?, ?, ?); end;");
                oracleCallableStatement.registerOutParameter(1, 2);
                oracleCallableStatement.setBFILE(2, this);
                oracleCallableStatement.setBytes(3, byArray);
                oracleCallableStatement.setLong(4, l);
                oracleCallableStatement.execute();
                l4 = oracleCallableStatement.getLong(1);
                Object var12_9 = null;
            }
            catch (Throwable throwable) {
                Object var12_10 = null;
                oracleCallableStatement.close();
                oracleCallableStatement = null;
                throw throwable;
            }
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            return l4;
        }
        int n = 0;
        long l5 = l;
        boolean bl = false;
        long l6 = 0L;
        while (!bl) {
            if (l2 > l3 - l5 + 1L) {
                return 0L;
            }
            n = 0;
            int n2 = (int)Math.min(32512L, l2 - (long)n);
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            long l7 = this.plsql_hasPattern(byArray2, l5);
            if (l7 == 0L) {
                return 0L;
            }
            l6 = l7;
            n += n2;
            l5 = l7 + (long)n2;
            boolean bl2 = true;
            while (bl2) {
                n2 = (int)Math.min(32512L, l2 - (long)n);
                byArray2 = new byte[n2];
                System.arraycopy(byArray, n, byArray2, 0, n2);
                l7 = this.plsql_hasPattern(byArray2, l5);
                if (l7 == l5) {
                    l5 += (long)n2;
                    if ((long)(n += n2) != l2) continue;
                    bl2 = false;
                    bl = true;
                    continue;
                }
                if (l7 == 0L) {
                    return 0L;
                }
                l5 = l7 - (long)n;
                bl2 = false;
            }
        }
        return l6;
    }

    public long plsql_isSubLob(BFILE bFILE, long l) throws SQLException {
        if (bFILE == null || l <= 0L) {
            return 0L;
        }
        long l2 = bFILE.length();
        long l3 = this.length();
        if (l2 == 0L || l2 > l3 - l + 1L || l > l3) {
            return 0L;
        }
        if (l2 <= 32512L) {
            byte[] byArray = new byte[(int)l2];
            bFILE.getBytes(1L, (int)l2, byArray);
            return this.plsql_hasPattern(byArray, l);
        }
        int n = 0;
        long l4 = l;
        boolean bl = false;
        long l5 = 0L;
        while (!bl) {
            if (l2 > l3 - l4 + 1L) {
                return 0L;
            }
            n = 0;
            int n2 = (int)Math.min(32512L, l2 - (long)n);
            byte[] byArray = new byte[n2];
            bFILE.getBytes(n + 1, n2, byArray);
            long l6 = this.plsql_hasPattern(byArray, l4);
            if (l6 == 0L) {
                return 0L;
            }
            l5 = l6;
            n += n2;
            l4 = l6 + (long)n2;
            boolean bl2 = true;
            while (bl2) {
                n2 = (int)Math.min(32512L, l2 - (long)n);
                byArray = new byte[n2];
                bFILE.getBytes(n + 1, n2, byArray);
                l6 = this.plsql_hasPattern(byArray, l4);
                if (l6 == l4) {
                    l4 += (long)n2;
                    if ((long)(n += n2) != l2) continue;
                    bl2 = false;
                    bl = true;
                    continue;
                }
                if (l6 == 0L) {
                    return 0L;
                }
                l4 = l6 - (long)n;
                bl2 = false;
            }
        }
        return l5;
    }

    public Object toJdbc() throws SQLException {
        return this;
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.io.InputStream") == 0 || string.compareTo("java.io.Reader") == 0;
    }

    public Reader characterStreamValue() throws SQLException {
        return new OracleConversionReader(this.m_conn.conversion, this.getBinaryStream(), 8);
    }

    public InputStream asciiStreamValue() throws SQLException {
        return new OracleConversionInputStream(this.m_conn.conversion, this.getBinaryStream(), 2);
    }

    public InputStream binaryStreamValue() throws SQLException {
        return this.getBinaryStream();
    }

    public Object makeJdbcArray(int n) {
        return new BFILE[n];
    }
}

