/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Dictionary;
import java.util.Vector;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.ArrayDataResultSet;
import oracle.jdbc.driver.ArrayLocatorResultSet;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeREF;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.Datum;
import oracle.sql.REF;
import oracle.sql.SQLName;

public class ArrayDescriptor {
    static boolean DEBUG;
    String m_name;
    SQLName m_sqlName;
    OracleTypeCOLLECTION m_handle;
    OracleConnection m_conn;
    public static final int TYPE_VARRAY = 3;
    public static final int TYPE_NESTED_TABLE = 2;

    public static ArrayDescriptor createDescriptor(String string, Connection connection) throws SQLException {
        SQLName sQLName;
        String string2;
        ArrayDescriptor arrayDescriptor;
        if (string == null || string.length() == 0 || connection == null) {
            DBError.check_error(60, "Invalid arguments");
        }
        if ((arrayDescriptor = (ArrayDescriptor)((OracleConnection)connection).getDescriptor(string2 = (sQLName = new SQLName(string, (OracleConnection)connection)).getName())) == null) {
            arrayDescriptor = new ArrayDescriptor(sQLName, connection);
        }
        ((OracleConnection)connection).putDescriptor(string2, arrayDescriptor);
        return arrayDescriptor;
    }

    public ArrayDescriptor(String string, Connection connection) throws SQLException {
        if (string == null || string.length() == 0 || connection == null) {
            DBError.check_error(60, "Invalid arguments");
        }
        this.m_conn = (OracleConnection)connection;
        this.m_sqlName = new SQLName(string, this.m_conn);
        this.m_name = this.m_sqlName.getName();
        try {
            OracleTypeADT oracleTypeADT = new OracleTypeADT(this.m_name, this.m_conn);
            this.m_conn.db_access.getOracleTypeADT(oracleTypeADT);
            oracleTypeADT.init(this.m_conn);
            this.m_handle = (OracleTypeCOLLECTION)oracleTypeADT.cleanup();
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            DBError.check_error(60, "Unable to resolve type: \"" + this.m_name + "\"");
            return;
        }
    }

    public ArrayDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        if (sQLName == null || connection == null) {
            DBError.check_error(60, "Invalid arguments");
        }
        this.m_conn = (OracleConnection)connection;
        this.m_sqlName = sQLName;
        this.m_name = this.m_sqlName.getName();
        try {
            OracleTypeADT oracleTypeADT = new OracleTypeADT(this.m_name, this.m_conn);
            this.m_conn.db_access.getOracleTypeADT(oracleTypeADT);
            oracleTypeADT.init(this.m_conn);
            this.m_handle = (OracleTypeCOLLECTION)oracleTypeADT.cleanup();
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            DBError.check_error(60, "Unable to resolve type: \"" + this.m_name + "\"");
            return;
        }
    }

    public ArrayDescriptor(SQLName sQLName, OracleTypeCOLLECTION oracleTypeCOLLECTION, Connection connection) throws SQLException {
        if (sQLName == null || oracleTypeCOLLECTION == null || connection == null) {
            DBError.check_error(60, "Invalid arguments");
        }
        this.m_conn = (OracleConnection)connection;
        this.m_sqlName = sQLName;
        this.m_name = this.m_sqlName.getName();
        this.m_handle = oracleTypeCOLLECTION;
    }

    public String getName() throws SQLException {
        return this.m_name;
    }

    public SQLName getSQLName() throws SQLException {
        return this.m_sqlName;
    }

    public int getBaseType() throws SQLException {
        return this.m_handle.elementType.getTypeCode();
    }

    public String getBaseName() throws SQLException {
        OracleType oracleType = this.m_handle.elementType;
        int n = oracleType.getTypeCode();
        switch (n) {
            case 12: {
                return "VARCHAR";
            }
            case 1: {
                return "CHAR";
            }
            case -2: {
                return "RAW";
            }
            case 6: {
                return "FLOAT";
            }
            case 2: {
                return "NUMBER";
            }
            case 8: {
                return "DOUBLE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 91: {
                return "DATE";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case -13: {
                return "BFILE";
            }
            case 2002: 
            case 2003: {
                return ((OracleTypeADT)oracleType).sql_name;
            }
            case 2006: {
                return "REF " + ((OracleTypeREF)oracleType).sql_name;
            }
        }
        return null;
    }

    public byte[] toBytes(Datum[] datumArray) throws SQLException {
        ARRAY aRRAY = new ARRAY(this, (Connection)this.m_conn, null);
        aRRAY.setDatumArray(datumArray);
        return this.m_handle.linearize(aRRAY);
    }

    public byte[] toBytes(Object[] objectArray) throws SQLException {
        Datum[] datumArray = this.toArray(objectArray);
        return this.toBytes(datumArray);
    }

    protected byte[] toBytesFromLocator(byte[] byArray) throws SQLException {
        ARRAY aRRAY = new ARRAY(this, (Connection)this.m_conn, null);
        aRRAY.setLocator(byArray);
        return this.m_handle.linearize(aRRAY);
    }

    public int length(byte[] byArray) throws SQLException {
        ARRAY aRRAY = (ARRAY)this.m_handle.unlinearize(byArray);
        int n = 0;
        if (aRRAY.getLocator() != null) {
            n = this.lengthFromLocator(aRRAY.getLocator());
        } else if (aRRAY.m_datumArray != null) {
            n = aRRAY.m_datumArray.length;
        } else {
            DBError.check_error(1, "Unable to get array length");
        }
        return n;
    }

    int lengthFromLocator(byte[] byArray) throws SQLException {
        int n = 0;
        ARRAY aRRAY = new ARRAY(this, (Connection)this.m_conn, null);
        aRRAY.setLocator(byArray);
        OraclePreparedStatement oraclePreparedStatement = null;
        OracleResultSet oracleResultSet = null;
        oraclePreparedStatement = (OraclePreparedStatement)this.m_conn.prepareStatement("SELECT count(*) FROM TABLE( CAST(? AS " + this.getName() + ") )");
        oraclePreparedStatement.setArray(1, aRRAY);
        oracleResultSet = (OracleResultSet)oraclePreparedStatement.executeQuery();
        if (oracleResultSet.next()) {
            n = oracleResultSet.getInt(1);
        } else {
            DBError.check_error(1, "Fail to access array storage table");
        }
        oracleResultSet.close();
        oraclePreparedStatement.close();
        return n;
    }

    public Datum[] toArray(byte[] byArray) throws SQLException {
        if (byArray == null) {
            return null;
        }
        ARRAY aRRAY = (ARRAY)this.m_handle.unlinearize(byArray);
        if (aRRAY.getLocator() != null) {
            return this.toArrayFromLocator(aRRAY.getLocator());
        }
        return aRRAY.m_datumArray;
    }

    protected Datum[] toArrayFromLocator(byte[] byArray) throws SQLException {
        Object[] objectArray;
        ArrayLocatorResultSet arrayLocatorResultSet = new ArrayLocatorResultSet(this.m_conn, this, byArray, this.m_conn.getTypeMap());
        Vector<Object[]> vector = new Vector<Object[]>();
        while (((OracleResultSet)arrayLocatorResultSet).next()) {
            objectArray = ((OracleResultSet)arrayLocatorResultSet).getOracleObject(2);
            vector.addElement(objectArray);
            if (!DEBUG) continue;
            System.out.println("toArrayFromLocator::elem=" + objectArray);
        }
        ((OracleResultSet)arrayLocatorResultSet).close();
        objectArray = new Datum[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Datum[] toArray(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        OracleType oracleType = this.m_handle.elementType;
        return oracleType.toDatumArray(object, this.m_conn);
    }

    private OracleType getElementType() throws SQLException {
        return this.m_handle.elementType;
    }

    public OracleConnection getConnection() {
        return this.m_conn;
    }

    public OracleTypeCOLLECTION getOracleTypeCOLLECTION() {
        return this.m_handle;
    }

    public ResultSet toResultSet(Datum[] datumArray, Dictionary dictionary) throws SQLException {
        if (DEBUG) {
            System.out.println("ArrayDescriptor::toResultSet(Datum[], map)");
        }
        return new ArrayDataResultSet(this.m_conn, datumArray, dictionary);
    }

    public ResultSet toResultSet(Datum[] datumArray, long l, int n, Dictionary dictionary) throws SQLException {
        if (DEBUG) {
            System.out.println("ArrayDescriptor::toResultSet(Datum[], map)");
        }
        return new ArrayDataResultSet(this.m_conn, datumArray, l, n, dictionary);
    }

    public ResultSet toResultSet(byte[] byArray, Dictionary dictionary) throws SQLException {
        if (DEBUG) {
            System.out.println("ArrayDescriptor::toResultSet(byte[], map)");
        }
        if (byArray == null) {
            return null;
        }
        ARRAY aRRAY = (ARRAY)this.m_handle.unlinearize(byArray);
        if (aRRAY.getLocator() != null) {
            return this.toResultSetFromLocator(aRRAY.getLocator(), dictionary);
        }
        return this.toResultSet(aRRAY.m_datumArray, dictionary);
    }

    public ResultSet toResultSet(byte[] byArray, long l, int n, Dictionary dictionary) throws SQLException {
        if (DEBUG) {
            System.out.println("ArrayDescriptor::toResultSet(byte[], map)");
        }
        if (byArray == null) {
            return null;
        }
        ARRAY aRRAY = (ARRAY)this.m_handle.unlinearize(byArray);
        if (aRRAY.getLocator() != null) {
            return this.toResultSetFromLocator(aRRAY.getLocator(), l, n, dictionary);
        }
        return this.toResultSet(aRRAY.m_datumArray, l, n, dictionary);
    }

    public ResultSet toResultSetFromLocator(byte[] byArray, Dictionary dictionary) throws SQLException {
        if (DEBUG) {
            System.out.println("ArrayDescriptor::toResultSetFromLocator()");
        }
        return new ArrayLocatorResultSet(this.m_conn, this, byArray, dictionary);
    }

    public ResultSet toResultSetFromLocator(byte[] byArray, long l, int n, Dictionary dictionary) throws SQLException {
        if (DEBUG) {
            System.out.println("ArrayDescriptor::toResultSetFromLocator()");
        }
        return new ArrayLocatorResultSet(this.m_conn, this, byArray, l, n, dictionary);
    }

    Object[] makeJavaArray(int n) throws SQLException {
        int n2 = this.getBaseType();
        switch (n2) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return new BigDecimal[n];
            }
            case 1: 
            case 12: {
                return new String[n];
            }
            case 91: 
            case 92: 
            case 93: {
                return new Timestamp[n];
            }
            case 2002: {
                return new Object[n];
            }
            case -13: {
                return new BFILE[n];
            }
            case 2004: {
                return new BLOB[n];
            }
            case 2005: {
                return new CLOB[n];
            }
            case -3: 
            case -2: {
                return new byte[n][];
            }
            case 2006: {
                return new REF[n];
            }
            case 2003: {
                return new Object[n][];
            }
        }
        DBError.check_error(1, "makeJavaArray doesn't support type " + n2);
        return null;
    }

    public int getArrayType() throws SQLException {
        return this.m_handle.usercode;
    }

    public long getMaxLength() throws SQLException {
        if (this.getArrayType() == 3) {
            return this.m_handle.length;
        }
        return 0L;
    }
}

