/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Dictionary;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc2.Array;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.STRUCT;

public class ARRAY
extends Datum
implements Array {
    static boolean DEBUG;
    ArrayDescriptor m_descriptor;
    OracleConnection m_conn;
    Datum[] m_datumArray;
    private byte[] m_locator;

    public ARRAY(ArrayDescriptor arrayDescriptor, Connection connection, Object object) throws SQLException {
        if (arrayDescriptor != null) {
            this.m_descriptor = arrayDescriptor;
        } else {
            DBError.check_error(61, "ARRAY");
        }
        if (connection != null) {
            this.m_conn = (OracleConnection)connection;
        } else {
            DBError.check_error(8, "Connection is null");
        }
        this.m_datumArray = object != null ? this.m_descriptor.toArray(object) : new Datum[0];
        this.setShareBytes(this.m_descriptor.toBytes(this.m_datumArray));
    }

    public ARRAY(ArrayDescriptor arrayDescriptor, Connection connection, byte[] byArray) throws SQLException {
        super(byArray);
        if (connection != null) {
            this.m_conn = (OracleConnection)connection;
        } else {
            DBError.check_error(8, "Connection is null");
        }
        this.m_descriptor = arrayDescriptor;
        this.m_datumArray = null;
        this.m_locator = null;
    }

    public String getBaseTypeName() throws SQLException {
        return this.m_descriptor.getBaseName();
    }

    public int getBaseType() throws SQLException {
        return this.m_descriptor.getBaseType();
    }

    public Object getArray() throws SQLException {
        return this.getArray(1L, this.length(), this.getMap());
    }

    public Object getArray(Dictionary dictionary) throws SQLException {
        return this.getArray(1L, this.length(), dictionary);
    }

    public Object getArray(long l, int n) throws SQLException {
        return this.getArray(l, n, this.getMap());
    }

    public Object getArray(long l, int n, Dictionary dictionary) throws SQLException {
        if (l < 1L || n < 0) {
            DBError.check_error(68, "getArray()");
        }
        Object[] objectArray = null;
        int n2 = (int)l - 1;
        if (this.getOracleArray() != null) {
            int n3 = Math.min(this.m_datumArray.length - n2, n);
            if (n3 <= 0) {
                objectArray = this.m_descriptor.makeJavaArray(0);
            } else {
                objectArray = this.m_descriptor.makeJavaArray(n3);
                int n4 = 0;
                while (n4 < n3) {
                    objectArray[n4] = this.m_datumArray[n4 + n2] != null ? (this.m_datumArray[n4] instanceof STRUCT ? ((STRUCT)this.m_datumArray[n4 + n2]).toJdbc(dictionary) : this.m_datumArray[n4 + n2].toJdbc()) : null;
                    ++n4;
                }
            }
        }
        return objectArray;
    }

    public ResultSet getResultSet() throws SQLException {
        return this.getResultSet(this.m_conn.getTypeMap());
    }

    public ResultSet getResultSet(Dictionary dictionary) throws SQLException {
        ResultSet resultSet = null;
        if (this.m_datumArray != null) {
            resultSet = this.m_descriptor.toResultSet(this.m_datumArray, dictionary);
        } else if (this.m_locator != null) {
            resultSet = this.m_descriptor.toResultSetFromLocator(this.m_locator, dictionary);
        } else if (this.shareBytes() != null) {
            resultSet = this.m_descriptor.toResultSet(this.shareBytes(), dictionary);
        }
        if (resultSet == null) {
            DBError.check_error(1, "Unable to create array ResultSet");
        }
        return resultSet;
    }

    public ResultSet getResultSet(long l, int n) throws SQLException {
        return this.getResultSet(l, n, this.m_conn.getTypeMap());
    }

    public ResultSet getResultSet(long l, int n, Dictionary dictionary) throws SQLException {
        if (l < 1L || n < 0) {
            DBError.check_error(68, "getResultSet()");
        }
        ResultSet resultSet = null;
        if (this.m_datumArray != null) {
            resultSet = this.m_descriptor.toResultSet(this.m_datumArray, l, n, dictionary);
        } else if (this.m_locator != null) {
            resultSet = this.m_descriptor.toResultSetFromLocator(this.m_locator, l, n, dictionary);
        } else if (this.shareBytes() != null) {
            resultSet = this.m_descriptor.toResultSet(this.shareBytes(), l, n, dictionary);
        }
        if (resultSet == null) {
            DBError.check_error(1, "Unable to create array ResultSet");
        }
        return resultSet;
    }

    public Datum[] getOracleArray() throws SQLException {
        if (this.m_datumArray == null) {
            if (this.m_locator != null) {
                this.m_datumArray = this.m_descriptor.toArrayFromLocator(this.m_locator);
            } else if (this.shareBytes() != null) {
                this.m_datumArray = this.m_descriptor.toArray(this.shareBytes());
            } else {
                DBError.check_error(1, "Array is in inconsistent status");
            }
        }
        return (Datum[])this.m_datumArray.clone();
    }

    public int length() throws SQLException {
        if (this.m_datumArray != null) {
            return this.m_datumArray.length;
        }
        if (this.m_locator != null) {
            return this.m_descriptor.lengthFromLocator(this.m_locator);
        }
        if (this.shareBytes() != null) {
            return this.m_descriptor.length(this.shareBytes());
        }
        DBError.check_error(1, "Array is in inconsistent status");
        return -1;
    }

    public Object getOracleArray(long l, int n) throws SQLException {
        if (l < 1L || n < 0) {
            DBError.check_error(68, "getOracleArray()");
        }
        Datum[] datumArray = null;
        int n2 = (int)l - 1;
        if (this.getOracleArray() != null) {
            int n3 = Math.min(this.m_datumArray.length - n2, n);
            if (n3 <= 0) {
                datumArray = new Datum[]{};
            } else {
                datumArray = new Datum[n3];
                int n4 = 0;
                while (n4 < n3) {
                    datumArray[n4] = this.m_datumArray[n4 + n2];
                    ++n4;
                }
            }
        }
        return datumArray;
    }

    public String getSQLTypeName() throws SQLException {
        if (this.m_descriptor != null) {
            return this.m_descriptor.getName();
        }
        DBError.check_error(61, "ARRAY");
        return null;
    }

    public Dictionary getMap() throws SQLException {
        return this.getConnection().getTypeMap();
    }

    public ArrayDescriptor getDescriptor() throws SQLException {
        return this.m_descriptor;
    }

    public OracleConnection getConnection() throws SQLException {
        return this.m_conn;
    }

    public byte[] toBytes() throws SQLException {
        if (this.shareBytes() == null) {
            if (this.m_locator != null) {
                this.setShareBytes(this.m_descriptor.toBytesFromLocator(this.m_locator));
            } else if (this.m_datumArray != null) {
                this.setShareBytes(this.m_descriptor.toBytes(this.m_datumArray));
            }
        }
        return this.getBytes();
    }

    public void setDatumArray(Datum[] datumArray) {
        this.m_datumArray = datumArray;
        this.setShareBytes(null);
        this.setLocator(null);
    }

    public void setLocator(byte[] byArray) {
        if (byArray != null && byArray.length != 0) {
            this.m_locator = byArray;
        }
    }

    public byte[] getLocator() {
        return this.m_locator;
    }

    public boolean hasDataSeg() {
        return this.m_locator == null;
    }

    public Object toJdbc() throws SQLException {
        return this;
    }

    public boolean isConvertibleTo(Class clazz) {
        return false;
    }

    public Object makeJdbcArray(int n) {
        return new Object[n][];
    }
}

