/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.util.Vector;
import oracle.net.TNSAddress.Description;
import oracle.net.TNSAddress.SchemaObjectFactoryInterface;
import oracle.net.nt.ConnOption;
import oracle.net.nt.ConnStrategy;
import oracle.net.resolver.NavAddress;
import oracle.net.resolver.NavAddressList;
import oracle.net.resolver.NavDescriptionList;
import oracle.net.resolver.NavSchemaObject;

public class NavDescription
extends Description
implements NavSchemaObject {
    private Vector activeChildren = new Vector(1, 10);
    private int descProcessed;
    private boolean done = false;

    public NavDescription(SchemaObjectFactoryInterface schemaObjectFactoryInterface) {
        super(schemaObjectFactoryInterface);
    }

    public void navigate(ConnStrategy connStrategy, StringBuffer stringBuffer) {
        stringBuffer.append("(DESCRIPTION=");
        if (this.sourceRoute) {
            if (!this.backwardCompatibilityCase(this.children, connStrategy)) {
                this.activeChildren = this.children;
                ((NavSchemaObject)this.activeChildren.elementAt(0)).navigate(connStrategy, stringBuffer);
                int n = 1;
                while (n < this.activeChildren.size()) {
                    ((NavSchemaObject)this.activeChildren.elementAt(n)).addToString(connStrategy);
                    ++n;
                }
            } else {
                this.setConnectionOption(connStrategy, stringBuffer);
            }
            this.closeNVPair(connStrategy);
        } else {
            this.activeChildren = NavDescriptionList.setActiveChildren(this.children, this.failover, this.loadBalance);
            int n = 0;
            while (n < this.activeChildren.size()) {
                ((NavSchemaObject)this.activeChildren.elementAt(n)).navigate(connStrategy, stringBuffer);
                this.closeNVPair(connStrategy);
                ++n;
            }
        }
        this.done = true;
    }

    public void closeNVPair(ConnStrategy connStrategy) {
        int n = connStrategy.cOpts.size() - 1;
        while (n >= 0 && !((ConnOption)connStrategy.cOpts.elementAt((int)n)).done) {
            ConnOption connOption = (ConnOption)connStrategy.cOpts.elementAt(n);
            if (this.sourceRoute) {
                connOption.conn_data.append("(SOURCE_ROUTE=yes)");
            }
            connOption.conn_data.append("(CONNECT_DATA=");
            connOption.conn_data.append("(CID=(PROGRAM=)(HOST=__jdbc__)(USER=))");
            connOption.conn_data.append(this.connectData);
            connOption.conn_data.append(")");
            if (this.SID != null) {
                connOption.sid = this.SID;
            }
            if (this.serviceName != null) {
                connOption.service_name = this.serviceName;
            }
            if (this.instanceName != null) {
                connOption.instance_name = this.instanceName;
            }
            connOption.conn_data.append(")");
            connOption.done = true;
            --n;
        }
    }

    public void addToString(ConnStrategy connStrategy) {
    }

    private boolean backwardCompatibilityCase(Vector vector, ConnStrategy connStrategy) {
        if (vector.size() == 1 && ((NavSchemaObject)vector.elementAt(0)).isA() == 1 && !((NavAddressList)vector.elementAt((int)0)).sourceRoute) {
            NavAddressList navAddressList = (NavAddressList)vector.elementAt(0);
            int n = navAddressList.getChildrenSize();
            if (n == 0) {
                return false;
            }
            int n2 = 0;
            while (n2 < n) {
                if (navAddressList.getChildrenType(n2) != 0) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    private void setConnectionOption(ConnStrategy connStrategy, StringBuffer stringBuffer) {
        stringBuffer.append("(ADDRESS_LIST=");
        NavAddressList navAddressList = (NavAddressList)this.children.elementAt(0);
        NavAddress navAddress = navAddressList.getChild(0);
        int n = navAddressList.getChildrenSize();
        navAddress.navigate(connStrategy, stringBuffer);
        int n2 = 1;
        while (n2 < n) {
            navAddressList.getChild(n2).addToString(connStrategy);
            ++n2;
        }
        ((ConnOption)connStrategy.cOpts.elementAt((int)0)).conn_data.append(")");
    }
}

