/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import oracle.net.TNSAddress.SOException;
import oracle.net.jndi.JndiAttrs;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.ConnOption;
import oracle.net.nt.ConnStrategy;
import oracle.net.resolver.NavSchemaObjectFactory;
import oracle.net.resolver.NavServiceAlias;

public class AddrResolution {
    private ConnStrategy cs;
    private Properties up;
    private static final String default_proxy_rules = "__jdbc__";
    private static final String service_alias_name = "ora-net-service-alias";
    private static final String service_attr_name = "ora-desc-string";
    private static final int length_of_alias_prefix = 6;
    private JndiAttrs ja;
    private boolean newSyntax = true;
    public boolean jndi = false;
    public boolean connection_revised = false;
    private String TNSAddress;

    public AddrResolution(String string, Properties properties) throws NetException {
        String[] stringArray = new String[1];
        this.up = properties;
        this.TNSAddress = string;
        if (((Hashtable)this.up).containsKey("java.naming.provider.url") || string.startsWith("ldap:")) {
            if (string.startsWith("ldap:")) {
                ((Hashtable)this.up).put("java.naming.provider.url", string.substring(string.indexOf("ldap:"), string.lastIndexOf(47)));
                this.TNSAddress = string.substring(string.lastIndexOf(47) + 1, string.length());
            }
            this.ja = new JndiAttrs(this.up);
            this.jndi = true;
            stringArray[0] = service_attr_name;
            Vector vector = this.ja.getAttrs(this.TNSAddress, stringArray);
            this.TNSAddress = (String)vector.firstElement();
            this.connection_revised = true;
        }
        if (this.up.getProperty("oracle.net.oldSyntax") == "YES") {
            this.newSyntax = false;
        }
    }

    public ConnOption resolveAndExecute(String string) throws NetException, IOException {
        this.cs = new ConnStrategy();
        if (string.indexOf(58) != -1 && string.indexOf(41) == -1) {
            this.resolveSimple(string);
        } else if (this.newSyntax) {
            this.resolveAddrTree(string);
        } else {
            this.resolveAddr(string);
        }
        if (!this.cs.optAvailable()) {
            return this.cs.execute();
        }
        return this.cs.getOption();
    }

    private void resolveSimple(String string) throws NetException {
        ConnOption connOption = new ConnOption();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        n = string.indexOf(58);
        if (n == -1 || (n2 = string.indexOf(58, n + 1)) == -1) {
            throw new NetException(115);
        }
        n3 = string.indexOf(58, n2 + 1);
        if (n3 != -1) {
            throw new NetException(115);
        }
        try {
            connOption.host = string.substring(0, n);
            connOption.port = Integer.parseInt(string.substring(n + 1, n2));
            connOption.addr = "(ADDRESS=(PROTOCOL=tcp)(HOST=" + connOption.host + ")(PORT=" + connOption.port + "))";
            connOption.sid = string.substring(n2 + 1, string.length());
            String string2 = "(DESCRIPTION=(CONNECT_DATA=(SID=" + connOption.sid + ")(CID=(PROGRAM=)(HOST=__jdbc__)(USER=oracle)))" + "(ADDRESS_LIST=(ADDRESS=" + "(PROTOCOL=tcp)(HOST=" + connOption.host + ")(PORT=" + connOption.port + "))))";
            connOption.protocol = "TCP";
            connOption.conn_data = new StringBuffer(string2);
            this.cs.addOption(connOption);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            throw new NetException(116);
        }
    }

    private void resolveAddr(String string) throws NetException {
        Object object;
        if (string.startsWith("alias=")) {
            object = string;
            string = ((String)object).substring(((String)object).indexOf("alias=") + 6, ((String)object).length());
        }
        object = new ConnOption();
        NVFactory nVFactory = new NVFactory();
        NVNavigator nVNavigator = new NVNavigator();
        nVNavigator.findNVPairRecurse(nVFactory.createNVPair(string), "CID");
        NVPair nVPair = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(string), "address");
        NVPair nVPair2 = nVNavigator.findNVPair(nVPair, "protocol");
        if (nVPair2 == null) {
            throw new NetException(100);
        }
        ((ConnOption)object).protocol = nVPair2.getAtom();
        if (!(((ConnOption)object).protocol.equals("TCP") || ((ConnOption)object).protocol.equals("tcp") || ((ConnOption)object).protocol.equals("SSL") || ((ConnOption)object).protocol.equals("ssl") || ((ConnOption)object).protocol.equals("ANO") || ((ConnOption)object).protocol.equals("ano"))) {
            throw new NetException(102);
        }
        nVPair2 = nVNavigator.findNVPair(nVPair, "Host");
        if (nVPair2 == null) {
            throw new NetException(103);
        }
        ((ConnOption)object).host = nVPair2.getAtom();
        nVPair2 = nVNavigator.findNVPair(nVPair, "Port");
        if (nVPair2 == null) {
            throw new NetException(104);
        }
        ((ConnOption)object).port = Integer.parseInt(nVPair2.getAtom());
        nVPair2 = nVNavigator.findNVPair(nVPair, "sduSize");
        if (nVPair2 != null) {
            ((ConnOption)object).sdu = Integer.parseInt(nVPair2.getAtom());
        }
        if ((nVPair2 = nVNavigator.findNVPair(nVPair, "tduSize")) != null) {
            ((ConnOption)object).tdu = Integer.parseInt(nVPair2.getAtom());
        }
        NVPair nVPair3 = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(string), "connect_data");
        StringBuffer stringBuffer = new StringBuffer(string);
        ((ConnOption)object).conn_data = nVPair3 != null ? this.insertCID(string) : stringBuffer;
        ((ConnOption)object).addr = "(ADDRESS=(PROTOCOL=tcp)(HOST=" + ((ConnOption)object).host + ")(PORT=" + ((ConnOption)object).port + "))";
        this.cs.addOption((ConnOption)object);
    }

    private void resolveAddrTree(String string) throws NetException {
        NavSchemaObjectFactory navSchemaObjectFactory = new NavSchemaObjectFactory();
        NavServiceAlias navServiceAlias = (NavServiceAlias)navSchemaObjectFactory.create(4);
        try {
            String string2 = string.startsWith("alias=") ? string : "alias=" + string;
            navServiceAlias.initFromString(string2);
        }
        catch (NLException nLException) {
            throw new NetException(501);
        }
        catch (SOException sOException) {
            sOException.printStackTrace();
            throw new NetException(502, sOException.getMessage());
        }
        navServiceAlias.navigate(this.cs, null);
    }

    private StringBuffer insertCID(String string) throws NetException {
        NVFactory nVFactory = new NVFactory();
        NVNavigator nVNavigator = new NVNavigator();
        StringBuffer stringBuffer = new StringBuffer(2048);
        nVNavigator.findNVPairRecurse(nVFactory.createNVPair(string), "description");
        NVPair nVPair = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(string), "address_list");
        NVPair nVPair2 = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(string), "address");
        NVPair nVPair3 = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(string), "connect_data");
        NVPair nVPair4 = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(string), "source_route");
        NVPair nVPair5 = null;
        NVPair nVPair6 = null;
        if (nVPair3 == null) {
            throw new NetException(105);
        }
        nVPair5 = nVNavigator.findNVPair(nVPair3, "SID");
        nVPair6 = nVNavigator.findNVPair(nVPair3, "CID");
        if (nVPair5 == null) {
            throw new NetException(106);
        }
        stringBuffer.append("(DESCRIPTION=(ADDRESS_LIST=");
        if (nVPair != null && nVPair.getListSize() > 0) {
            int n = 0;
            while (n < nVPair.getListSize()) {
                NVPair nVPair7 = nVPair.getListElement(n);
                stringBuffer.append(nVPair7.toString());
                ++n;
            }
        } else if (nVPair2 != null) {
            stringBuffer.append(nVPair2.toString());
        } else {
            throw new NetException(107);
        }
        stringBuffer.append(")");
        stringBuffer.append("(CONNECT_DATA=" + nVPair5.toString() + "(CID=(PROGRAM=)(HOST=__jdbc__)(USER=)))");
        if (nVPair4 != null) {
            stringBuffer.append(nVPair4.toString());
        }
        stringBuffer.append(")");
        return stringBuffer;
    }

    public String getConn() {
        return this.TNSAddress;
    }

    public Properties getUp() {
        return this.up;
    }

    public JndiAttrs getJndi() {
        return this.ja;
    }
}

