/*
 * Decompiled with CFR 0.152.
 */
package oracle.jpub.runtime;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.driver.OracleConnection;
import oracle.jpub.runtime.Util;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.CustomDatumFactory;
import oracle.sql.Datum;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class MutableStruct {
    int length;
    STRUCT pickled;
    Datum[] datums;
    Object[] attributes;
    CustomDatumFactory[] factories;
    int[] sqlTypes;
    boolean pickledCorrect;

    public MutableStruct(STRUCT sTRUCT, int[] nArray, CustomDatumFactory[] customDatumFactoryArray) {
        this.length = customDatumFactoryArray.length;
        this.pickled = sTRUCT;
        this.factories = customDatumFactoryArray;
        this.sqlTypes = nArray;
        this.pickledCorrect = true;
    }

    public MutableStruct(Object[] objectArray, int[] nArray, CustomDatumFactory[] customDatumFactoryArray) {
        this.length = customDatumFactoryArray.length;
        this.attributes = objectArray;
        this.factories = customDatumFactoryArray;
        this.pickledCorrect = false;
    }

    public Datum toDatum(OracleConnection oracleConnection, String string) throws SQLException {
        if (!this.pickledCorrect) {
            this.pickled = new STRUCT(new StructDescriptor(string, (Connection)oracleConnection), (Connection)oracleConnection, this.getDatumAttributes(oracleConnection));
            this.pickledCorrect = true;
        }
        return this.pickled;
    }

    public Object getAttribute(int n) throws SQLException {
        Object object;
        block2: {
            block5: {
                boolean bl;
                block4: {
                    CustomDatumFactory customDatumFactory;
                    Datum datum;
                    block3: {
                        object = this.getLazyAttributes()[n];
                        if (object != null) break block2;
                        datum = this.getLazyDatums()[n];
                        this.attributes[n] = object = Util.convertToObject(datum, this.sqlTypes[n], this.factories[n]);
                        customDatumFactory = this.factories[n];
                        if (datum != null) break block3;
                        bl = false;
                        break block4;
                    }
                    if (datum instanceof BFILE || datum instanceof BLOB || datum instanceof CLOB || datum instanceof STRUCT && customDatumFactory != null) break block5;
                    if (!(datum instanceof ARRAY)) break block2;
                    if (customDatumFactory != null) break block5;
                    bl = false;
                }
                if (!bl) break block2;
            }
            this.resetDatum(n);
        }
        return object;
    }

    public Object getOracleAttribute(int n) throws SQLException {
        Object object;
        block6: {
            block2: {
                block5: {
                    boolean bl;
                    block4: {
                        CustomDatumFactory customDatumFactory;
                        Datum datum;
                        block3: {
                            if (this.factories[n] != null) break block2;
                            object = this.getDatumAttribute(n, null);
                            datum = this.getLazyDatums()[n];
                            customDatumFactory = this.factories[n];
                            if (datum != null) break block3;
                            bl = false;
                            break block4;
                        }
                        if (datum instanceof BFILE || datum instanceof BLOB || datum instanceof CLOB || datum instanceof STRUCT && customDatumFactory != null) break block5;
                        if (!(datum instanceof ARRAY)) break block6;
                        if (customDatumFactory != null) break block5;
                        bl = false;
                    }
                    if (!bl) break block6;
                }
                this.pickledCorrect = false;
                break block6;
            }
            object = this.getAttribute(n);
        }
        return object;
    }

    public Object[] getAttributes() throws SQLException {
        int n = 0;
        while (n < this.length) {
            this.getAttribute(n);
            ++n;
        }
        return this.attributes;
    }

    public Object[] getOracleAttributes() throws SQLException {
        Object[] objectArray = new Object[this.length];
        int n = 0;
        while (n < this.length) {
            objectArray[n] = this.getOracleAttribute(n);
            ++n;
        }
        return objectArray;
    }

    public void setAttribute(int n, Object object) throws SQLException {
        if (object == null) {
            this.getLazyDatums();
        }
        this.resetDatum(n);
        this.getLazyAttributes()[n] = object;
    }

    public void setDoubleAttribute(int n, double d) throws SQLException {
        this.setAttribute(n, new Double(d));
    }

    public void setFloatAttribute(int n, float f) throws SQLException {
        this.setAttribute(n, new Float(f));
    }

    public void setIntAttribute(int n, int n2) throws SQLException {
        this.setAttribute(n, new Integer(n2));
    }

    public void setOracleAttribute(int n, Object object) throws SQLException {
        if (this.factories[n] == null) {
            this.setDatumAttribute(n, (Datum)object);
            return;
        }
        this.setAttribute(n, object);
    }

    Datum getDatumAttribute(int n, OracleConnection oracleConnection) throws SQLException {
        Datum datum = this.getLazyDatums()[n];
        if (datum == null) {
            Object object = this.getLazyAttributes()[n];
            this.datums[n] = datum = Util.convertToOracle(object, oracleConnection);
        }
        return datum;
    }

    void setDatumAttribute(int n, Datum datum) throws SQLException {
        this.resetAttribute(n);
        this.getLazyDatums()[n] = datum;
        this.pickledCorrect = false;
    }

    Datum[] getDatumAttributes(OracleConnection oracleConnection) throws SQLException {
        int n = 0;
        while (n < this.length) {
            this.getDatumAttribute(n, oracleConnection);
            ++n;
        }
        return (Datum[])this.datums.clone();
    }

    void resetAttribute(int n) throws SQLException {
        if (this.attributes != null) {
            this.attributes[n] = null;
        }
    }

    void resetDatum(int n) throws SQLException {
        if (this.datums != null) {
            this.datums[n] = null;
        }
        this.pickledCorrect = false;
    }

    Object[] getLazyAttributes() {
        if (this.attributes == null) {
            this.attributes = new Object[this.length];
        }
        return this.attributes;
    }

    Datum[] getLazyDatums() throws SQLException {
        if (this.datums == null) {
            if (this.pickled != null) {
                this.datums = this.pickled.getOracleAttributes();
                this.pickledCorrect = true;
                if (this.attributes != null) {
                    int n = 0;
                    while (n < this.length) {
                        if (this.attributes[n] != null) {
                            this.datums[n] = null;
                            this.pickledCorrect = false;
                        }
                        ++n;
                    }
                }
            } else {
                this.datums = new Datum[this.length];
            }
        }
        return this.datums;
    }
}

