/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.xa.OracleXAException;
import oracle.jdbc.xa.OracleXid;

public class OracleXAResource
extends oracle.jdbc.xa.OracleXAResource {
    public OracleXAResource(Connection connection) throws XAException {
        super(connection);
    }

    public void start(Xid xid, int n) throws XAException {
        int n2 = -1;
        CallableStatement callableStatement = null;
        this.trace("OracleXAResource.start():start");
        if (n != 0 && n != 0x8000000 && n != 0x200000) {
            this.trace("OracleXAResource.start(): XAER_INVAL; invalid flag");
            throw new XAException(-5);
        }
        try {
            try {
                this.setSQLXAErrorFlag(false);
                callableStatement = this.m_conn.prepareCall(" begin ? := JAVA_XA.xa_start(?,?,?,?); end; ");
                callableStatement.registerOutParameter(1, -2);
                byte[] byArray = OracleXAResource.getSerializedBytes(xid);
                callableStatement.setBytes(2, byArray);
                callableStatement.setInt(3, this.m_timeout);
                callableStatement.setInt(4, n);
                callableStatement.registerOutParameter(5, 2);
                callableStatement.execute();
                byte[] byArray2 = callableStatement.getBytes(1);
                ((OracleXid)xid).setTxContext(byArray2);
                n2 = callableStatement.getInt(5);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
            throw throwable;
        }
        try {
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
        catch (SQLException sQLException) {}
        callableStatement = null;
        this.trace("Return Status of xa_start is " + n2);
        this.checkError(n2);
        this.trace("OracleXAResource.start():end");
    }

    public void end(Xid xid, int n) throws XAException {
        int n2 = -1;
        CallableStatement callableStatement = null;
        this.trace("OracleXAResource.end(xid, int):start");
        if (n != 0x2000000 && n != 0x4000000 && n != 0x20000000) {
            this.trace("OracleXAResource.end(xid, int): XAER_INVAL; invalid flag");
            throw new XAException(-5);
        }
        try {
            try {
                this.setSQLXAErrorFlag(false);
                callableStatement = this.m_conn.prepareCall(" begin ? := JAVA_XA.xa_end(?,?); end; ");
                callableStatement.registerOutParameter(1, 2);
                byte[] byArray = OracleXAResource.getSerializedBytes(xid);
                callableStatement.setBytes(2, byArray);
                callableStatement.setInt(3, n);
                callableStatement.execute();
                n2 = callableStatement.getInt(1);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
            throw throwable;
        }
        try {
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
        catch (SQLException sQLException) {}
        callableStatement = null;
        this.trace("Return Status of xa_end is " + n2);
        this.setSQLXAErrorFlag(true);
        this.checkError(n2);
        this.trace("OracleXAResource.end(xid, int):end");
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        int n = -1;
        int n2 = 0;
        CallableStatement callableStatement = null;
        this.trace("OracleXAResource.commit(xid, bool):start");
        int n3 = bl ? 1 : 0;
        try {
            try {
                this.setSQLXAErrorFlag(false);
                callableStatement = this.m_conn.prepareCall(" begin ? := JAVA_XA.xa_commit (?,?,?); end; ");
                callableStatement.registerOutParameter(1, 2);
                byte[] byArray = OracleXAResource.getSerializedBytes(xid);
                callableStatement.setBytes(2, byArray);
                callableStatement.setInt(3, n3);
                callableStatement.registerOutParameter(4, 2);
                callableStatement.execute();
                n = callableStatement.getInt(1);
                n2 = callableStatement.getInt(4);
                ((OracleXid)xid).setState(n2);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
            throw throwable;
        }
        try {
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
        catch (SQLException sQLException) {}
        callableStatement = null;
        this.setSQLXAErrorFlag(true);
        this.trace("Return Status of xa_commit is " + n);
        this.checkError(n);
        this.trace("OracleXAResource.commit(xid, bool):end");
    }

    public int prepare(Xid xid) throws XAException {
        int n = 0;
        int n2 = 0;
        CallableStatement callableStatement = null;
        this.trace("OracleXAResource.prepare():start");
        try {
            try {
                this.setSQLXAErrorFlag(false);
                callableStatement = this.m_conn.prepareCall(" begin ? := JAVA_XA.xa_prepare (?,?); end; ");
                callableStatement.registerOutParameter(1, 2);
                byte[] byArray = OracleXAResource.getSerializedBytes(xid);
                callableStatement.setBytes(2, byArray);
                callableStatement.registerOutParameter(3, 2);
                callableStatement.execute();
                n = callableStatement.getInt(1);
                n2 = callableStatement.getInt(3);
                ((OracleXid)xid).setState(n2);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
            throw throwable;
        }
        try {
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
        catch (SQLException sQLException) {}
        callableStatement = null;
        this.trace("Return Status of xa_prepare is " + n);
        this.setSQLXAErrorFlag(true);
        int n3 = n == 0 ? 0 : OracleXAException.errorConvert(n);
        this.trace("x_e is " + n3);
        if (n3 != 0 && n3 != 3) {
            throw new OracleXAException(n);
        }
        this.trace("OracleXAResource.prepare():end");
        return n3;
    }

    public void forget(Xid xid) throws XAException {
        int n = 0;
        int n2 = 0;
        CallableStatement callableStatement = null;
        this.trace("OracleXAResource.forget():start");
        try {
            try {
                this.setSQLXAErrorFlag(false);
                callableStatement = this.m_conn.prepareCall(" begin ? := JAVA_XA.xa_forget (?,?); end; ");
                callableStatement.registerOutParameter(1, 2);
                byte[] byArray = OracleXAResource.getSerializedBytes(xid);
                callableStatement.setBytes(2, byArray);
                callableStatement.registerOutParameter(3, 2);
                callableStatement.execute();
                n = callableStatement.getInt(1);
                n2 = callableStatement.getInt(3);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
            throw throwable;
        }
        try {
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
        catch (SQLException sQLException) {}
        callableStatement = null;
        this.trace("Return Status of xa_forget is " + n);
        this.setSQLXAErrorFlag(true);
        this.checkError(n);
        ((OracleXid)xid).setState(n2);
        this.trace("OracleXAResource.forget():end");
    }

    public void rollback(Xid xid) throws XAException {
        int n = 0;
        int n2 = 0;
        CallableStatement callableStatement = null;
        this.trace("OracleXAResource.rollback():start");
        try {
            try {
                this.setSQLXAErrorFlag(false);
                callableStatement = this.m_conn.prepareCall(" begin ? := JAVA_XA.xa_rollback (?,?); end; ");
                callableStatement.registerOutParameter(1, 2);
                byte[] byArray = OracleXAResource.getSerializedBytes(xid);
                callableStatement.setBytes(2, byArray);
                callableStatement.registerOutParameter(3, 2);
                callableStatement.execute();
                n = callableStatement.getInt(1);
                n2 = callableStatement.getInt(3);
                ((OracleXid)xid).setState(n2);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
            throw throwable;
        }
        try {
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
        catch (SQLException sQLException) {}
        callableStatement = null;
        this.trace("Return Status of xa_rollback is " + n);
        this.setSQLXAErrorFlag(true);
        this.checkError(n);
        this.trace("OracleXAResource.rollback():end");
    }

    private static byte[] getSerializedBytes(Xid xid) {
        try {
            return Util.serializeObject(xid);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }
}

