/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.sql.Connection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.xa.OracleXAException;

public abstract class OracleXAResource
implements XAResource {
    public static final int XA_OK = 0;
    public static final short DEFAULT_XA_TIMEOUT = 60;
    public static final int TMNOFLAGS = 0;
    public static final int TMNOMIGRATE = 2;
    public static final int TMENDRSCAN = 0x800000;
    public static final int TMFAIL = 0x20000000;
    public static final int TMJOIN = 0x200000;
    public static final int TMONEPHASE = 0x40000000;
    public static final int TMRESUME = 0x8000000;
    public static final int TMSTARTRSCAN = 0x1000000;
    public static final int TMSUCCESS = 0x4000000;
    public static final int TMSUSPEND = 0x2000000;
    protected Connection m_conn;
    protected int m_timeout = 60;
    protected String m_dblink;
    private Connection l_conn;

    public OracleXAResource() {
    }

    public OracleXAResource(Connection connection) throws XAException {
        this.m_conn = connection;
        if (this.m_conn == null) {
            throw new XAException(-7);
        }
    }

    public abstract void start(Xid var1, int var2) throws XAException;

    public abstract void end(Xid var1, int var2) throws XAException;

    public abstract void commit(Xid var1, boolean var2) throws XAException;

    public abstract int prepare(Xid var1) throws XAException;

    public abstract void forget(Xid var1) throws XAException;

    public Xid[] recover(int n, int n2) throws XAException {
        throw new XAException("recover() is not implemented");
    }

    public abstract void rollback(Xid var1) throws XAException;

    public Xid[] recover(int n) throws XAException {
        throw new XAException("recover() is not implemented");
    }

    public void resume(Xid xid) throws XAException {
        this.start(xid, 0x8000000);
    }

    public void join(Xid xid) throws XAException {
        this.start(xid, 0x200000);
    }

    public void suspend(Xid xid) throws XAException {
        this.end(xid, 0x2000000);
    }

    public void join(Xid xid, int n) throws XAException {
        this.m_timeout = n;
        this.start(xid, 0x200000);
    }

    public void resume(Xid xid, int n) throws XAException {
        this.m_timeout = n;
        this.start(xid, 0x8000000);
    }

    public Connection getConnection() {
        return this.m_conn;
    }

    public int getTransactionTimeout() throws XAException {
        return this.m_timeout;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        Connection connection = null;
        if (!(xAResource instanceof OracleXAResource)) {
            return false;
        }
        connection = ((OracleXAResource)xAResource).getConnection();
        String string = ((OracleConnection)this.m_conn).getURL();
        if (connection != null) {
            return connection.equals(this.m_conn) || ((OracleConnection)connection).getURL().equals(string);
        }
        return false;
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        if (n < 0) {
            throw new XAException(-5);
        }
        this.m_timeout = n;
        return true;
    }

    public String getDBLink() {
        return this.m_dblink;
    }

    public void setDBLink(String string) {
        this.m_dblink = string;
    }

    public void setLogicalConnection(Connection connection) {
        this.l_conn = connection;
    }

    protected void setSQLXAErrorFlag(boolean bl) {
        if (this.l_conn != null) {
            ((OracleConnection)this.l_conn).setXAErrorFlag(bl);
        }
    }

    protected boolean getSQLXAErrorFlag() {
        if (this.l_conn != null) {
            return ((OracleConnection)this.l_conn).getXAErrorFlag();
        }
        return false;
    }

    protected void checkError(int n) throws OracleXAException {
        if ((n & 0xFFFF) != 0) {
            throw new OracleXAException(n);
        }
    }

    protected void trace(String string) {
        OracleLog.print(null, 0xFFFFFFF, 1, 32, string);
    }
}

