/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import javax.transaction.xa.XAException;

public class OracleXAException
extends XAException {
    private int xa_error;
    private int primary;
    private int secondary;

    public OracleXAException() {
    }

    public OracleXAException(int n) {
        super(OracleXAException.errorConvert(n));
        this.xa_error = OracleXAException.errorConvert(n);
        this.primary = n & 0xFFFF;
        this.secondary = n >> 16;
    }

    public static int errorConvert(int n) {
        switch (n & 0xFFFF) {
            case 24756: {
                return -4;
            }
            case 25351: {
                return 4;
            }
            case 24764: {
                return 7;
            }
            case 24765: {
                return 6;
            }
            case 24766: {
                return 5;
            }
            case 24767: {
                return 3;
            }
            case 3113: 
            case 3114: {
                return -7;
            }
        }
        return -3;
    }

    public int getXAError() {
        return this.xa_error;
    }

    public int getOracleError() {
        return this.primary;
    }

    public int getOracleSQLError() {
        return this.secondary;
    }
}

