/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.util;

public class TokenizedString {
    private int MAXNUMELEMENTS = 256;
    private final int MAXELEMENTLENGTH = 256;
    private char token;
    private String str;
    private String[] elements = new String[this.MAXNUMELEMENTS];
    private int numElements;
    private int[] tokenArray = new int[this.MAXNUMELEMENTS];
    private int tokenCount;

    public TokenizedString(char c, String string) {
        this.token = c;
        this.str = string;
        this.splitString();
    }

    private void splitString() {
        char[] cArray = new char[256];
        int n = this.str.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (this.str.charAt(n3) == this.token) {
                this.tokenArray[this.tokenCount++] = n3;
                this.elements[this.numElements++] = new String(cArray, 0, n2);
                n2 = 0;
            } else {
                cArray[n2++] = this.str.charAt(n3);
            }
            ++n3;
        }
        if (this.tokenArray[this.tokenCount] < n) {
            this.elements[this.numElements++] = new String(cArray, 0, n2);
        }
    }

    public String getElement(int n) {
        if (n > this.MAXNUMELEMENTS) {
            return null;
        }
        return this.elements[n];
    }

    public int getNumElements() {
        return this.numElements;
    }

    public int getNumTokens() {
        return this.tokenCount;
    }

    public void printInfo() {
        System.out.println("String passed --> " + this.str);
        System.out.println("Token used is '" + this.token + "'");
        System.out.println("Number of tokens  :" + this.tokenCount);
        System.out.println("Number of elements:" + this.numElements);
        int n = 0;
        while (n < this.numElements) {
            System.out.println("Element " + n + " : " + this.elements[n]);
            ++n;
        }
    }
}

