/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBColumn;
import oracle.jdbc.ttc7.MAREngine;
import oracle.jdbc.ttc7.Odscrarr;
import oracle.jdbc.ttc7.TTCStatement;
import oracle.jdbc.ttc7.v8TTIuds;

public class v8Odscrarr
extends Odscrarr {
    private v8TTIuds[] uds;
    private byte operationflags = (byte)7;
    private byte[] sqltext = new byte[0];
    private long sqlparseversion = 2L;

    v8Odscrarr(MAREngine mAREngine) throws IOException, SQLException {
        super(mAREngine);
        this.funCode = (byte)98;
        this.setMarshalingEngine(mAREngine);
    }

    public void init(TTCStatement tTCStatement, int n) throws IOException, SQLException {
        super.init(tTCStatement, n);
        this.uds = null;
        this.operationflags = (byte)7;
        this.sqltext = new byte[0];
        this.sqlparseversion = 2L;
    }

    public void marshal() throws IOException {
        this.marshalFunHeader();
        this.meg.marshalUB1(this.operationflags);
        this.meg.marshalSWORD(this.cursor_id);
        if (this.sqltext.length == 0) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        this.meg.marshalSB4(this.sqltext.length);
        this.meg.marshalUB4(this.sqlparseversion);
        this.meg.marshalO2U(this.udsarrayO2U);
        this.meg.marshalO2U(this.numudsO2U);
        this.meg.marshalCHR(this.sqltext);
    }

    public DBColumn[] receive(DBColumn[] dBColumnArray) throws SQLException, IOException {
        boolean bl = false;
        while (!bl) {
            byte by = this.meg.unmarshalSB1();
            switch (by) {
                case 8: {
                    this.numuds = this.meg.unmarshalUB2();
                    this.uds = new v8TTIuds[this.numuds];
                    this.colnames = new String[this.numuds];
                    int n = 0;
                    while (n < this.numuds) {
                        this.uds[n] = new v8TTIuds(this.meg);
                        this.uds[n].unmarshal();
                        this.colnames[n] = new String(this.decodeColName(this.uds[n].getColumName(), this.uds[n].getColumNameByteLength()));
                        ++n;
                    }
                    if (dBColumnArray == null) {
                        dBColumnArray = new DBColumn[this.numuds];
                    }
                    this.fillupDBcols(dBColumnArray);
                    break;
                }
                case 4: {
                    this.oer.init();
                    this.oer.unmarshal();
                    this.oer.processError();
                    bl = true;
                    break;
                }
                case 9: {
                    bl = true;
                }
            }
        }
        return dBColumnArray;
    }

    private String decodeColName(byte[] byArray, short n) throws SQLException {
        int n2 = 0;
        char c = '\u0000';
        char[] cArray = new char[n];
        int n3 = 0;
        while (n3 < n) {
            c = this.meg.conv.CHARBytesToJavaChar(byArray, n3);
            if (c == '\'') {
                ++n3;
            }
            if (n3 >= n) continue;
            n3 = this.meg.conv.CHARBytesToJavaChar(byArray, n3, cArray, n2++);
        }
        ++n3;
        String string = new String(cArray, 0, n2);
        return string;
    }

    public void fillupDBcols(DBColumn[] dBColumnArray) throws SQLException {
        int n = 0;
        while (n < this.numuds) {
            dBColumnArray[this.colOffset + n] = new DBColumn(this.colnames[n], this.uds[n].udsnull, this.uds[n].udsoac.oacdty, this.uds[n].udsoac.oacflg, this.uds[n].udsoac.oacpre, this.uds[n].udsoac.oacscl, this.uds[n].udsoac.oacmxl, this.uds[n].udsoac.oacmal, this.uds[n].udsoac.oacfl2);
            String string = new String(this.decodeColName(this.uds[n].getTypeName(), this.uds[n].getTypeCharLength()));
            String string2 = new String(this.decodeColName(this.uds[n].getSchemaName(), this.uds[n].getSchemaCharLength()));
            dBColumnArray[this.colOffset + n].setDBColumnForV8(this.uds[n].udsoac.oactoid, this.uds[n].udsoac.oacvsn, this.uds[n].udsoac.oaccsi, this.uds[n].udsoac.oaccsfrm, String.valueOf(string2) + "." + string);
            ++n;
        }
    }
}

