/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.ttc7.MAREngine;
import oracle.jdbc.ttc7.TTIMsg;
import oracle.jdbc.util.RepConversion;

public class TTIrxh
extends TTIMsg {
    public short flags;
    public int numRqsts;
    public int iterNum;
    public int numItersThisTime;
    public int uacBufLength;
    private static final byte FU2O = 1;
    private static final byte FEOR = 2;
    private static final byte PLSV = 4;

    public TTIrxh(MAREngine mAREngine) {
        this.setMarshalingEngine(mAREngine);
    }

    public void init() {
        this.flags = 0;
        this.numRqsts = 0;
        this.iterNum = 0;
        this.numItersThisTime = 0;
        this.uacBufLength = 0;
    }

    public void unmarshal() throws SQLException, IOException {
        this.flags = this.meg.unmarshalUB1();
        this.numRqsts = this.meg.unmarshalUB1();
        this.iterNum = this.meg.unmarshalUB2();
        this.numItersThisTime = this.meg.unmarshalUB2();
        this.uacBufLength = this.meg.unmarshalUB2();
    }

    public void print() {
        System.out.println("    -------- RXH attribute information ------- ");
        System.out.println("      Flags                   0x:" + new String(RepConversion.toHex(this.flags), 0));
        if ((this.flags & 1) == 1) {
            System.out.println("           UserToOracle Function  ");
        }
        if ((this.flags & 2) == 2) {
            System.out.println("           This is the End of Row");
        }
        if ((this.flags & 4) == 4) {
            System.out.println("           Vector for PLSQL vars is following");
        }
        System.out.println("      Flags                     :" + this.flags);
        System.out.println("      Number of Requests        :" + this.numRqsts);
        System.out.println("      Iteration Number          :" + this.iterNum);
        System.out.println("      Num. Iterations this time :" + this.numItersThisTime);
        System.out.println("      UAC bufffer length        :" + this.uacBufLength);
        System.out.println("    -------- End of RXH attribute information - ");
    }
}

