/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.ttc7.MAREngine;
import oracle.jdbc.ttc7.TTIMsg;

public class TTIpro
extends TTIMsg {
    protected final boolean DEBUG = false;
    private short svrCharSet;
    private short svrCharSetElem;
    private byte svrFlags;
    protected byte[] proSvrStr;
    protected byte proSvrVer;
    protected short oVersion = (short)-1;
    private boolean svrInfoAvailable = false;
    private byte[] proCliVerTTC7;
    private byte[] proCliStrTTC7;

    public TTIpro(MAREngine mAREngine) throws SQLException, IOException {
        super((byte)1);
        byte[] byArray = new byte[5];
        byArray[0] = 4;
        byArray[1] = 3;
        byArray[2] = 2;
        byArray[3] = 1;
        this.proCliVerTTC7 = byArray;
        byte[] byArray2 = new byte[15];
        byArray2[0] = 74;
        byArray2[1] = 97;
        byArray2[2] = 118;
        byArray2[3] = 97;
        byArray2[4] = 95;
        byArray2[5] = 84;
        byArray2[6] = 84;
        byArray2[7] = 67;
        byArray2[8] = 45;
        byArray2[9] = 55;
        byArray2[10] = 46;
        byArray2[11] = 50;
        byArray2[12] = 46;
        byArray2[13] = 48;
        this.proCliStrTTC7 = byArray2;
        this.setMarshalingEngine(mAREngine);
    }

    public void receive() throws SQLException, IOException {
        if (this.meg.unmarshalSB1() != 1) {
            DBError.check_error(401);
        }
        this.proSvrVer = this.meg.unmarshalSB1();
        switch (this.proSvrVer) {
            case 4: {
                this.oVersion = (short)7230;
                break;
            }
            case 5: {
                this.oVersion = (short)8030;
                break;
            }
            default: {
                DBError.check_error(444);
            }
        }
        this.meg.unmarshalSB1();
        this.proSvrStr = this.meg.unmarshalTEXT(50);
        this.oVersion = this.getOracleVersion();
        this.svrCharSet = (short)this.meg.unmarshalUB2();
        this.svrFlags = (byte)this.meg.unmarshalUB1();
        this.svrCharSetElem = (short)this.meg.unmarshalUB2();
        if (this.svrCharSetElem > 0) {
            this.meg.unmarshalNBytes(this.svrCharSetElem * 5);
        }
        this.svrInfoAvailable = true;
    }

    public short getOracleVersion() {
        return this.oVersion;
    }

    public short getCharacterSet() {
        return this.svrCharSet;
    }

    public byte getFlags() {
        return this.svrFlags;
    }

    public void printServerInfo() {
        System.out.println("\n ---- Server's Information ---- ");
        if (this.svrInfoAvailable) {
            int n = 0;
            System.out.println("Protocol version :" + this.proSvrVer);
            System.out.println("oVersion :" + this.oVersion);
            System.out.print("Protocol string  :");
            while (n < this.proSvrStr.length) {
                System.out.print((char)this.proSvrStr[n++]);
            }
            System.out.println();
            System.out.println("Caracter Set ID  :" + this.svrCharSet);
            System.out.println("Remote flags     :" + this.svrFlags);
            System.out.println("Number of Elements in Server's Character Set Graph :" + this.svrCharSetElem);
            System.out.println("Don't expect the graph, we threw it away :-)");
        } else {
            System.out.println(" Not Available !!");
        }
        System.out.println(" ---- -------------------- ---- ");
    }

    public void marshal() throws SQLException, IOException {
        this.marshalTTCcode();
        this.meg.marshalB1Array(this.proCliVerTTC7);
        this.meg.marshalB1Array(this.proCliStrTTC7);
    }
}

