/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.ttc7.MAREngine;
import oracle.jdbc.ttc7.TTIMsg;
import oracle.jdbc.ttc7.TTIrid;

public class TTIoer
extends TTIMsg {
    private final int MAXERRBUF = 512;
    private long curRowNumber;
    private int retCode;
    private int arrayElemWError;
    private int arrayElemErrno;
    private int currCursorID;
    private short errorPosition;
    private short sqlType;
    private byte oerFatal;
    private short flags;
    private short userCursorOpt;
    private short upiParam;
    private short warningFlag;
    private TTIrid rid;
    private int osError;
    private short stmtNumber;
    private short callNumber;
    private int pad1;
    private long successIters;
    private int[] errorLength = new int[1];
    private byte[] errorMsg = new byte[512];
    public static final int ORA1403 = 1403;

    public TTIoer(MAREngine mAREngine) {
        this.setMarshalingEngine(mAREngine);
        this.rid = new TTIrid(mAREngine);
    }

    public void init() {
        this.retCode = 0;
        this.errorMsg = new byte[512];
    }

    public void unmarshal() throws IOException, SQLException {
        this.curRowNumber = this.meg.unmarshalUB4();
        this.retCode = this.meg.unmarshalUB2();
        this.arrayElemWError = this.meg.unmarshalUB2();
        this.arrayElemErrno = this.meg.unmarshalUB2();
        this.currCursorID = this.meg.unmarshalUB2();
        this.errorPosition = this.meg.unmarshalSB2();
        this.sqlType = this.meg.unmarshalUB1();
        this.oerFatal = this.meg.unmarshalSB1();
        this.flags = this.meg.unmarshalSB2();
        this.userCursorOpt = this.meg.unmarshalSB2();
        this.upiParam = this.meg.unmarshalUB1();
        this.warningFlag = this.meg.unmarshalUB1();
        this.rid.unmarshal();
        this.osError = this.meg.unmarshalSWORD();
        this.stmtNumber = this.meg.unmarshalUB1();
        this.callNumber = this.meg.unmarshalUB1();
        this.pad1 = this.meg.unmarshalUB2();
        this.successIters = this.meg.unmarshalUB4();
        if (this.retCode != 0) {
            this.errorMsg = this.meg.unmarshalCLRforREFS();
            this.errorLength[0] = this.errorMsg.length;
        }
    }

    public void print() throws SQLException {
        System.out.println("  Current Row Number    :" + this.curRowNumber);
        System.out.println("  Returned Code         :" + this.retCode);
        System.out.println("  Array Element w/error :" + this.arrayElemWError);
        System.out.println("  Array Element errno   :" + this.arrayElemErrno);
        System.out.println("  Current Cursor ID     :" + this.currCursorID);
        System.out.println("  Error Position        :" + this.errorPosition);
        System.out.println("  SQL command type      :" + this.sqlType);
        System.out.println("  Fatal                 :" + this.oerFatal);
        System.out.println("  Various flags         :" + this.flags);
        System.out.println("  User cursor options   :" + this.userCursorOpt);
        System.out.println("  UPI parameter that \n  generated the error   :" + this.upiParam);
        System.out.println("  Warning flags         :" + this.warningFlag);
        System.out.println("      Row ID structure  :");
        this.rid.print();
        System.out.println("  Operating System Error:" + this.osError);
        System.out.println("  Statemente number     :" + this.stmtNumber);
        System.out.println("  Procedure call number :" + this.callNumber);
        System.out.println("  Pad1                  :" + this.pad1);
        System.out.println("  Successful iterations :" + this.successIters);
        if (this.retCode != 0) {
            System.out.println("Error Message: " + this.meg.conv.CharBytesToString(this.errorMsg, this.errorLength[0]));
        }
    }

    public void processError() throws SQLException {
        if (this.retCode != 0) {
            DBError.throwSqlException(this.meg.conv.CharBytesToString(this.errorMsg, this.errorLength[0]), DBError.ErrorToSQLState(this.retCode), this.retCode);
        }
    }

    public int getCurRowNumber() throws SQLException {
        return (int)this.curRowNumber;
    }

    public int getRetCode() {
        return this.retCode;
    }
}

