/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.ttc7.MAREngine;
import oracle.jdbc.util.RepConversion;

public class TTIoac
extends DBType {
    public final boolean DEBUG_TTIoac = false;
    public MAREngine meg;
    protected short oacdty;
    protected short oacflg;
    protected short oacpre;
    protected short oacscl;
    protected int oacmxl;
    protected int oacmal;
    protected int oacfl2;
    private boolean oacReadyToUnmarshal = false;

    public TTIoac(int n, MAREngine mAREngine, short s) {
        super(n, s);
        this.meg = mAREngine;
        if (n == 102) {
            this.max_length = 5;
        }
    }

    public TTIoac(MAREngine mAREngine) {
        this.meg = mAREngine;
    }

    public void setFieldsForBinds(int n, int n2) throws SQLException {
        if (n2 <= 0) {
            DBError.check_error(58, new Integer(n2));
        }
        switch (n) {
            case 96: {
                this.max_length = 255;
                return;
            }
            case 1: {
                this.max_length = 2000 / n2;
                return;
            }
        }
    }

    public void setPlsqlMaxLength(int n) {
        switch (n) {
            case 1: 
            case 23: 
            case 96: 
            case 999: {
                this.max_length = Short.MAX_VALUE;
                return;
            }
            case 8: 
            case 24: {
                this.max_length = 32760;
                return;
            }
        }
    }

    public void init(DBType dBType) {
        this.oacdty = (short)dBType.type;
        this.oacmxl = dBType.max_length;
        this.is_stream = dBType.is_stream;
        this.oacReadyToUnmarshal = true;
    }

    public void unmarshal() throws IOException, SQLException {
        this.oacdty = this.meg.unmarshalUB1();
        this.oacflg = this.meg.unmarshalUB1();
        this.oacpre = this.meg.unmarshalUB1();
        this.oacscl = this.oacdty == 2 ? (short)this.meg.unmarshalUB2() : this.meg.unmarshalUB1();
        this.oacmxl = this.meg.unmarshalSB4();
        this.oacmal = this.meg.unmarshalSB4();
        this.oacfl2 = this.meg.unmarshalSB4();
        switch (this.oacdty) {
            case 2: {
                this.oacmxl = 21;
                break;
            }
            case 12: {
                this.oacmxl = 7;
            }
        }
        if (this.oacdty == 11) {
            this.oacdty = (short)104;
        }
    }

    public void marshal() throws IOException, SQLException {
        if (!this.oacReadyToUnmarshal) {
            DBError.check_error(427);
        }
        this.oacflg = 1;
        this.oacpre = 0;
        this.oacscl = 0;
        this.oacmal = 0;
        this.oacfl2 = 0;
        if (this.oacdty == 999) {
            this.oacdty = (short)96;
        }
        if (this.oacdty == 96) {
            this.oacflg = (short)(this.oacflg | 0x20);
        }
        if (this.oacdty == 11 || this.oacdty == 104) {
            this.oacdty = 1;
        }
        if (this.meg.types.getVersion() == 7230 && this.oacdty == 24) {
            this.oacdty = (short)23;
        }
        this.meg.marshalUB1(this.oacdty);
        this.meg.marshalUB1(this.oacflg);
        this.meg.marshalUB1(this.oacpre);
        this.meg.marshalUB1(this.oacscl);
        if (this.oacdty == 102) {
            this.meg.marshalSB4(1);
        } else {
            this.meg.marshalUB4(this.oacmxl);
        }
        this.meg.marshalSB4(this.oacmal);
        this.meg.marshalSB4(this.oacfl2);
    }

    public boolean isStream() throws SQLException {
        if (!this.oacReadyToUnmarshal) {
            DBError.check_error(427);
        }
        return this.is_stream;
    }

    public void print() {
        System.out.println("        ---- Enter: TTIoac.print --- ");
        System.out.println("          TTIoac.oacdty = " + this.oacdty + " (" + DBType.getStringType(this.oacdty) + ")");
        System.out.print("          TTIoac.oacflg = " + this.oacflg + "(0x");
        RepConversion.printInHex(this.oacflg);
        System.out.println(")");
        System.out.println("          TTIoac.oacpre = " + this.oacpre);
        System.out.println("          TTIoac.oacscl = " + this.oacscl);
        System.out.println("          TTIoac.oacmxl = " + this.oacmxl);
        System.out.println("          TTIoac.oacmal = " + this.oacmal);
        System.out.println("          TTIoac.oacfl2 = " + this.oacfl2);
        System.out.println("          TTIoac.isstream = " + this.is_stream);
        System.out.println("        ---- Exit: TTIoac.print --- ");
    }
}

